/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarCollector;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarDescriptor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironment;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironmentLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class StoredBuildPathEnvironmentContainer
extends StorableEnvironmentLoader {
    public static final String NODENAME = "environment";
    public static final String NODENAME_PREFIX_CFG = "buildEnvironment";
    public static final String NODENAME_CFG_INCLUDE = "buildEnvironmentInclude";
    public static final String NODENAME_CFG_LIBRARY = "buildEnvironmentLibrary";
    private IConfiguration fConfiguration;
    private StorableEnvironment fEnvironment;
    private int fPathType;
    private boolean fIsVariableCaseSensitive = ManagedBuildManager.getEnvironmentVariableProvider().isVariableCaseSensitive();

    public StoredBuildPathEnvironmentContainer(int pathType) {
        this.fPathType = pathType == 2 ? 2 : 1;
    }

    protected StorableEnvironment getEnvironment(Object context) {
        StorableEnvironment env = null;
        if (context instanceof IConfiguration) {
            if (this.fConfiguration != null && context == this.fConfiguration && this.fEnvironment != null) {
                env = this.fEnvironment;
            } else {
                env = this.loadEnvironment(context);
                if (env != null) {
                    if (this.fConfiguration != null && this.fEnvironment != null) {
                        try {
                            this.storeEnvironment(this.fEnvironment, this.fConfiguration, false);
                        }
                        catch (CoreException coreException) {}
                    }
                    this.checkLoadedVarNames(env, context);
                    this.fConfiguration = (IConfiguration)context;
                    this.fEnvironment = env;
                }
            }
        }
        return env;
    }

    private boolean haveIdenticalValues(IBuildEnvironmentVariable var1, IBuildEnvironmentVariable var2) {
        if (var1 == null) {
            return var2 == null || var2.getOperation() == 2;
        }
        if (var2 == null) {
            return var1 == null || var1.getOperation() == 2;
        }
        int op1 = var1.getOperation();
        int op2 = var2.getOperation();
        if (op1 == 2 || op2 == 2) {
            return op1 == op2;
        }
        return this.maskNull(var1.getValue()).equals(this.maskNull(var2.getValue()));
    }

    private String maskNull(String val) {
        return val == null ? "" : val;
    }

    public boolean checkBuildPathChange(EnvVarCollector existingVariables, IConfiguration configuration) {
        StorableEnvironment env = this.getEnvironment(configuration);
        if (env == null) {
            return false;
        }
        IBuildEnvironmentVariable[] vars = env.getVariables();
        int i = 0;
        while (i < vars.length) {
            IBuildEnvironmentVariable curVar;
            IBuildEnvironmentVariable var = vars[i];
            String name = var.getName();
            EnvVarDescriptor des = existingVariables != null ? existingVariables.getVariable(name) : null;
            EnvironmentVariableProvider provider = (EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider();
            IBuildEnvironmentVariable iBuildEnvironmentVariable = curVar = des != null ? provider.calculateResolvedVariable(des, provider.getContextInfo(configuration)) : null;
            if (!this.haveIdenticalValues(var, curVar)) {
                if (curVar == null) {
                    env.createVariable(name, null, 2, null);
                } else {
                    env.createVariable(curVar.getName(), curVar.getValue(), curVar.getOperation(), curVar.getDelimiter());
                }
            }
            ++i;
        }
        boolean changed = env.isChanged();
        env.setChanged(false);
        if (changed && !configuration.isTemporary()) {
            try {
                this.storeEnvironment(env, configuration, false);
            }
            catch (CoreException coreException) {}
        }
        return changed;
    }

    public boolean isVariableChanged(String name, EnvVarDescriptor variable, IConfiguration configuration) {
        IBuildEnvironmentVariable curVar;
        StorableEnvironment env = this.getEnvironment(configuration);
        if (env == null) {
            return false;
        }
        IBuildEnvironmentVariable var = env.getVariable(name);
        if (var == null) {
            return false;
        }
        EnvironmentVariableProvider provider = (EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider();
        IBuildEnvironmentVariable iBuildEnvironmentVariable = curVar = variable != null ? provider.calculateResolvedVariable(variable, provider.getContextInfo(configuration)) : null;
        return !this.haveIdenticalValues(var, curVar);
    }

    public void synchronize(EnvVarCollector existingVariables, IConfiguration configuration) {
        this.checkBuildPathChange(existingVariables, configuration);
    }

    private void checkLoadedVarNames(StorableEnvironment env, Object context) {
        String[] varNames = this.getBuildPathVarNames((IConfiguration)context, this.fPathType);
        int i = 0;
        while (i < varNames.length) {
            String name = varNames[i];
            if (env.getVariable(name) == null) {
                env.createVariable(name, null, 2, null);
            }
            ++i;
        }
        IBuildEnvironmentVariable[] vars = env.getVariables();
        int i2 = 0;
        while (i2 < vars.length) {
            IBuildEnvironmentVariable var = vars[i2];
            boolean validVar = false;
            int j = 0;
            while (j < varNames.length) {
                String varName = varNames[j];
                if (this.varNamesEqual(var.getName(), varName)) {
                    validVar = true;
                    break;
                }
                ++j;
            }
            if (!validVar) {
                env.deleteVariable(var.getName());
            }
            ++i2;
        }
    }

    private boolean varNamesEqual(String name1, String name2) {
        return this.fIsVariableCaseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    protected StorableEnvironmentLoader.ISerializeInfo getSerializeInfo(Object context) {
        StorableEnvironmentLoader.ISerializeInfo serializeInfo = null;
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            final Preferences prefs = this.getConfigurationNode(cfg);
            final String name = cfg.getId();
            if (prefs != null && name != null) {
                serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                    public Preferences getNode() {
                        return prefs;
                    }

                    public String getPrefName() {
                        return name;
                    }
                };
            }
        }
        return serializeInfo;
    }

    public void serialize(boolean force) {
        if (this.fEnvironment != null) {
            try {
                this.storeEnvironment(this.fEnvironment, this.fConfiguration, force);
            }
            catch (CoreException coreException) {}
        }
    }

    private Preferences getConfigurationNode(IConfiguration cfg) {
        IProject project = (IProject)cfg.getOwner();
        if (project == null || !project.exists()) {
            return null;
        }
        IEclipsePreferences prefNode = new ProjectScope(project).getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefNode == null) {
            return null;
        }
        if ((prefNode = prefNode.node(NODENAME)) == null) {
            return null;
        }
        if (this.fPathType == 2) {
            return prefNode.node(NODENAME_CFG_LIBRARY);
        }
        return prefNode.node(NODENAME_CFG_INCLUDE);
    }

    private String[] getBuildPathVarNames(IConfiguration configuration, int buildPathType) {
        ITool[] tools = configuration.getFilteredTools();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < tools.length) {
            IEnvVarBuildPath[] pathDescriptors = tools[i].getEnvVarBuildPaths();
            if (pathDescriptors != null && pathDescriptors.length != 0) {
                int j = 0;
                while (j < pathDescriptors.length) {
                    String[] vars;
                    IEnvVarBuildPath curPathDes = pathDescriptors[j];
                    if (curPathDes.getType() == buildPathType && (vars = curPathDes.getVariableNames()) != null && vars.length != 0) {
                        list.addAll(Arrays.asList(vars));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }
}

