/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;

public class PDOMSearchTextSelectionQuery
extends PDOMSearchQuery {
    private ITranslationUnit tu;
    private ITextSelection selection;

    public PDOMSearchTextSelectionQuery(ICElement[] scope, ITranslationUnit tu, ITextSelection selection, int flags) {
        super(scope, flags);
        this.tu = tu;
        this.selection = selection;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            ILanguage language = this.tu.getLanguage();
            IASTTranslationUnit ast = language.getASTTranslationUnit(this.tu, 3);
            IASTName[] names = language.getSelectedNames(ast, this.selection.getOffset(), this.selection.getLength());
            int i = 0;
            while (i < names.length) {
                IBinding binding = names[i].resolveBinding();
                if (binding != null) {
                    this.createMatches(language, binding);
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public String getLabel() {
        return String.valueOf(super.getLabel()) + " " + this.selection.getText();
    }
}

