/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;

public class OpenDeclarationsAction
extends SelectionParseAction {
    public static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    ITextSelection selNode;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDeclarations.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDeclarations.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDeclarations.description"));
    }

    public void run() {
        this.selNode = this.getSelectedStringFromEditor();
        if (this.selNode != null) {
            new Runner().schedule();
        }
    }

    private class Runner
    extends Job {
        Runner() {
            super(CEditorMessages.getString("OpenDeclarations.dialog.title"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IASTName searchName;
                IBinding binding;
                int selectionStart = OpenDeclarationsAction.this.selNode.getOffset();
                int selectionLength = OpenDeclarationsAction.this.selNode.getLength();
                IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(OpenDeclarationsAction.this.fEditor.getEditorInput());
                if (workingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                int style = 0;
                IASTTranslationUnit ast = workingCopy.getLanguage().getASTTranslationUnit((ITranslationUnit)workingCopy, style);
                IASTName[] selectedNames = workingCopy.getLanguage().getSelectedNames(ast, selectionStart, selectionLength);
                if (selectedNames.length > 0 && selectedNames[0] != null && (binding = (searchName = selectedNames[0]).resolveBinding()) != null && !(binding instanceof IProblemBinding)) {
                    IASTName[] declNames = ast.getDeclarations(binding);
                    if (declNames.length > 0) {
                        Display.getDefault().asyncExec(new Runnable(this, declNames){
                            final /* synthetic */ Runner this$1;
                            private final /* synthetic */ IASTName[] val$declNames;
                            {
                                this.this$1 = runner;
                                this.val$declNames = iASTNameArray;
                            }

                            public void run() {
                                try {
                                    Runner.access$0(this.this$1).open(this.val$declNames[0]);
                                }
                                catch (CoreException e) {
                                    CUIPlugin.getDefault().log(e);
                                }
                            }
                        });
                    } else if (binding instanceof PDOMBinding) {
                        PDOMBinding pdomBinding = (PDOMBinding)binding;
                        PDOMName name = pdomBinding.getFirstDefinition();
                        if (name == null) {
                            name = pdomBinding.getFirstDeclaration();
                        }
                        if (name != null) {
                            PDOMName dname = name;
                            Display.getDefault().asyncExec(new Runnable(this, (IASTName)dname){
                                final /* synthetic */ Runner this$1;
                                private final /* synthetic */ IASTName val$dname;
                                {
                                    this.this$1 = runner;
                                    this.val$dname = iASTName;
                                }

                                public void run() {
                                    try {
                                        Runner.access$0(this.this$1).open(this.val$dname);
                                    }
                                    catch (CoreException e) {
                                        CUIPlugin.getDefault().log(e);
                                    }
                                }
                            });
                        }
                    }
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ OpenDeclarationsAction access$0(Runner runner) {
            return runner.OpenDeclarationsAction.this;
        }
    }
}

