/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CElement
extends PlatformObject
implements ICElement {
    protected static final CElement[] NO_ELEMENTS = new CElement[0];
    protected int fType;
    protected ICElement fParent;
    protected String fName;
    static /* synthetic */ Class class$0;

    protected CElement(ICElement parent, String name, int type) {
        this.fParent = parent;
        this.fName = name;
        this.fType = type;
    }

    public Object getAdapter(Class adapter) {
        IResource r;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(adapter) && (r = this.getResource()) != null && adapter.isAssignableFrom(r.getClass())) {
            return r;
        }
        return super.getAdapter(adapter);
    }

    public void setElementType(int type) {
        this.fType = type;
    }

    public void setElementName(String name) {
        this.fName = name;
    }

    public void setParent(ICElement parent) {
        this.fParent = parent;
    }

    public int getElementType() {
        return this.fType;
    }

    public String getElementName() {
        return this.fName;
    }

    public ICElement getParent() {
        return this.fParent;
    }

    public IPath getPath() {
        IResource res = this.getUnderlyingResource();
        if (res != null) {
            return res.getFullPath();
        }
        return new Path(this.getElementName());
    }

    public boolean exists() {
        try {
            return this.getElementInfo() != null;
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    protected ICElement getSourceElementAtOffset(int offset) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ICElement[] children = ((Parent)this).getChildren();
            int i = 0;
            while (i < children.length) {
                ISourceReference child;
                ISourceRange range;
                int startPos;
                int endPos;
                ICElement aChild = children[i];
                if (aChild instanceof ISourceReference && offset < (endPos = (startPos = (range = (child = (ISourceReference)((Object)children[i])).getSourceRange()).getStartPos()) + range.getLength()) && offset >= startPos) {
                    if (child instanceof Parent) {
                        return ((Parent)((Object)child)).getSourceElementAtOffset(offset);
                    }
                    return (ICElement)((Object)child);
                }
                ++i;
            }
        }
        return this;
    }

    protected ICElement[] getSourceElementsAtOffset(int offset) throws CModelException {
        if (this instanceof ISourceReference && this instanceof Parent) {
            ArrayList<Object> list = new ArrayList<Object>();
            ICElement[] children = ((Parent)this).getChildren();
            int i = 0;
            while (i < children.length) {
                ISourceReference child;
                ISourceRange range;
                int startPos;
                int endPos;
                ICElement aChild = children[i];
                if (aChild instanceof ISourceReference && offset < (endPos = (startPos = (range = (child = (ISourceReference)((Object)children[i])).getSourceRange()).getStartPos()) + range.getLength()) && offset >= startPos) {
                    if (child instanceof Parent) {
                        ICElement[] elements = ((Parent)((Object)child)).getSourceElementsAtOffset(offset);
                        list.addAll(Arrays.asList(elements));
                    }
                    list.add(child);
                }
                ++i;
            }
            children = new ICElement[list.size()];
            list.toArray(children);
            return children;
        }
        return new ICElement[]{this};
    }

    public boolean isReadOnly() {
        ResourceAttributes attributes;
        IResource r = this.getUnderlyingResource();
        if (r != null && (attributes = r.getResourceAttributes()) != null) {
            return attributes.isReadOnly();
        }
        return false;
    }

    public boolean isStructureKnown() throws CModelException {
        return this.getElementInfo().isStructureKnown();
    }

    public ICModel getCModel() {
        ICElement current = this;
        do {
            if (!(current instanceof ICModel)) continue;
            return (ICModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ICProject getCProject() {
        ICElement current = this;
        do {
            if (!(current instanceof ICProject)) continue;
            return (ICProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected void addChild(ICElement e) throws CModelException {
    }

    public IResource getUnderlyingResource() {
        ICElement p;
        IResource res = this.getResource();
        if (res == null && (p = this.getParent()) != null) {
            res = p.getUnderlyingResource();
        }
        return res;
    }

    public abstract IResource getResource();

    protected abstract CElementInfo createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CElement) {
            CElement other = (CElement)o;
            if (this.fName == null || other.fName == null) {
                return false;
            }
            if (this.fName.length() == 0 || other.fName.length() == 0) {
                return false;
            }
            if (this.fType != other.fType) {
                return false;
            }
            if (this.fName.equals(other.fName)) {
                if (this.fParent != null && this.fParent.equals(other.fParent)) {
                    return true;
                }
                if (this.fParent == null && other.fParent == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public CElementInfo getElementInfo() throws CModelException {
        return this.getElementInfo(null);
    }

    public CElementInfo getElementInfo(IProgressMonitor monitor) throws CModelException {
        CModelManager manager = CModelManager.getDefault();
        CElementInfo info = (CElementInfo)manager.getInfo(this);
        if (info != null) {
            return info;
        }
        info = this.createElementInfo();
        this.openWhenClosed(info, monitor);
        return info;
    }

    public String toString() {
        return this.getElementName();
    }

    public String toDebugString() {
        return String.valueOf(this.getElementName()) + " " + this.getTypeString();
    }

    public String getTypeString() {
        switch (this.getElementType()) {
            case 10: {
                return "CMODEL";
            }
            case 11: {
                return "CPROJECT";
            }
            case 12: {
                if (this instanceof ISourceRoot) {
                    return "SOURCE_ROOT";
                }
                return "CCONTAINER";
            }
            case 60: {
                if (this instanceof IWorkingCopy) {
                    return "WORKING_UNIT";
                }
                return "TRANSLATION_UNIT";
            }
            case 74: {
                return "C_FUNCTION";
            }
            case 73: {
                return "C_FUNCTION_DECLARATION";
            }
            case 76: {
                return "C_VARIABLE";
            }
            case 77: {
                return "C_VARIABLE_DECLARATION";
            }
            case 75: {
                return "C_INCLUDE";
            }
            case 79: {
                return "C_MACRO";
            }
            case 67: {
                return "C_STRUCT";
            }
            case 65: {
                return "C_CLASS";
            }
            case 69: {
                return "C_UNION";
            }
            case 72: {
                return "C_FIELD";
            }
            case 70: {
                return "C_METHOD";
            }
            case 61: {
                return "C_NAMESPACE";
            }
            case 62: {
                return "C_USING";
            }
            case 30: {
                return "C_CONTAINER";
            }
            case 14: {
                return "C_BINARY";
            }
            case 18: {
                return "C_ARCHIVE";
            }
        }
        return "UNKNOWN";
    }

    public void close() throws CModelException {
        CModelManager.getDefault().releaseCElement(this);
    }

    protected void closing(Object info) throws CModelException {
    }

    protected void opening(Object info) {
    }

    public IOpenable getOpenableParent() {
        if (this.fParent instanceof IOpenable) {
            return (IOpenable)((Object)this.fParent);
        }
        return null;
    }

    protected abstract void generateInfos(Object var1, Map var2, IProgressMonitor var3) throws CModelException;

    /*
     * Exception decompiling
     */
    protected void openWhenClosed(CElementInfo info, IProgressMonitor pm) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 136->140)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ICElement getAncestor(int ancestorType) {
        ICElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public boolean isAncestorOf(ICElement e) {
        ICElement parent = e.getParent();
        while (parent != null && !parent.equals(this)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    protected CModelException newNotPresentException() {
        return new CModelException(new CModelStatus(969, this));
    }

    public int hashCode() {
        if (this.fParent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.fName.hashCode(), this.fParent.hashCode());
    }

    public boolean isIdentical(CElement otherElement) {
        return this.equals(otherElement);
    }

    public void accept(ICElementVisitor visitor) throws CoreException {
        if (!visitor.visit(this)) {
            return;
        }
        if (this instanceof IParent) {
            ICElement[] children = ((IParent)((Object)this)).getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].accept(visitor);
                ++i;
            }
        }
    }
}

