/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CommitWorkingCopyOperation
extends CModelOperation {
    static /* synthetic */ Class class$0;

    public CommitWorkingCopyOperation(ITranslationUnit element, boolean force) {
        super(new ICElement[]{element}, force);
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getElementToProcess().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws CModelException {
        block26: {
            block25: {
                try {
                    char[] originalContents;
                    IBuffer wcBuffer;
                    IBuffer tuBuffer;
                    boolean hasSaved;
                    CElementDeltaBuilder deltaBuilder;
                    ITranslationUnit tu;
                    WorkingCopy wc;
                    block28: {
                        block27: {
                            this.beginTask("workingCopy.commit", 2);
                            wc = (WorkingCopy)this.getElementToProcess();
                            tu = wc.getOriginalElement();
                            if (!tu.isOpen()) {
                                tu.open(null);
                            }
                            deltaBuilder = new CElementDeltaBuilder(tu);
                            hasSaved = false;
                            tuBuffer = tu.getBuffer();
                            wcBuffer = wc.getBuffer();
                            if (wcBuffer == null) break block27;
                            if (tuBuffer != null) break block28;
                        }
                        Object var11_7 = null;
                        break block25;
                    }
                    ITextFileBuffer tuFileBuffer = null;
                    Object wcFileBuffer = null;
                    if (tuBuffer instanceof IAdaptable) {
                        IAdaptable iAdaptable = (IAdaptable)tuBuffer;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("org.eclipse.core.filebuffers.ITextFileBuffer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz2;
                        }
                        tuFileBuffer = (ITextFileBuffer)iAdaptable.getAdapter((Class)clazz);
                    }
                    if (wcBuffer instanceof IAdaptable) {
                        IAdaptable iAdaptable = (IAdaptable)wcBuffer;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.core.filebuffers.ITextFileBuffer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz3;
                        }
                        wcFileBuffer = (ITextFileBuffer)iAdaptable.getAdapter((Class)clazz);
                    }
                    if (wcFileBuffer != null) {
                        if (wcFileBuffer.equals(tuFileBuffer)) {
                            tu.save(this.fMonitor, this.fForce);
                            hasSaved = true;
                        } else if (wcFileBuffer.getLocation().equals((Object)tu.getPath())) {
                            originalContents = tuBuffer.getCharacters();
                            try {
                                wcFileBuffer.commit(this.fMonitor, this.fForce);
                                tuBuffer.setContents(wcBuffer.getCharacters());
                                tu.makeConsistent(null);
                                hasSaved = true;
                            }
                            catch (CoreException e) {
                                tuBuffer.setContents(originalContents);
                                throw new CModelException(e);
                            }
                        }
                    }
                    if (!hasSaved) {
                        originalContents = tuBuffer.getCharacters();
                        try {
                            tuBuffer.setContents(wcBuffer.getCharacters());
                            tu.save(this.fMonitor, this.fForce);
                        }
                        catch (CModelException e) {
                            tuBuffer.setContents(originalContents);
                            throw e;
                        }
                    }
                    this.hasModifiedResource = true;
                    wc.updateTimeStamp((TranslationUnit)tu);
                    wc.makeConsistent(this);
                    this.worked(1);
                    if (deltaBuilder != null) {
                        deltaBuilder.buildDeltas();
                        if (deltaBuilder.delta != null) {
                            this.addDelta(deltaBuilder.delta);
                        }
                    }
                    this.worked(1);
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var11_9 = null;
        this.done();
    }

    public ICModelStatus verify() {
        IWorkingCopy wc = (IWorkingCopy)this.getElementToProcess();
        if (!wc.isWorkingCopy()) {
            return new CModelStatus(967, wc);
        }
        ITranslationUnit original = wc.getOriginalElement();
        IResource resource = original.getResource();
        if (!wc.isBasedOn(resource) && !this.fForce) {
            return new CModelStatus(981);
        }
        return CModelStatus.VERIFIED_OK;
    }
}

