/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.Signature;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;

public class TypeUtil {
    public static boolean isDeclaringType(ICElement elem) {
        int type = elem.getElementType();
        return type == 65 || type == 67 || type == 63 || type == 69 || type == 80 || type == 61;
    }

    public static boolean isMemberType(ICElement elem) {
        int type = elem.getElementType();
        if (type == 65 || type == 67 || type == 63 || type == 69 || type == 80 || type == 61) {
            return true;
        }
        return elem instanceof IMember;
    }

    public static ICElement getDeclaringType(ICElement elem) {
        if (!TypeUtil.isMemberType(elem)) {
            return null;
        }
        ICElement parent = elem.getParent();
        while (parent != null && !(parent instanceof ITranslationUnit)) {
            if (TypeUtil.isDeclaringType(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static ICElement getDeclaringClass(ICElement type) {
        ICElement parentElement = type.getParent();
        if (parentElement != null && TypeUtil.isClassOrStruct(parentElement)) {
            return parentElement;
        }
        if (TypeUtil.isClassOrStruct(type)) {
            while (parentElement != null) {
                if (TypeUtil.isClassOrStruct(parentElement)) {
                    return parentElement;
                }
                if (parentElement instanceof IMember) {
                    parentElement = parentElement.getParent();
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isClassOrStruct(ICElement type) {
        int kind = type.getElementType();
        return kind == 65 || kind == 67;
    }

    public static boolean isClass(ICElement type) {
        return type.getElementType() == 65;
    }

    public static boolean isNamespace(ICElement type) {
        return type.getElementType() == 61;
    }

    public static ICElement[] getTypes(ITranslationUnit tu) throws CModelException {
        ArrayList<ICElement> typeList = new ArrayList<ICElement>();
        ICElement[] children = tu.getChildren();
        int i = 0;
        while (i < children.length) {
            if (TypeUtil.isDeclaringType(children[i])) {
                typeList.add(children[i]);
            }
            ++i;
        }
        return typeList.toArray(new ICElement[typeList.size()]);
    }

    public static ICElement[] getAllTypes(ITranslationUnit tu) throws CModelException {
        ICElement[] types = TypeUtil.getTypes(tu);
        ArrayList<ICElement> allTypes = new ArrayList<ICElement>(types.length);
        ArrayList<ICElement> typesToTraverse = new ArrayList<ICElement>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            ICElement type = (ICElement)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = TypeUtil.getTypes(type);
            int i2 = 0;
            while (i2 < types.length) {
                typesToTraverse.add(types[i2]);
                ++i2;
            }
        }
        return allTypes.toArray(new ICElement[allTypes.size()]);
    }

    public static ICElement[] getTypes(ICElement elem) throws CModelException {
        ArrayList<ICElement> typeList = new ArrayList<ICElement>();
        if (TypeUtil.isDeclaringType(elem) && elem instanceof IParent) {
            ICElement[] children = ((IParent)((Object)elem)).getChildren();
            int i = 0;
            while (i < children.length) {
                if (TypeUtil.isDeclaringType(children[i])) {
                    typeList.add(children[i]);
                }
                ++i;
            }
        }
        return typeList.toArray(new ICElement[typeList.size()]);
    }

    public static ITranslationUnit getTranslationUnit(ICElement elem) {
        while (elem != null) {
            if (elem instanceof ITranslationUnit) {
                return (ITranslationUnit)elem;
            }
            elem = elem.getParent();
        }
        return null;
    }

    public static IQualifiedTypeName getFullyQualifiedName(ICElement type) {
        String name = type.getElementName();
        IQualifiedTypeName qualifiedName = new QualifiedTypeName(name);
        ICElement parent = type.getParent();
        while (parent != null && (TypeUtil.isNamespace(parent) || TypeUtil.isClass(parent))) {
            qualifiedName = new QualifiedTypeName(parent.getElementName()).append(qualifiedName);
            parent = parent.getParent();
        }
        return qualifiedName;
    }

    public static IMethodDeclaration[] getMethods(ICElement elem) {
        if (elem instanceof IStructure) {
            try {
                List list = ((IParent)((Object)elem)).getChildrenOfType(71);
                if (list != null && !list.isEmpty()) {
                    return list.toArray(new IMethodDeclaration[list.size()]);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public static ICElement[] getFields(ICElement elem) {
        if (elem instanceof IStructure) {
            try {
                List list = ((IParent)((Object)elem)).getChildrenOfType(72);
                if (list != null && !list.isEmpty()) {
                    return list.toArray(new ICElement[list.size()]);
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public static IMethodDeclaration findMethod(String name, String[] paramTypes, boolean isConstructor, boolean isDestructor, IMethodDeclaration[] methods) throws CModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (TypeUtil.isSameMethodSignature(name, paramTypes, isConstructor, isDestructor, methods[i])) {
                return methods[i];
            }
            --i;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, boolean isDestructor, IMethodDeclaration curr) throws CModelException {
        String[] currParamTypes;
        if ((isConstructor || isDestructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && isDestructor == curr.isDestructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName(Signature.toString(paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName(Signature.toString(currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static IMethodDeclaration findMethod(String name, String[] paramTypes, boolean isConstructor, boolean isDestructor, ICElement type) throws CModelException {
        return TypeUtil.findMethod(name, paramTypes, isConstructor, isDestructor, TypeUtil.getMethods(type));
    }
}

