/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.File;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.util.ILRUCacheable;
import org.eclipse.cdt.internal.core.util.LRUCache;
import org.eclipse.cdt.internal.core.util.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CodeReaderCache
implements ICodeReaderCache {
    public static final String CODE_READER_BUFFER = "CODE_READER_CACHE";
    public static final int DEFAULT_CACHE_SIZE_IN_MB = 64;
    public static final String DEFAULT_CACHE_SIZE_IN_MB_STRING = String.valueOf(64);
    private static final int MB_TO_KB_FACTOR = 1024;
    private CodeReaderLRUCache cache = null;
    private IResourceChangeListener listener = new UpdateCodeReaderCacheListener(this);

    public CodeReaderCache(int size) {
        this.cache = new CodeReaderLRUCache(size * 1024);
        if (ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (ResourcesPlugin.getWorkspace() != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    public synchronized CodeReader get(String key) {
        CodeReader ret = null;
        if (this.cache.getSpaceLimit() > 0) {
            ret = this.cache.get(key);
        }
        if (ret == null) {
            if (!new File(key).exists()) {
                return null;
            }
            ret = ParserUtil.createReader(key, EmptyIterator.EMPTY_ITERATOR);
            if (this.cache.getSpaceLimit() > 0) {
                this.put(ret);
            }
        }
        return ret;
    }

    private synchronized CodeReader put(CodeReader value) {
        if (value == null) {
            return null;
        }
        return this.cache.put((Object)String.valueOf(value.filename), value);
    }

    public void setCacheSize(int size) {
        this.cache.setSpaceLimit(size * 1024);
    }

    public synchronized CodeReader remove(String key) {
        return this.cache.remove(key);
    }

    public int getCurrentSpace() {
        return this.cache.getCurrentSpace();
    }

    public void flush() {
        this.cache.flush();
    }

    private class UpdateCodeReaderCacheListener
    implements IResourceChangeListener {
        ICodeReaderCache c = null;

        public UpdateCodeReaderCacheListener(ICodeReaderCache cache) {
            this.c = cache;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.c instanceof CodeReaderCache) {
                new RemoveCacheJob(this.c, event).schedule();
            }
        }

        private class RemoveCacheJob
        extends Job {
            private static final String REMOVE_CACHE = "Remove Cache";
            ICodeReaderCache cache1;
            IResourceChangeEvent event;

            public RemoveCacheJob(ICodeReaderCache cache, IResourceChangeEvent event) {
                super(REMOVE_CACHE);
                this.cache1 = null;
                this.event = null;
                this.cache1 = cache;
                this.event = event;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (this.event.getSource() instanceof IWorkspace && this.event.getDelta() != null) {
                    this.removeKeys(this.event.getDelta().getAffectedChildren());
                }
                return Status.OK_STATUS;
            }

            private void removeKeys(IResourceDelta[] deltas) {
                int j = 0;
                while (j < deltas.length) {
                    if (deltas[j].getResource().getType() == 4 || deltas[j].getResource().getType() == 2) {
                        this.removeKeys(deltas[j].getAffectedChildren());
                    } else if (deltas[j].getResource() instanceof IFile && ((IFile)deltas[j].getResource()).getLocation() != null) {
                        this.removeKey(((IFile)deltas[j].getResource()).getLocation().toOSString());
                    }
                    ++j;
                }
            }

            private void removeKey(String key) {
                if (key != null && this.cache1 != null) {
                    this.cache1.remove(key);
                }
            }
        }
    }

    private class CodeReaderLRUCache
    extends OverflowingLRUCache {
        public CodeReaderLRUCache(int size) {
            this.setSpaceLimit(size);
        }

        protected boolean close(LRUCache.LRUCacheEntry entry) {
            Object obj = this.remove(entry._fKey);
            return obj != null;
        }

        protected LRUCache newInstance(int size, int overflow) {
            return null;
        }

        public CodeReader remove(String key) {
            Object removed = this.removeKey(key);
            if (removed instanceof CodeReaderCacheEntry) {
                return ((CodeReaderCacheEntry)removed).getCodeReader();
            }
            return null;
        }

        public CodeReader put(Object key, CodeReader value) {
            CodeReaderCacheEntry entry = new CodeReaderCacheEntry(value);
            Object ret = this.put(key, entry);
            if (ret instanceof CodeReaderCacheEntry) {
                return ((CodeReaderCacheEntry)ret).getCodeReader();
            }
            return null;
        }

        public CodeReader get(String key) {
            Object obj = this.peek(key);
            if (obj instanceof CodeReaderCacheEntry) {
                return ((CodeReaderCacheEntry)obj).getCodeReader();
            }
            return null;
        }

        private class CodeReaderCacheEntry
        implements ILRUCacheable {
            private static final double CHAR_TO_KB_FACTOR = 1024.0;
            CodeReader reader = null;
            int size = 0;

            public CodeReaderCacheEntry(CodeReader value) {
                this.reader = value;
                this.size = (int)Math.ceil((double)this.reader.buffer.length / 1024.0);
            }

            public int getCacheFootprint() {
                return this.size;
            }

            public CodeReader getCodeReader() {
                return this.reader;
            }
        }
    }
}

