/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.swt.widgets.FileDialog;

public class ImportExecutableWizard
extends AbstractImportExecutableWizard {
    public String getPageOneTitle() {
        return Messages.ImportExecutableWizard_pageOneTitle;
    }

    public String getPageOneDescription() {
        return Messages.ImportExecutableWizard_pageOneDescription;
    }

    public String getExecutableListLabel() {
        return Messages.ImportExecutableWizard_executableListLabel;
    }

    public void setupFileDialog(FileDialog dialog) {
        dialog.setText(Messages.ImportExecutableWizard_fileDialogTitle);
        dialog.setFilterExtensions(new String[]{"*.*", "*.exe", "*.dll"});
        dialog.setFilterNames(new String[]{Messages.ImportExecutableWizard_AllFiles, Messages.ImportExecutableWizard_Applications, Messages.ImportExecutableWizard_LIbaries});
    }

    public void addBinaryParsers(IProject newProject) throws CoreException {
        ICDescriptorOperation op = new ICDescriptorOperation(){

            public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                descriptor.remove("org.eclipse.cdt.core.BinaryParser");
                descriptor.create("org.eclipse.cdt.core.BinaryParser", ImportExecutableWizard.this.pageOne.getSelectedBinaryParserId());
            }
        };
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(newProject.getProject(), op, null);
    }

    public boolean supportsConfigurationType(ILaunchConfigurationType type) {
        return type.getIdentifier().startsWith("org.eclipse.cdt.launch") || type.getIdentifier().startsWith("com.qnx");
    }

    public boolean isExecutableFile(File file) {
        String filename = file.getName().toLowerCase();
        if (Platform.getOS().equals("macosx")) {
            return true;
        }
        return filename.endsWith(".exe") || filename.endsWith(".dll") || filename.endsWith(".elf");
    }
}

