/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.Arrays;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.IContainerDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.ProjectContainerDescriptor;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.internal.ui.viewsupport.ListContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CPathContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "CPathContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private TableViewer fListViewer;
    private IContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected CPathContainerSelectionPage(IContainerDescriptor[] containerPages) {
        super("CPathContainerWizardPage");
        this.setTitle(CPathEntryMessages.getString("CPathContainerSelectionPage.title"));
        this.setDescription(CPathEntryMessages.getString("CPathContainerSelectionPage.description"));
        this.setImageDescriptor(CPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new TableViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new CPathContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fListViewer.setSorter((ViewerSorter)new CPathContainerSorter());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CPathContainerSelectionPage.this.validatePage();
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CPathContainerSelectionPage.this.doDoubleClick();
            }
        });
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getTable().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getTable());
        Dialog.applyDialogFont((Control)this.fListViewer.getTable());
    }

    void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public IContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (IContainerDescriptor)SelectionUtil.getSingleElement(selection);
        }
        return null;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getTable().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class CPathContainerLabelProvider
    extends LabelProvider {
        private CPathContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((IContainerDescriptor)element).getName();
        }

        public Image getImage(Object element) {
            return ((IContainerDescriptor)element).getImage();
        }
    }

    private static class CPathContainerSorter
    extends ViewerSorter {
        private CPathContainerSorter() {
        }

        public int category(Object element) {
            if (element instanceof ProjectContainerDescriptor) {
                return 0;
            }
            return 1;
        }
    }
}

