/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.debug.dwarf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.debug.IDebugEntryRequestor;
import org.eclipse.cdt.utils.debug.dwarf.Dwarf;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.Path;

public class DwarfReader
extends Dwarf
implements ISymbolReader {
    static final String[] DWARF_SectionsToParse = new String[]{".debug_info", ".debug_line", ".debug_abbrev", ".debug_str"};
    ArrayList fileList;
    String[] files = null;
    boolean m_parsed = false;
    private int m_leb128Size = 0;

    public DwarfReader(String file) throws IOException {
        super(file);
    }

    public DwarfReader(Elf exe) throws IOException {
        super(exe);
    }

    public void init(Elf exe) throws IOException {
        Elf.ELFhdr header = exe.getELFhdr();
        this.isLE = header.e_ident[5] == 1;
        Elf.Section[] sections = exe.getSections();
        int i = 0;
        while (i < sections.length) {
            String name = sections[i].toString();
            int j = 0;
            while (j < DWARF_SectionsToParse.length) {
                if (name.equals(DWARF_SectionsToParse[j])) {
                    this.dwarfSections.put(DWARF_SectionsToParse[j], sections[i].loadSectionData());
                }
                ++j;
            }
            ++i;
        }
        this.printEnabled = false;
        this.m_parsed = false;
        this.fileList = new ArrayList();
    }

    void parseSourceInCULineInfo(String cuCompDir, int cuStmtList) {
        byte[] data = (byte[])this.dwarfSections.get(".debug_line");
        if (data != null) {
            try {
                String fileName;
                String str;
                int offset = cuStmtList;
                offset += 14;
                byte opcode_base = data[offset++];
                offset += opcode_base - 1;
                ArrayList<String> dirList = new ArrayList<String>();
                dirList.add(cuCompDir);
                while ((str = this.readString(data, offset)).length() != 0) {
                    dirList.add(str);
                    offset += str.length() + 1;
                }
                ++offset;
                while ((fileName = this.readString(data, offset)).length() != 0) {
                    long leb128 = this.read_unsigned_leb128(data, offset += fileName.length() + 1);
                    this.addSourceFile((String)dirList.get((int)leb128), fileName);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    leb128 = this.read_unsigned_leb128(data, offset += this.m_leb128Size);
                    offset += this.m_leb128Size;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String[] getSourceFiles() {
        if (!this.m_parsed) {
            this.parse(null);
            this.m_parsed = true;
            this.files = new String[this.fileList.size()];
            this.fileList.toArray(this.files);
        }
        return this.files;
    }

    private void addSourceFile(String dir, String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (name.charAt(0) == '<') {
            return;
        }
        String fullName = name;
        Path pa = new Path(name);
        if (!pa.isAbsolute() && dir.length() > 0) {
            fullName = String.valueOf(dir) + File.separatorChar + name;
        }
        if (!this.fileList.contains(fullName = (pa = new Path(fullName)).toOSString())) {
            this.fileList.add(fullName);
        }
    }

    String readString(byte[] data, int offset) {
        StringBuffer sb = new StringBuffer();
        while (offset < data.length) {
            byte c = data[offset];
            if (c == 0) break;
            sb.append((char)c);
            ++offset;
        }
        String str = sb.toString();
        return str;
    }

    long read_unsigned_leb128(byte[] data, int offset) throws IOException {
        short b;
        long result = 0L;
        int shift = 0;
        this.m_leb128Size = 0;
        while ((b = (short)data[offset++]) != -1) {
            ++this.m_leb128Size;
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return result;
    }

    void processDebugInfoEntry(IDebugEntryRequestor requestor, Dwarf.AbbreviationEntry entry, List list) {
        int tag = (int)entry.tag;
        switch (tag) {
            case 17: {
                this.processCompileUnit(requestor, list);
                break;
            }
        }
    }

    void processCompileUnit(IDebugEntryRequestor requestor, List list) {
        int stmtList = -1;
        String cuCompDir = "";
        String cuName = "";
        int i = 0;
        while (i < list.size()) {
            Dwarf.AttributeValue av = (Dwarf.AttributeValue)list.get(i);
            try {
                int name = (int)av.attribute.name;
                switch (name) {
                    case 3: {
                        cuName = (String)av.value;
                        break;
                    }
                    case 27: {
                        cuCompDir = (String)av.value;
                        break;
                    }
                    case 16: {
                        stmtList = ((Number)av.value).intValue();
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        this.addSourceFile(cuCompDir, cuName);
        if (stmtList > -1) {
            this.parseSourceInCULineInfo(cuCompDir, stmtList);
        }
    }
}

