/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.full;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexerJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class PDOMFullReindex
extends PDOMFullIndexerJob {
    public PDOMFullReindex(PDOMFullIndexer indexer) throws CoreException {
        super(indexer);
    }

    public void run(final IProgressMonitor monitor) {
        block3: {
            try {
                long start = System.currentTimeMillis();
                this.pdom.clear();
                this.indexer.getProject().accept(new ICElementVisitor(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean visit(ICElement element) throws CoreException {
                        if (monitor.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        switch (element.getElementType()) {
                            case 60: {
                                ITranslationUnit tu = (ITranslationUnit)element;
                                if (!tu.isSourceUnit()) return false;
                                try {
                                    PDOMFullReindex.this.addTU(tu);
                                    return false;
                                }
                                catch (Throwable e) {
                                    CCorePlugin.log(e);
                                    if (++PDOMFullReindex.this.errorCount <= 10) return false;
                                    throw new CoreException(Status.CANCEL_STATUS);
                                }
                            }
                            case 11: 
                            case 12: {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                this.indexer.getProject().accept(new ICElementVisitor(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean visit(ICElement element) throws CoreException {
                        if (monitor.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        switch (element.getElementType()) {
                            case 60: {
                                IFile rfile;
                                String filename;
                                ITranslationUnit tu = (ITranslationUnit)element;
                                if (!tu.isHeaderUnit() || PDOMFullReindex.this.pdom.getFile(filename = (rfile = (IFile)tu.getUnderlyingResource()).getLocation().toOSString()) != null) return false;
                                try {
                                    PDOMFullReindex.this.addTU(tu);
                                    return false;
                                }
                                catch (InterruptedException e) {
                                    CCorePlugin.log(e);
                                    if (++PDOMFullReindex.this.errorCount <= 10) return false;
                                    throw new CoreException(Status.CANCEL_STATUS);
                                }
                            }
                            case 11: 
                            case 12: {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
                if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
                    System.out.println("PDOM Full Reindex Time: " + (System.currentTimeMillis() - start) + " " + this.indexer.getProject().getElementName());
                }
            }
            catch (CoreException e) {
                if (e.getStatus() == Status.CANCEL_STATUS) break block3;
                CCorePlugin.log(e);
            }
        }
    }
}

