/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractBuildPropertyPage
extends PropertyPage {
    private Map clonedConfigMap;

    private Map getClonedConfigMap() {
        if (this.clonedConfigMap == null) {
            this.clonedConfigMap = new HashMap();
        }
        return this.clonedConfigMap;
    }

    public IConfiguration getClonedConfig(IConfiguration config) {
        IConfiguration clonedCfg = (IConfiguration)this.getClonedConfigMap().get(config.getId());
        if (clonedCfg == null) {
            clonedCfg = new Configuration((ManagedProject)config.getManagedProject(), (Configuration)config, ManagedBuildManager.calculateChildId((String)config.getId(), null), true, true);
            this.getClonedConfigMap().put(config.getId(), clonedCfg);
        }
        return clonedCfg;
    }

    public IConfiguration getRealConfig(IConfiguration config) {
        Set set = this.getClonedConfigMap().entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!entry.getValue().equals(config)) continue;
            return config.getManagedProject().getConfiguration((String)entry.getKey());
        }
        return null;
    }

    public IToolChain getClonedToolChain(IToolChain toolChain) {
        return this.getClonedConfig(toolChain.getParent()).getToolChain();
    }

    public IToolChain getRealToolChain(IToolChain toolChain) {
        IConfiguration cfg = this.getRealConfig(toolChain.getParent());
        if (cfg != null) {
            return cfg.getToolChain();
        }
        return null;
    }

    public IHoldsOptions getClonedHoldsOptions(IHoldsOptions ho) {
        if (ho instanceof IToolChain) {
            return this.getClonedToolChain((IToolChain)ho);
        }
        if (ho instanceof ITool) {
            return this.getClonedTool((ITool)ho);
        }
        return null;
    }

    public IHoldsOptions getRealHoldsOptions(IHoldsOptions ho) {
        if (ho instanceof IToolChain) {
            return this.getRealToolChain((IToolChain)ho);
        }
        if (ho instanceof ITool) {
            return this.getRealTool((ITool)ho);
        }
        return null;
    }

    public IResourceConfiguration getClonedRcConfig(IResourceConfiguration rcCfg) {
        return this.getClonedConfig(rcCfg.getParent()).getResourceConfiguration(rcCfg.getResourcePath());
    }

    public IResourceConfiguration getRealRcConfig(IResourceConfiguration rcCfg) {
        IConfiguration cfg = this.getRealConfig(rcCfg.getParent());
        if (cfg != null) {
            return cfg.getResourceConfiguration(rcCfg.getResourcePath());
        }
        return null;
    }

    public ITool getClonedTool(ITool tool) {
        IConfiguration cfg = this.getConfigurationFromTool(tool);
        if (cfg != null) {
            return this.getToolForConfig(this.getClonedConfig(cfg), tool);
        }
        return null;
    }

    public ITool getRealTool(ITool tool) {
        IConfiguration cfg = this.getConfigurationFromTool(tool);
        if (cfg != null && (cfg = this.getRealConfig(cfg)) != null) {
            return this.getToolForConfig(cfg, tool);
        }
        return null;
    }

    protected ITool getToolForConfig(IConfiguration cfg, ITool tool) {
        block6: {
            block5: {
                if (!(tool.getParent() instanceof IToolChain)) break block5;
                ITool[] tools = cfg.getTools();
                int i = 0;
                while (i < tools.length) {
                    if (tool.getSuperClass() != null && tools[i].getSuperClass() != null && tools[i].getSuperClass().getId().equals(tool.getSuperClass().getId())) {
                        return tools[i];
                    }
                    ++i;
                }
                break block6;
            }
            if (!(tool.getParent() instanceof IResourceConfiguration)) break block6;
            IResourceConfiguration rcCfg = (IResourceConfiguration)tool.getParent();
            IResourceConfiguration otherRcCfg = cfg.getResourceConfiguration(rcCfg.getResourcePath());
            ITool[] tools = otherRcCfg.getTools();
            ITool superTool = tool.getSuperClass();
            if (superTool != null && (superTool = superTool.getSuperClass()) != null) {
                int i = 0;
                while (i < tools.length) {
                    ITool otherSuperTool = tools[i].getSuperClass();
                    if (otherSuperTool != null && (otherSuperTool = otherSuperTool.getSuperClass()) != null && otherSuperTool.getId().equals(superTool.getId())) {
                        return tools[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public IConfiguration getConfigurationFromTool(ITool tool) {
        IBuildObject bo = tool.getParent();
        if (bo instanceof IToolChain) {
            return ((IToolChain)bo).getParent();
        }
        if (bo instanceof IResourceConfiguration) {
            return ((IResourceConfiguration)bo).getParent();
        }
        return null;
    }

    public IConfiguration getConfigurationFromHoldsOptions(IHoldsOptions ho) {
        if (ho instanceof IToolChain) {
            return ((IToolChain)ho).getParent();
        }
        if (ho instanceof ITool) {
            return this.getConfigurationFromTool((ITool)ho);
        }
        return null;
    }

    public IOption getClonedOption(IOption option, IHoldsOptions ho) {
        IHoldsOptions clonedHo = this.getClonedHoldsOptions(ho);
        if (clonedHo != null) {
            return this.getOptionForHoldsOptions(clonedHo, option);
        }
        return null;
    }

    public IOption getRealOption(IOption option, IHoldsOptions ho) {
        IHoldsOptions realHo = this.getRealHoldsOptions(ho);
        if (realHo != null) {
            return this.getOptionForHoldsOptions(realHo, option);
        }
        return null;
    }

    protected IOption getOptionForHoldsOptions(IHoldsOptions ho, IOption otherOption) {
        IOption opt = null;
        if (otherOption.isExtensionElement()) {
            opt = ho.getOptionBySuperClassId(otherOption.getId());
        } else if (otherOption.getSuperClass() != null) {
            opt = ho.getOptionBySuperClassId(otherOption.getSuperClass().getId());
        }
        if (opt != null) {
            return opt;
        }
        return otherOption;
    }

    public IOptionCategory getClonedOptionCategory(IOptionCategory optCategory) {
        if (optCategory instanceof Tool) {
            return (Tool)this.getClonedTool((ITool)((Tool)optCategory));
        }
        return optCategory;
    }

    public IOptionCategory getRealOptionCategory(IOptionCategory optCategory) {
        if (optCategory instanceof Tool) {
            return (Tool)this.getRealTool((ITool)((Tool)optCategory));
        }
        return optCategory;
    }
}

