/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIMemoryChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIRestartedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.model.IExecFileInfo;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;

public class CMemoryBlockExtension
extends CDebugElement
implements IMemoryBlockExtension,
ICDIEventListener {
    private String fExpression;
    private BigInteger fBaseAddress;
    private ICDIMemoryBlock fCDIBlock;
    private MemoryByte[] fBytes = null;
    private HashSet fChanges = new HashSet();
    private int fWordSize;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CMemoryBlockExtension(CDebugTarget target, String expression, BigInteger baseAddress) {
        this(target, expression, baseAddress, 1);
    }

    public CMemoryBlockExtension(CDebugTarget target, String expression, BigInteger baseAddress, int wordSize) {
        super(target);
        this.fExpression = expression;
        this.fBaseAddress = baseAddress;
        this.fWordSize = wordSize;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public BigInteger getBigBaseAddress() {
        return this.fBaseAddress;
    }

    public int getAddressSize() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory().createAddress(this.getBigBaseAddress()).getSize();
    }

    public int getAddressableSize() throws DebugException {
        ICDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getWordSize() : this.fWordSize;
    }

    public boolean supportBaseAddressModification() {
        return true;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryByte[] getBytesFromAddress(BigInteger address, long length) throws DebugException {
        int offset;
        ICDIMemoryBlock cdiBlock = this.getCDIBlock();
        if (cdiBlock == null || cdiBlock.getStartAddress().compareTo(address) > 0 || cdiBlock.getStartAddress().add(BigInteger.valueOf(cdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
            CMemoryBlockExtension cMemoryBlockExtension = this;
            synchronized (cMemoryBlockExtension) {
                byte[] bytes = null;
                try {
                    cdiBlock = this.getCDIBlock();
                    if (cdiBlock == null || cdiBlock.getStartAddress().compareTo(address) > 0 || cdiBlock.getStartAddress().add(BigInteger.valueOf(cdiBlock.getLength())).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
                        if (cdiBlock != null) {
                            this.disposeCDIBlock();
                            this.fBytes = null;
                        }
                        this.setCDIBlock(this.createCDIBlock(address, length, this.fWordSize));
                    }
                    bytes = this.getCDIBlock().getBytes();
                }
                catch (CDIException e) {
                    CMemoryBlockExtension.targetRequestFailed(e.getMessage(), null);
                }
                this.fBytes = new MemoryByte[bytes.length];
                int i = 0;
                while (i < bytes.length) {
                    this.fBytes[i] = this.createMemoryByte(bytes[i], this.getCDIBlock().getFlags(i), this.hasChanged(this.getRealBlockAddress().add(BigInteger.valueOf(i))));
                    ++i;
                }
            }
        }
        MemoryByte[] result = new MemoryByte[]{};
        if (this.fBytes != null && (offset = address.subtract(this.getRealBlockAddress()).intValue()) >= 0) {
            int size;
            int n = size = (long)(this.fBytes.length - offset) >= length ? (int)length : this.fBytes.length - offset;
            if (size > 0) {
                result = new MemoryByte[size];
                System.arraycopy(this.fBytes, offset, result, 0, size);
            }
        }
        return result;
    }

    private boolean isBigEndian() {
        IExecFileInfo info;
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IExecFileInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((info = (IExecFileInfo)iDebugTarget.getAdapter((Class)clazz)) != null) {
            return !info.isLittleEndian();
        }
        return false;
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IMemoryBlockRetrieval)iDebugTarget.getAdapter((Class)clazz);
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null && source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof ICDIResumedEvent || event instanceof ICDIRestartedEvent) {
                    this.resetChanges();
                } else if (event instanceof ICDIMemoryChangedEvent && source instanceof ICDIMemoryBlock && source.equals(this.getCDIBlock())) {
                    this.handleChangedEvent((ICDIMemoryChangedEvent)event);
                }
            }
            ++i;
        }
    }

    public long getStartAddress() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        return null;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
        this.setValue(BigInteger.valueOf(offset), bytes);
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        ICDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            BigInteger base = this.getBigBaseAddress();
            BigInteger real = this.getRealBlockAddress();
            long realOffset = base.add(offset).subtract(real).longValue();
            try {
                block.setValue(realOffset, bytes);
            }
            catch (CDIException e) {
                CMemoryBlockExtension.targetRequestFailed(e.getDetailMessage(), null);
            }
        }
    }

    private ICDIMemoryBlock createCDIBlock(BigInteger address, long length, int wordSize) throws CDIException {
        ICDIMemoryBlock block = ((CDebugTarget)this.getDebugTarget()).getCDITarget().createMemoryBlock(address.toString(), (int)length, wordSize);
        block.setFrozen(false);
        this.getCDISession().getEventManager().addEventListener(this);
        return block;
    }

    private void disposeCDIBlock() {
        ICDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDITarget().removeBlocks(new ICDIMemoryBlock[]{block});
            }
            catch (CDIException e) {
                DebugPlugin.log((Throwable)e);
            }
            this.setCDIBlock(null);
            this.getCDISession().getEventManager().removeEventListener(this);
        }
    }

    private ICDIMemoryBlock getCDIBlock() {
        return this.fCDIBlock;
    }

    private void setCDIBlock(ICDIMemoryBlock cdiBlock) {
        this.fCDIBlock = cdiBlock;
    }

    private BigInteger getRealBlockAddress() {
        ICDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getStartAddress() : BigInteger.ZERO;
    }

    private long getBlockSize() {
        ICDIMemoryBlock block = this.getCDIBlock();
        return block != null ? block.getLength() : 0L;
    }

    private void handleChangedEvent(ICDIMemoryChangedEvent event) {
        ICDIMemoryBlock block = this.getCDIBlock();
        if (block != null && this.fBytes != null) {
            MemoryByte[] memBytes = (MemoryByte[])this.fBytes.clone();
            try {
                BigInteger start = this.getRealBlockAddress();
                long length = block.getLength();
                byte[] newBytes = block.getBytes();
                BigInteger[] addresses = event.getAddresses();
                this.saveChanges(addresses);
                int i = 0;
                while (i < addresses.length) {
                    int index;
                    this.fChanges.add(addresses[i]);
                    if (addresses[i].compareTo(start) >= 0 && addresses[i].compareTo(start.add(BigInteger.valueOf(length))) < 0 && (index = addresses[i].subtract(start).intValue()) >= 0 && index < memBytes.length && index < newBytes.length) {
                        memBytes[index].setChanged(true);
                        memBytes[index].setValue(newBytes[index]);
                    }
                    ++i;
                }
                this.fBytes = memBytes;
                this.fireChangeEvent(512);
            }
            catch (CDIException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
    }

    private void saveChanges(BigInteger[] addresses) {
        this.fChanges.addAll(Arrays.asList(addresses));
    }

    private boolean hasChanged(BigInteger address) {
        return this.fChanges.contains(address);
    }

    private void resetChanges() {
        if (this.fBytes != null) {
            BigInteger[] changes = this.fChanges.toArray(new BigInteger[this.fChanges.size()]);
            int i = 0;
            while (i < changes.length) {
                int index;
                BigInteger real = this.getRealBlockAddress();
                if (real.compareTo(changes[i]) <= 0 && real.add(BigInteger.valueOf(this.getBlockSize())).compareTo(changes[i]) > 0 && (index = changes[i].subtract(real).intValue()) >= 0 && index < this.fBytes.length) {
                    this.fBytes[index].setChanged(false);
                }
                ++i;
            }
        }
        this.fChanges.clear();
        this.fireChangeEvent(512);
    }

    public boolean supportsChangeManagement() {
        return true;
    }

    public void connect(Object object) {
    }

    public void disconnect(Object object) {
    }

    public Object[] getConnections() {
        return new Object[0];
    }

    public void dispose() {
        this.fChanges.clear();
        ICDIMemoryBlock cdiBlock = this.getCDIBlock();
        if (cdiBlock != null) {
            try {
                ((CDebugTarget)this.getDebugTarget()).getCDITarget().removeBlocks(new ICDIMemoryBlock[]{cdiBlock});
            }
            catch (CDIException e) {
                CDebugCorePlugin.log(e);
            }
            this.fCDIBlock = null;
        }
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        ICDIMemoryBlock block = this.getCDIBlock();
        if (block != null) {
            BigInteger length = new BigInteger(Long.toHexString(block.getLength()), 16);
            return length;
        }
        return BigInteger.ZERO;
    }

    private MemoryByte createMemoryByte(byte value, byte cdiFlags, boolean changed) {
        byte flags = 0;
        if ((cdiFlags & 2) != 0) {
            flags = (byte)(flags | 0x28);
            flags = (cdiFlags & 1) != 0 ? (byte)(flags | 2) : (byte)(flags | 3);
            if (this.isBigEndian()) {
                flags = (byte)(flags | 0x10);
            }
            if (changed) {
                flags = (byte)(flags | 4);
            }
        }
        return new MemoryByte(value, flags);
    }
}

