/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPClassType
extends PDOMMemberOwner
implements ICPPClassType,
ICPPClassScope {
    private static final int FIRSTBASE = 28;
    private static final int KEY = 32;
    protected static final int RECORD_SIZE = 33;

    public PDOMCPPClassType(PDOM pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name);
        IBinding binding = name.resolveBinding();
        int key = 0;
        if (binding instanceof ICPPClassType) {
            key = ((ICPPClassType)binding).getKey();
        }
        pdom.getDB().putByte(this.record + 32, (byte)key);
    }

    public PDOMCPPClassType(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 33;
    }

    public int getNodeType() {
        return 5;
    }

    public PDOMCPPBase getFirstBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        int rec = base != null ? base.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public boolean isSameType(IType type) {
        if (type instanceof PDOMBinding) {
            return this.record == ((PDOMBinding)((Object)type)).getRecord();
        }
        return false;
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public IField findField(String name) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPBase[] getBases() throws DOMException {
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Object[] bases = list.toArray(new ICPPBase[list.size()]);
            ArrayUtil.reverse(bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPBase[0];
        }
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        return new ICPPConstructor[0];
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        try {
            GetMethods methods = new GetMethods();
            this.accept(methods);
            return methods.getMethods();
        }
        catch (CoreException coreException) {
            return new ICPPMethod[0];
        }
    }

    private void visitAllDeclaredMethods(Set visited, List methods) throws CoreException {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        GetMethods myMethods = new GetMethods(methods);
        this.accept(myMethods);
        PDOMCPPBase base = this.getFirstBase();
        while (base != null) {
            IBinding baseClass = base.getBaseClass();
            if (baseClass != null && baseClass instanceof PDOMCPPClassType) {
                ((PDOMCPPClassType)baseClass).visitAllDeclaredMethods(visited, methods);
            }
            base = base.getNextBase();
        }
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        ArrayList methods = new ArrayList();
        HashSet visited = new HashSet();
        try {
            this.visitAllDeclaredMethods(visited, methods);
            return methods.toArray(new ICPPMethod[methods.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPMethod[0];
        }
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return this.getDeclaredMethods();
    }

    public IField[] getFields() throws DOMException {
        try {
            GetFields visitor = new GetFields();
            this.accept(visitor);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IField[0];
        }
    }

    public IBinding[] getFriends() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        try {
            GetNestedClasses visitor = new GetNestedClasses();
            this.accept(visitor);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPClassType[0];
        }
    }

    public IScope getCompositeScope() throws DOMException {
        return this;
    }

    public int getKey() throws DOMException {
        try {
            return this.pdom.getDB().getByte(this.record + 32);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        try {
            return this.getParentNode() instanceof PDOMLinkage;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    public ICPPClassType getClassType() {
        return this;
    }

    public ICPPMethod[] getImplicitMethods() {
        throw new PDOMNotImplementedError();
    }

    public void addBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void addName(IASTName name) throws DOMException {
    }

    public IBinding[] find(String name) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void flushCache() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return null;
    }

    public IScope getParent() throws DOMException {
        return null;
    }

    public IASTNode getPhysicalNode() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IASTName getScopeName() throws DOMException {
        try {
            PDOMName name = this.getFirstDefinition();
            if (name == null) {
                name = this.getFirstDefinition();
            }
            return name;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isFullyCached() throws DOMException {
        return true;
    }

    public void removeBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void setFullyCached(boolean b) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    private static class GetFields
    implements IPDOMVisitor {
        private List fields = new ArrayList();

        private GetFields() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IField) {
                this.fields.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField[] getFields() {
            return this.fields.toArray(new IField[this.fields.size()]);
        }
    }

    private static class GetMethods
    implements IPDOMVisitor {
        private final List methods;

        public GetMethods(List methods) {
            this.methods = methods;
        }

        public GetMethods() {
            this.methods = new ArrayList();
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPMethod) {
                this.methods.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPMethod[] getMethods() {
            return this.methods.toArray(new ICPPMethod[this.methods.size()]);
        }
    }

    private static class GetNestedClasses
    implements IPDOMVisitor {
        private List nestedClasses = new ArrayList();

        private GetNestedClasses() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof ICPPClassType) {
                this.nestedClasses.add(node);
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public ICPPClassType[] getNestedClasses() {
            return this.nestedClasses.toArray(new ICPPClassType[this.nestedClasses.size()]);
        }
    }
}

