/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.internal.enablement.AndExpression;

public class OptionEnablementExpression
extends AndExpression {
    public static final String NAME = "enablement";
    public static final String TYPE = "type";
    public static final String TYPE_UI_VISIBILITY = "UI_VISIBILITY";
    public static final String TYPE_UI_ENABLEMENT = "UI_ENABLEMENT";
    public static final String TYPE_CMD_USAGE = "CMD_USAGE";
    public static final String TYPE_CONTAINER_ATTRIBUTE = "CONTAINER_ATTRIBUTE";
    public static final String TYPE_ALL = "ALL";
    public static final String FLAG_DELIMITER = "|";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    private static final String[] fSupportedAttributes = new String[]{"command", "commandFalse"};
    public static final int FLAG_UI_VISIBILITY = 1;
    public static final int FLAG_UI_ENABLEMENT = 2;
    public static final int FLAG_CMD_USAGE = 4;
    public static final int FLAG_CONTAINER_ATTRIBUTE = 8;
    public static final int FLAG_ALL = -1;
    private int fEnablementFlags;
    private String fAttribute;
    private String fValue;

    public OptionEnablementExpression(IManagedConfigElement element) {
        super(element);
        this.fEnablementFlags = this.calculateFlags(element.getAttribute(TYPE));
        this.fAttribute = element.getAttribute(ATTRIBUTE);
        this.fValue = element.getAttribute(VALUE);
        this.adjustAttributeSupport();
    }

    private void adjustAttributeSupport() {
        boolean cleanAttrFlag = true;
        if (this.fAttribute != null && this.fValue != null) {
            int i = 0;
            while (i < fSupportedAttributes.length) {
                if (this.fAttribute.equals(fSupportedAttributes[i])) {
                    cleanAttrFlag = false;
                    break;
                }
                ++i;
            }
        }
        if (cleanAttrFlag) {
            this.fEnablementFlags &= 0xFFFFFFF7;
            this.fAttribute = null;
            this.fValue = null;
        }
    }

    public String[] convertToList(String value, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        int delLength = delimiter.length();
        int valLength = value.length();
        if (delLength == 0) {
            list.add(value);
        } else {
            int start = 0;
            while (start < valLength) {
                int stop = value.indexOf(delimiter, start);
                if (stop == -1) {
                    stop = valLength;
                }
                String subst = value.substring(start, stop);
                list.add(subst);
                start = stop + delLength;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    protected int calculateFlags(String flagsString) {
        int flags = 0;
        if (flagsString != null) {
            String[] strings = this.convertToList(flagsString, FLAG_DELIMITER);
            int i = 0;
            while (i < strings.length) {
                String str = strings[i].trim();
                if (TYPE_UI_VISIBILITY.equals(str)) {
                    flags |= 1;
                } else if (TYPE_UI_ENABLEMENT.equals(str)) {
                    flags |= 2;
                } else if (TYPE_CMD_USAGE.equals(str)) {
                    flags |= 4;
                } else if (TYPE_CONTAINER_ATTRIBUTE.equals(str)) {
                    flags |= 8;
                } else if (TYPE_ALL.equals(str)) {
                    flags |= 0xFFFFFFFF;
                }
                ++i;
            }
        }
        if (flags == 0) {
            flags = -1;
        }
        return flags;
    }

    public boolean evaluate(IBuildObject configuration, IHoldsOptions holder, IOption option, int flags) {
        return this.evaluate(configuration, holder, option, flags, (8 & flags) == 0);
    }

    public boolean evaluate(IBuildObject configuration, IHoldsOptions holder, IOption option, int flags, boolean bDefault) {
        return this.checkFlags(flags) ? this.evaluate(configuration, holder, option) : bDefault;
    }

    public boolean checkFlags(int flags) {
        return (this.fEnablementFlags & flags) == flags;
    }

    public int getFlags() {
        return this.fEnablementFlags;
    }

    public boolean performAdjustment(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        if (this.evaluate(configuration, holder, option, 8)) {
            block5: {
                try {
                    if ("command".equals(this.fAttribute)) {
                        IOption setOption = holder.getOptionToSet(option, true);
                        setOption.setCommand(this.fValue);
                        break block5;
                    }
                    if ("commandFalse".equals(this.fAttribute)) {
                        IOption setOption = holder.getOptionToSet(option, true);
                        setOption.setCommandFalse(this.fValue);
                        break block5;
                    }
                    return false;
                }
                catch (BuildException buildException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

