/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassType;
import org.eclipse.core.runtime.PlatformObject;

public class CPPClassType
extends PlatformObject
implements ICPPClassType,
ICPPInternalClassType {
    private IASTName definition;
    private IASTName[] declarations;
    private boolean checked = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public CPPClassType(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        IASTNode parent = name.getParent();
        while (parent instanceof IASTName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTCompositeTypeSpecifier) {
            this.definition = name;
        } else {
            this.declarations = new IASTName[]{name};
        }
        name.setBinding(this);
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.definition;
    }

    private void checkForDefinition() {
        if (!this.checked) {
            FindDefinitionAction action = new FindDefinitionAction();
            IASTNode node = CPPVisitor.getContainingBlockItem(this.getPhysicalNode()).getParent();
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                node = CPPVisitor.getContainingBlockItem(node.getParent());
            }
            while (node instanceof ICPPASTTemplateDeclaration) {
                node = node.getParent();
            }
            node.accept(action);
            this.definition = action.result;
            if (this.definition == null) {
                node.getTranslationUnit().accept(action);
                this.definition = action.result;
            }
            this.checked = true;
        }
    }

    private ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    private ICPPASTElaboratedTypeSpecifier getElaboratedTypeSpecifier() {
        if (this.declarations != null) {
            IASTNode node = this.declarations[0];
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTElaboratedTypeSpecifier) {
                return (ICPPASTElaboratedTypeSpecifier)node;
            }
        }
        return null;
    }

    public IField[] getFields() throws DOMException {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new IField[]{new CPPField.CPPFieldProblem(node, 7, this.getNameCharArray())};
            }
        }
        Object[] fields = this.getDeclaredFields();
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IField");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                fields = (IField[])ArrayUtil.addAll(clazz, fields, ((ICPPClassType)b).getFields());
            }
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IField[])ArrayUtil.trim(clazz, fields);
    }

    public IField findField(String name) throws DOMException {
        IBinding[] bindings = CPPSemantics.findBindings(this.getCompositeScope(), name, true);
        IField field = null;
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i] instanceof IField) {
                if (field == null) {
                    field = (IField)bindings[i];
                } else {
                    IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                    return new CPPField.CPPFieldProblem(node, 4, name.toCharArray());
                }
            }
            ++i;
        }
        return field;
    }

    public String getName() {
        return this.definition != null ? this.definition.toString() : this.declarations[0].toString();
    }

    public char[] getNameCharArray() {
        return this.definition != null ? this.definition.toCharArray() : this.declarations[0].toCharArray();
    }

    public IScope getScope() {
        IASTNode node;
        IASTName name = this.definition != null ? this.definition : this.declarations[0];
        IScope scope = CPPVisitor.getContainingScope(name);
        if (this.definition == null && name.getPropertyInParent() != ICPPASTQualifiedName.SEGMENT_NAME && ((node = this.declarations[0].getParent().getParent()) instanceof IASTFunctionDefinition || node instanceof IASTParameterDeclaration || node instanceof IASTSimpleDeclaration && (((IASTSimpleDeclaration)node).getDeclarators().length > 0 || this.getElaboratedTypeSpecifier().isFriend()))) {
            while (scope instanceof ICPPClassScope || scope instanceof ICPPFunctionScope) {
                try {
                    scope = (ICPPScope)scope.getParent();
                }
                catch (DOMException dOMException) {}
            }
        }
        return scope;
    }

    public IScope getCompositeScope() {
        if (this.definition == null) {
            this.checkForDefinition();
        }
        return this.definition != null ? this.getCompositeTypeSpecifier().getScope() : null;
    }

    public IASTNode getPhysicalNode() {
        return this.definition != null ? this.definition : this.declarations[0];
    }

    public int getKey() {
        if (this.definition != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getElaboratedTypeSpecifier().getKind();
    }

    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.definition = ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof ICPPASTElaboratedTypeSpecifier)) {
            return;
        }
        IASTName name = ((ICPPASTElaboratedTypeSpecifier)node).getName();
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
            return;
        }
        if (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.prepend(clazz, this.declarations, name);
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.append(clazz, this.declarations, name);
        }
    }

    public void removeDeclaration(IASTNode node) {
        if (this.definition == node) {
            this.definition = null;
            return;
        }
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                if (node == this.declarations[i]) {
                    if (i == this.declarations.length - 1) {
                        this.declarations[i] = null;
                    } else {
                        System.arraycopy(this.declarations, i + 1, this.declarations, i, this.declarations.length - 1 - i);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public ICPPBase[] getBases() {
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases;
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPBase[]{new CPPBaseClause.CPPBaseProblem(node, 7, this.getNameCharArray())};
            }
        }
        if ((bases = this.getCompositeTypeSpecifier().getBaseSpecifiers()).length == 0) {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
        ICPPBase[] bindings = new ICPPBase[bases.length];
        int i = 0;
        while (i < bases.length) {
            bindings[i] = new CPPBaseClause(bases[i]);
            ++i;
        }
        return bindings;
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPField[]{new CPPField.CPPFieldProblem(node, 7, this.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decls[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    binding = dtors[j].getName().resolveBinding();
                    if (binding instanceof ICPPField) {
                        Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPField");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (ICPPField[])ArrayUtil.append(clazz, result, binding);
                    }
                    ++j;
                }
            } else if (decls[i] instanceof ICPPASTUsingDeclaration) {
                IASTName n = ((ICPPASTUsingDeclaration)decls[i]).getName();
                binding = n.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    ICPPDelegate[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int j = 0;
                    while (j < bs.length) {
                        if (bs[j] instanceof ICPPField) {
                            Class<?> clazz = class$2;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPField");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            result = (ICPPField[])ArrayUtil.append(clazz, result, bs[j]);
                        }
                        ++j;
                    }
                } else if (binding instanceof ICPPField) {
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPField");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (ICPPField[])ArrayUtil.append(clazz, result, binding);
                }
            }
            ++i;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPField[])ArrayUtil.trim(clazz, result);
    }

    public ICPPMethod[] getConversionOperators() {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.getCompositeTypeSpecifier().getMembers();
        IASTName name = null;
        int i = 0;
        while (i < decls.length) {
            IASTFunctionDeclarator dtor;
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decls[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    name = CPPVisitor.getMostNestedDeclarator(dtors[j]).getName();
                    if (name instanceof ICPPASTConversionName && (binding = name.resolveBinding()) instanceof ICPPMethod) {
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (ICPPMethod[])ArrayUtil.append(clazz, result, binding);
                    }
                    ++j;
                }
            } else if (decls[i] instanceof IASTFunctionDefinition && (name = CPPVisitor.getMostNestedDeclarator(dtor = ((IASTFunctionDefinition)decls[i]).getDeclarator()).getName()) instanceof ICPPASTConversionName && (binding = name.resolveBinding()) instanceof ICPPMethod) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (ICPPMethod[])ArrayUtil.append(clazz, result, binding);
            }
            ++i;
        }
        ICPPBase[] bases = this.getBases();
        int i2 = 0;
        while (i2 < bases.length) {
            block25: {
                ICPPClassType cls;
                block24: {
                    cls = null;
                    try {
                        IBinding b = bases[i2].getBaseClass();
                        if (!(b instanceof ICPPClassType)) break block24;
                        cls = (ICPPClassType)b;
                    }
                    catch (DOMException dOMException) {
                        break block25;
                    }
                }
                if (cls instanceof ICPPInternalClassType) {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (ICPPMethod[])ArrayUtil.addAll(clazz, result, ((ICPPInternalClassType)((Object)cls)).getConversionOperators());
                }
            }
            ++i2;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPMethod[])ArrayUtil.trim(clazz, result);
    }

    public ICPPMethod[] getMethods() throws DOMException {
        ObjectSet set = new ObjectSet(4);
        Object[] ms = this.getDeclaredMethods();
        set.addAll(ms);
        ICPPClassScope scope = (ICPPClassScope)this.getCompositeScope();
        set.addAll(scope.getImplicitMethods());
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                set.addAll(((ICPPClassType)b).getMethods());
            }
            ++i;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPMethod[])set.keyArray(clazz);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.getNameCharArray())};
            }
        }
        Object[] methods = this.getDeclaredMethods();
        ICPPBase[] bases = this.getBases();
        int i = 0;
        while (i < bases.length) {
            IBinding b = bases[i].getBaseClass();
            if (b instanceof ICPPClassType) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                methods = (ICPPMethod[])ArrayUtil.addAll(clazz, methods, ((ICPPClassType)b).getAllDeclaredMethods());
            }
            ++i;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPMethod[])ArrayUtil.trim(clazz, methods);
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPMethod[]{new CPPMethod.CPPMethodProblem(node, 7, this.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            IASTDeclaration decl = decls[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    binding = dtors[j].getName().resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        Class<?> clazz = class$3;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (ICPPMethod[])ArrayUtil.append(clazz, result, binding);
                    }
                    ++j;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                binding = (dtor = CPPVisitor.getMostNestedDeclarator(dtor)).getName().resolveBinding();
                if (binding instanceof ICPPMethod) {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (ICPPMethod[])ArrayUtil.append(clazz, result, binding);
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    ICPPDelegate[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int j = 0;
                    while (j < bs.length) {
                        if (bs[j] instanceof ICPPMethod) {
                            Class<?> clazz = class$3;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            result = (ICPPMethod[])ArrayUtil.append(clazz, result, bs[j]);
                        }
                        ++j;
                    }
                } else if (binding instanceof ICPPMethod) {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (ICPPMethod[])ArrayUtil.append(clazz, result, binding);
                }
            }
            ++i;
        }
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPMethod[])ArrayUtil.trim(clazz, result);
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        ICPPClassScope scope;
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPConstructor[]{new CPPConstructor.CPPConstructorProblem(node, 7, this.getNameCharArray())};
            }
        }
        if ((scope = (ICPPClassScope)this.getCompositeScope()).isFullyCached()) {
            return ((CPPClassScope)scope).getConstructors(true);
        }
        IASTDeclaration[] members = this.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < members.length) {
            IASTDeclaration decl = members[i];
            if (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    if (dtors[j] != null) {
                        scope.addName(dtors[j].getName());
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                scope.addName(dtor.getName());
            }
            ++i;
        }
        return ((CPPClassScope)scope).getConstructors(true);
    }

    public IBinding[] getFriends() {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new IBinding[]{new ProblemBinding(node, 7, this.getNameCharArray())};
            }
        }
        ObjectSet resultSet = new ObjectSet(2);
        IASTDeclaration[] members = this.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < members.length) {
            ICPPASTDeclSpecifier declSpec;
            IASTDeclaration decl = members[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec.isFriend()) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && dtors.length == 0) {
                        resultSet.put(((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding());
                    } else {
                        int j = 0;
                        while (j < dtors.length) {
                            if (dtors[j] != null) {
                                resultSet.put(dtors[j].getName().resolveBinding());
                                ++j;
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition && (declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier()).isFriend()) {
                IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                resultSet.put(dtor.getName().resolveBinding());
            }
            ++i;
        }
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBinding[])resultSet.keyArray(clazz);
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPClassTypeDelegate(name, this);
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return ((ITypedef)type).isSameType(this);
        }
        return false;
    }

    public ICPPClassType[] getNestedClasses() {
        if (this.definition == null) {
            this.checkForDefinition();
            if (this.definition == null) {
                IASTName node = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : null;
                return new ICPPClassType[]{new CPPClassTypeProblem(node, 7, this.getNameCharArray())};
            }
        }
        IBinding binding = null;
        Object[] result = null;
        IASTDeclaration[] decls = this.getCompositeTypeSpecifier().getMembers();
        int i = 0;
        while (i < decls.length) {
            IASTDeclaration decl = decls[i];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decls[i]).getDeclSpecifier();
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && ((IASTSimpleDeclaration)decls[i]).getDeclarators().length == 0) {
                    binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                }
                if (binding instanceof ICPPClassType) {
                    Class<?> clazz = class$5;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (ICPPClassType[])ArrayUtil.append(clazz, result, binding);
                }
            }
            ++i;
        }
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICPPClassType[])ArrayUtil.trim(clazz, result);
    }

    public static class CPPClassTypeDelegate
    extends CPPDelegate
    implements ICPPClassType,
    ICPPInternalClassType {
        public CPPClassTypeDelegate(IASTName name, ICPPClassType cls) {
            super(name, cls);
        }

        public ICPPBase[] getBases() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getBases();
        }

        public IField[] getFields() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getFields();
        }

        public IField findField(String name) throws DOMException {
            return ((ICPPClassType)this.getBinding()).findField(name);
        }

        public ICPPField[] getDeclaredFields() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getDeclaredFields();
        }

        public ICPPMethod[] getMethods() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getMethods();
        }

        public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getAllDeclaredMethods();
        }

        public ICPPMethod[] getDeclaredMethods() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getDeclaredMethods();
        }

        public ICPPConstructor[] getConstructors() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getConstructors();
        }

        public IBinding[] getFriends() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getFriends();
        }

        public int getKey() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getKey();
        }

        public IScope getCompositeScope() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getCompositeScope();
        }

        public Object clone() {
            CPPClassTypeDelegate d = null;
            try {
                d = (CPPClassTypeDelegate)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            return d;
        }

        public ICPPMethod[] getConversionOperators() {
            IBinding binding = this.getBinding();
            if (binding instanceof ICPPInternalClassType) {
                return ((ICPPInternalClassType)binding).getConversionOperators();
            }
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }

        public boolean isSameType(IType type) {
            return ((ICPPClassType)this.getBinding()).isSameType(type);
        }

        public ICPPClassType[] getNestedClasses() throws DOMException {
            return ((ICPPClassType)this.getBinding()).getNestedClasses();
        }
    }

    public static class CPPClassTypeProblem
    extends ProblemBinding
    implements ICPPClassType {
        public CPPClassTypeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPBase[] getBases() throws DOMException {
            throw new DOMException(this);
        }

        public IField[] getFields() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPField[] getDeclaredFields() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPMethod[] getDeclaredMethods() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPConstructor[] getConstructors() throws DOMException {
            throw new DOMException(this);
        }

        public int getKey() throws DOMException {
            throw new DOMException(this);
        }

        public IField findField(String name) throws DOMException {
            throw new DOMException(this);
        }

        public IScope getCompositeScope() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getParent() throws DOMException {
            throw new DOMException(this);
        }

        public IBinding[] find(String name) throws DOMException {
            throw new DOMException(this);
        }

        public IBinding[] getFriends() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassType[] getNestedClasses() throws DOMException {
            throw new DOMException(this);
        }
    }

    private class FindDefinitionAction
    extends CPPASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPClassType.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId) {
                return 1;
            }
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.toCharArray();
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassType.this) {
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns[ns.length - 1];
                }
                this.result = name;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

