/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class Chunk {
    private final Database db;
    private final int index;
    private final byte[] buffer;
    Chunk lruPrev;
    Chunk lruNext;
    private boolean dirty;

    Chunk(Database db, int index) throws CoreException {
        this.db = db;
        this.index = index;
        this.buffer = new byte[16384];
        try {
            db.file.seek(index * 16384);
            db.file.read(this.buffer, 0, 16384);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public final void save() throws CoreException {
        if (!this.dirty) {
            return;
        }
        if (this.index == 0 && this.getInt(0) != 11) {
            return;
        }
        try {
            this.db.file.seek(this.index * 16384);
            this.db.file.write(this.buffer, 0, 16384);
            this.dirty = false;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public void putByte(int offset, byte value) {
        this.dirty = true;
        this.buffer[offset % 16384] = value;
    }

    public byte getByte(int offset) {
        return this.buffer[offset % 16384];
    }

    public byte[] getBytes(int offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.buffer, offset % 16384, bytes, 0, length);
        return bytes;
    }

    public void putBytes(int offset, byte[] bytes) {
        this.dirty = true;
        System.arraycopy(bytes, 0, this.buffer, offset % 16384, bytes.length);
    }

    public void putInt(int offset, int value) {
        this.dirty = true;
        int i = offset % 16384;
        this.buffer[i++] = (byte)(value >>> 24 & 0xFF);
        this.buffer[i++] = (byte)(value >>> 16 & 0xFF);
        this.buffer[i++] = (byte)(value >>> 8 & 0xFF);
        this.buffer[i] = (byte)(value & 0xFF);
    }

    public int getInt(int offset) {
        int i = offset % 16384;
        return (this.buffer[i] & 0xFF) << 24 | (this.buffer[i + 1] & 0xFF) << 16 | (this.buffer[i + 2] & 0xFF) << 8 | this.buffer[i + 3] & 0xFF;
    }

    public void putChar(int offset, char value) {
        this.dirty = true;
        int i = offset % 16384;
        this.buffer[i] = (byte)(value >>> 8 & 0xFF);
        this.buffer[i + 1] = (byte)(value & 0xFF);
    }

    public char getChar(int offset) {
        int i = offset % 16384;
        return (char)(((this.buffer[i] & 0xFF) << 8) + (this.buffer[i + 1] & 0xFF));
    }

    void clear(int offset, int length) {
        this.dirty = true;
        int i = offset % 16384;
        while (length > 0) {
            this.buffer[i++] = 0;
            --length;
        }
    }

    void free() throws CoreException {
        this.save();
        this.db.freeChunk(this.index);
    }
}

