/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.fast;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.fast.PDOMFastIndexerJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class PDOMFastReindex
extends PDOMFastIndexerJob {
    public PDOMFastReindex(PDOMFastIndexer indexer) throws CoreException {
        super(indexer);
    }

    private void addSources(ICContainer container, IProgressMonitor monitor) throws CoreException {
        ITranslationUnit[] tus = container.getTranslationUnits();
        int i = 0;
        while (i < tus.length) {
            block6: {
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                ITranslationUnit tu = tus[i];
                if (tu.isSourceUnit()) {
                    try {
                        this.addTU(tu);
                    }
                    catch (Throwable e) {
                        CCorePlugin.log(e);
                        if (++this.errorCount <= 10) break block6;
                        throw new CoreException(Status.CANCEL_STATUS);
                    }
                }
            }
            ++i;
        }
        ICContainer[] childContainers = container.getCContainers();
        int i2 = 0;
        while (i2 < childContainers.length) {
            this.addSources(childContainers[i2], monitor);
            ++i2;
        }
    }

    public void run(IProgressMonitor monitor) {
        try {
            long start = System.currentTimeMillis();
            try {
                this.pdom.acquireWriteLock();
                this.pdom.clear();
                this.pdom.releaseWriteLock();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            ISourceRoot[] roots = this.indexer.getProject().getAllSourceRoots();
            int i = 0;
            while (i < roots.length) {
                this.addSources(roots[i], monitor);
                ++i;
            }
            this.indexer.reindexingComplete();
            String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
            if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
                System.out.println("PDOM Fast Reindex Time: " + (System.currentTimeMillis() - start) + " " + this.indexer.getProject().getElementName());
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

