/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPClassScope
extends CPPScope
implements ICPPClassScope {
    private static final char[] CONSTRUCTOR_KEY = "!!!CTOR!!!".toCharArray();
    private ICPPMethod[] implicits = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPPClassScope(ICPPASTCompositeTypeSpecifier physicalNode) {
        super(physicalNode);
        ((CPPASTCompositeTypeSpecifier)physicalNode).setScope(this);
        this.createImplicitMembers();
    }

    private void createImplicitMembers() {
        IBinding binding;
        ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compTypeSpec.getName();
        if (name instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
            name = ns[ns.length - 1];
        }
        if (!((binding = name.resolveBinding()) instanceof ICPPClassType)) {
            return;
        }
        this.implicits = new ICPPMethod[4];
        ICPPClassType clsType = (ICPPClassType)binding;
        if (clsType instanceof ICPPClassTemplate) {
            try {
                IBinding within = CPPTemplates.instantiateWithinClassTemplate((ICPPClassTemplate)((Object)clsType));
                if (within instanceof ICPPClassType) {
                    clsType = (ICPPClassType)within;
                }
            }
            catch (DOMException dOMException) {}
        }
        char[] className = name.toCharArray();
        IParameter[] voidPs = new IParameter[]{new CPPParameter(CPPSemantics.VOID_TYPE)};
        if (!this.hasNonStandardDefaultConstructor(compTypeSpec)) {
            CPPImplicitConstructor m = new CPPImplicitConstructor(this, className, voidPs);
            this.implicits[0] = m;
            this.addBinding(m);
        }
        CPPReferenceType pType = new CPPReferenceType(new CPPQualifierType(clsType, true, false));
        IParameter[] ps = new IParameter[]{new CPPParameter(pType)};
        CPPImplicitMethod m = new CPPImplicitConstructor(this, className, ps);
        this.implicits[1] = m;
        this.addBinding(m);
        CPPReferenceType refType = new CPPReferenceType(clsType);
        m = new CPPImplicitMethod(this, ICPPASTOperatorName.OPERATOR_ASSIGN, refType, ps);
        this.implicits[2] = m;
        this.addBinding(m);
        char[] dtorName = CharArrayUtils.concat("~".toCharArray(), className);
        m = new CPPImplicitMethod(this, dtorName, new CPPBasicType(0, 0), voidPs);
        this.implicits[3] = m;
        this.addBinding(m);
    }

    private boolean hasNonStandardDefaultConstructor(ICPPASTCompositeTypeSpecifier compSpec) {
        IASTDeclaration[] members = compSpec.getMembers();
        char[] name = compSpec.getName().toCharArray();
        IASTDeclarator dtor = null;
        IASTDeclSpecifier spec = null;
        int i = 0;
        while (i < members.length) {
            block5: {
                IASTParameterDeclaration[] ps;
                block6: {
                    block4: {
                        if (!(members[i] instanceof IASTSimpleDeclaration)) break block4;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)members[i]).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block5;
                        dtor = dtors[0];
                        spec = ((IASTSimpleDeclaration)members[i]).getDeclSpecifier();
                        break block6;
                    }
                    if (members[i] instanceof IASTFunctionDefinition) {
                        dtor = ((IASTFunctionDefinition)members[i]).getDeclarator();
                        spec = ((IASTFunctionDefinition)members[i]).getDeclSpecifier();
                    }
                }
                if (dtor instanceof ICPPASTFunctionDeclarator && spec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)spec).getType() == 0 && CharArrayUtils.equals(dtor.getName().toCharArray(), name) && (ps = ((ICPPASTFunctionDeclarator)dtor).getParameters()).length >= 1) {
                    IASTDeclarator d = ps[0].getDeclarator();
                    IASTDeclSpecifier s = ps[0].getDeclSpecifier();
                    if ((!(s instanceof IASTSimpleDeclSpecifier) || ((IASTSimpleDeclSpecifier)s).getType() != 1 || d.getPointerOperators().length != 0 || d instanceof IASTArrayDeclarator) && d.getInitializer() != null) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public IScope getParent() {
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName();
        if (compName instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)compName).getNames();
            compName = ns[ns.length - 1];
        }
        return CPPVisitor.getContainingScope(compName);
    }

    public void addBinding(IBinding binding) {
        if (binding instanceof ICPPConstructor) {
            this.addConstructor(binding);
            return;
        }
        super.addBinding(binding);
    }

    public void addName(IASTName name) {
        if (name instanceof ICPPASTQualifiedName) {
            return;
        }
        IASTNode parent = name.getParent();
        if (parent instanceof IASTDeclarator && CPPVisitor.isConstructor(this, (IASTDeclarator)parent)) {
            this.addConstructor(name);
            return;
        }
        super.addName(name);
    }

    private void addConstructor(Object constructor) {
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if (constructor instanceof IASTName && ((IASTName)constructor).getBinding() != null) {
            constructor = ((IASTName)constructor).getBinding();
        }
        if ((o = this.bindings.get(CONSTRUCTOR_KEY)) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(constructor);
            } else {
                ObjectSet set = new ObjectSet(2);
                set.put(o);
                set.put(constructor);
                this.bindings.put(CONSTRUCTOR_KEY, set);
            }
        } else {
            this.bindings.put(CONSTRUCTOR_KEY, constructor);
        }
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        char[] c = name.toCharArray();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName();
        if (compName instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)compName).getNames();
            compName = ns[ns.length - 1];
        }
        if (CharArrayUtils.equals(c, compName.toCharArray())) {
            if (CPPClassScope.isConstructorReference(name)) {
                return CPPSemantics.resolveAmbiguities(name, CPPClassScope.getConstructors(this.bindings, resolve));
            }
            return compName.resolveBinding();
        }
        return super.getBinding(name, resolve);
    }

    protected ICPPConstructor[] getConstructors(boolean forceResolve) {
        return CPPClassScope.getConstructors(this.bindings, forceResolve);
    }

    protected static ICPPConstructor[] getConstructors(CharArrayObjectMap bindings, boolean forceResolve) {
        if (bindings == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        Object o = bindings.get(CONSTRUCTOR_KEY);
        if (o != null) {
            IBinding binding = null;
            if (o instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)o;
                Object[] bs = null;
                int i = 0;
                while (i < set.size()) {
                    Object obj = set.keyAt(i);
                    if (obj instanceof IASTName) {
                        IASTName n = (IASTName)obj;
                        IBinding iBinding = binding = forceResolve ? n.resolveBinding() : n.getBinding();
                        if (binding != null) {
                            set.remove(n);
                            set.put(binding);
                            --i;
                        }
                    } else if (obj instanceof ICPPConstructor) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        bs = (IBinding[])ArrayUtil.append(clazz, bs, obj);
                    }
                    ++i;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (ICPPConstructor[])ArrayUtil.trim(clazz, bs);
            }
            if (o instanceof IASTName) {
                if (forceResolve || ((IASTName)o).getBinding() != null) {
                    binding = ((IASTName)o).resolveBinding();
                    bindings.put(CONSTRUCTOR_KEY, binding);
                }
            } else if (o instanceof IBinding) {
                binding = (IBinding)o;
            }
            if (binding != null && binding instanceof ICPPConstructor) {
                return new ICPPConstructor[]{(ICPPConstructor)binding};
            }
        }
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    public IBinding[] find(String name) throws DOMException {
        char[] n = name.toCharArray();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName();
        if (compName instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)compName).getNames();
            compName = ns[ns.length - 1];
        }
        if (CharArrayUtils.equals(n, compName.toCharArray())) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IBinding[])ArrayUtil.addAll(clazz, null, CPPClassScope.getConstructors(this.bindings, true));
        }
        return super.find(name);
    }

    protected static boolean isConstructorReference(IASTName name) {
        if (name.getPropertyInParent() == CPPSemantics.STRING_LOOKUP_PROPERTY) {
            return false;
        }
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTTemplateId) {
            node = node.getParent();
        }
        if (node instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)node).getNames();
            if (ns[ns.length - 1] == name) {
                node = node.getParent();
            } else {
                return false;
            }
        }
        if (node instanceof IASTDeclSpecifier) {
            IASTNode parent = node.getParent();
            return parent instanceof IASTTypeId && parent.getParent() instanceof ICPPASTNewExpression;
        }
        return true;
    }

    public ICPPClassType getClassType() {
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IBinding binding = compSpec.getName().resolveBinding();
        if (binding instanceof ICPPClassType) {
            return (ICPPClassType)binding;
        }
        return new CPPClassType.CPPClassTypeProblem(compSpec.getName(), 10, compSpec.getName().toCharArray());
    }

    public ICPPMethod[] getImplicitMethods() {
        if (this.implicits == null) {
            this.implicits = new ICPPMethod[]{new CPPMethod.CPPMethodProblem(null, 5, CPPSemantics.EMPTY_NAME_ARRAY)};
        }
        return this.implicits;
    }

    public IASTName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            return ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
        return null;
    }

    public void removeBinding(IBinding binding) {
        if (binding instanceof ICPPConstructor) {
            this.removeBinding(CONSTRUCTOR_KEY, binding);
        } else {
            this.removeBinding(binding.getNameCharArray(), binding);
        }
    }
}

