/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Database {
    final RandomAccessFile file;
    private Chunk[] toc;
    private long malloced;
    private long freed;
    int version = 0;
    public static final int VERSION_OFFSET = 0;
    public static final int CHUNK_SIZE = 16384;
    public static final int MIN_SIZE = 16;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int PREV_OFFSET = 4;
    public static final int NEXT_OFFSET = 8;
    public static final int DATA_AREA = 4100;
    public static final int MAX_SIZE = 16380;
    private static Object lruMutex;
    private static Chunk lruFirst;
    private static Chunk lruLast;
    private static int lruSize;
    private static final int lruMax;
    private static final int MEG = 0x100000;
    private Object lockMutex = new Object();
    private Thread lockOwner;
    private int lockCount;

    static {
        int max;
        lruMutex = new Object();
        String maxString = System.getProperty("cdt.index.lruMax");
        lruMax = maxString != null ? ((max = Integer.valueOf(maxString).intValue()) > 0 ? max * 0x100000 / 16384 : 4096) : ((max = Runtime.getRuntime().maxMemory()) < 0x20000000L ? (int)max / 8 / 16384 : 4096);
    }

    public Database(String filename) throws CoreException {
        try {
            this.file = new RandomAccessFile(filename, "rw");
            long nChunks = this.file.length() / 16384L;
            if (nChunks == 0L) {
                this.file.seek(0L);
                this.file.write(new byte[16384]);
                this.file.seek(0L);
                this.file.writeInt(this.version);
                nChunks = 1L;
            } else {
                this.file.seek(0L);
                this.version = this.file.readInt();
            }
            this.toc = new Chunk[(int)nChunks];
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void clear(int version) throws CoreException {
        Chunk chunk = this.getChunk(0);
        chunk.putInt(0, version);
        chunk.clear(4, 4096);
        int block = (this.toc.length - 1) * 16384;
        while (block > 0) {
            this.addBlock(this.getChunk(block), 16384, block);
            block -= 16384;
        }
        this.freed = 0L;
        this.malloced = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int offset) throws CoreException {
        Chunk chunk;
        int index = offset / 16384;
        Object object = lruMutex;
        synchronized (object) {
            chunk = this.toc[index];
            boolean isNew = false;
            if (chunk == null) {
                chunk = this.toc[index] = new Chunk(this, index);
                isNew = true;
            }
            Database.lruPutFirst(chunk, isNew);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(int index) {
        Object object = lruMutex;
        synchronized (object) {
            this.toc[index] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int malloc(int size) throws CoreException {
        Chunk chunk;
        if (size > 16380) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("pdom.requestTooLarge"), (Throwable)new IllegalArgumentException()));
        }
        int freeblock = 0;
        int matchsize = 0;
        int blocksize = 16;
        while (blocksize <= 16384) {
            if (blocksize - 4 >= size) {
                if (matchsize == 0) {
                    matchsize = blocksize;
                }
                if ((freeblock = this.getFirstBlock(blocksize)) != 0) break;
            }
            blocksize += 16;
        }
        if (freeblock == 0) {
            Object object = lruMutex;
            synchronized (object) {
                Chunk[] oldtoc = this.toc;
                int n = oldtoc.length;
                freeblock = n * 16384;
                blocksize = 16384;
                try {
                    this.file.seek(freeblock);
                    this.file.write(new byte[16384]);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new DBStatus(e));
                }
                this.toc = new Chunk[n + 1];
                System.arraycopy(oldtoc, 0, this.toc, 0, n);
                this.toc[n] = chunk = new Chunk(this, n);
                Database.lruPutFirst(chunk, true);
            }
        }
        chunk = this.getChunk(freeblock);
        this.removeBlock(chunk, blocksize, freeblock);
        if (blocksize != matchsize) {
            this.addBlock(chunk, blocksize - matchsize, freeblock + matchsize);
        }
        chunk.putInt(freeblock, -matchsize);
        chunk.clear(freeblock + 4, size);
        this.malloced += (long)matchsize;
        return freeblock + 4;
    }

    private int getFirstBlock(int blocksize) throws CoreException {
        return this.getChunk(0).getInt(blocksize / 16 * 4);
    }

    private void setFirstBlock(int blocksize, int block) throws CoreException {
        this.getChunk(0).putInt(blocksize / 16 * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        int prevblock = chunk.getInt(block + 4);
        int nextblock = chunk.getInt(block + 8);
        if (prevblock != 0) {
            this.putInt(prevblock + 8, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 4, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        chunk.putInt(block, blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 4, 0);
        chunk.putInt(block + 8, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 4, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        int block = offset - 4;
        Chunk chunk = this.getChunk(block);
        int blocksize = -chunk.getInt(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(int offset, byte value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getInt(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getChar(offset);
    }

    public IString newString(String string) throws CoreException {
        if (string.length() > 8188) {
            return new LongString(this, string);
        }
        return new ShortString(this, string);
    }

    public IString newString(char[] chars) throws CoreException {
        if (chars.length > 8188) {
            return new LongString(this, chars);
        }
        return new ShortString(this, chars);
    }

    public IString getString(int offset) throws CoreException {
        int length = this.getInt(offset);
        if (length > 8188) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    private static final void lruPutFirst(Chunk chunk, boolean isNew) throws CoreException {
        if (chunk == lruFirst) {
            return;
        }
        if (!isNew) {
            if (chunk.lruPrev != null) {
                chunk.lruPrev.lruNext = chunk.lruNext;
            }
            if (chunk.lruNext != null) {
                chunk.lruNext.lruPrev = chunk.lruPrev;
            } else {
                lruLast = chunk.lruPrev;
            }
        }
        chunk.lruNext = lruFirst;
        chunk.lruPrev = null;
        if (lruFirst != null) {
            Database.lruFirst.lruPrev = chunk;
        }
        lruFirst = chunk;
        if (lruLast == null) {
            lruLast = chunk;
        }
        if (isNew) {
            if (lruSize == lruMax) {
                Chunk last = lruLast;
                lruLast = last.lruPrev;
                Database.lruLast.lruNext = null;
                last.free();
            } else {
                ++lruSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock() throws InterruptedException {
        Object object = this.lockMutex;
        synchronized (object) {
            if (this.lockOwner != Thread.currentThread()) {
                while (this.lockCount > 0) {
                    this.lockMutex.wait();
                }
            }
            ++this.lockCount;
            this.lockOwner = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Object object = this.lockMutex;
        synchronized (object) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.lockOwner = null;
                this.lockMutex.notify();
            }
        }
    }

    public static void saveAll() {
        try {
            Chunk chunk = lruFirst;
            while (chunk != null) {
                chunk.save();
                chunk = chunk.lruNext;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }
}

