/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetListener;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeTargetEvent;
import org.eclipse.cdt.make.internal.core.ListenerList;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.MakeTarget;
import org.eclipse.cdt.make.internal.core.ProjectTargets;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class MakeTargetManager
implements IMakeTargetManager,
IResourceChangeListener {
    private static String TARGET_BUILD_EXT = "MakeTargetBuilder";
    private static String TARGETS_EXT = "targets";
    private ListenerList listeners = new ListenerList();
    Map projectMap = new HashMap();
    private HashMap builderMap;
    protected Vector fProjects = new Vector();

    public IMakeTarget createTarget(IProject project, String name, String targetBuilderID) throws CoreException {
        return new MakeTarget(this, project, targetBuilderID, name);
    }

    public void addTarget(IMakeTarget target) throws CoreException {
        this.addTarget(null, target);
    }

    public void addTarget(IContainer container, IMakeTarget target) throws CoreException {
        if (container instanceof IWorkspaceRoot) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.add_to_workspace_root"), null));
        }
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        ((MakeTarget)target).setContainer((IContainer)(container == null ? target.getProject() : container));
        projectTargets.add((MakeTarget)target);
        try {
            this.writeTargets(projectTargets);
        }
        catch (CoreException e) {
            projectTargets.remove((MakeTarget)target);
            throw e;
        }
        this.notifyListeners(new MakeTargetEvent((Object)this, 1, target));
    }

    public boolean targetExists(IMakeTarget target) {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        return projectTargets.contains((MakeTarget)target);
    }

    public void removeTarget(IMakeTarget target) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        if (projectTargets.remove((MakeTarget)target)) {
            try {
                this.writeTargets(projectTargets);
            }
            catch (CoreException e) {
                projectTargets.add((MakeTarget)target);
                throw e;
            }
            this.notifyListeners(new MakeTargetEvent((Object)this, 3, target));
        }
    }

    public void renameTarget(IMakeTarget target, String name) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(target.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(target.getProject());
        }
        if (!projectTargets.contains((MakeTarget)target)) {
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("MakeTargetManager.target_exists"), null));
        }
        ((MakeTarget)target).setName(name);
        this.updateTarget((MakeTarget)target);
    }

    public IMakeTarget[] getTargets(IContainer container) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(container.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(container.getProject());
        }
        return projectTargets.get(container);
    }

    public IMakeTarget findTarget(IContainer container, String name) throws CoreException {
        ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(container.getProject());
        if (projectTargets == null) {
            projectTargets = this.readTargets(container.getProject());
        }
        return projectTargets.findTarget(container, name);
    }

    public IProject[] getTargetBuilderProjects() {
        return this.fProjects.toArray(new IProject[this.fProjects.size()]);
    }

    public String[] getTargetBuilders(IProject project) {
        if (this.fProjects.contains(project) || this.hasTargetBuilder(project)) {
            try {
                Vector ids = new Vector();
                IProjectDescription description = project.getDescription();
                ICommand[] builder = description.getBuildSpec();
                int i = 0;
                while (i < builder.length) {
                    Iterator entries = this.builderMap.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        if (!entry.getValue().equals(builder[i].getBuilderName())) continue;
                        ids.add(entry.getKey());
                    }
                    ++i;
                }
                return ids.toArray(new String[ids.size()]);
            }
            catch (CoreException coreException) {}
        }
        return new String[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasTargetBuilder(IProject project) {
        try {
            if (!project.isAccessible()) return false;
            IProjectDescription description = project.getDescription();
            ICommand[] builder = description.getBuildSpec();
            int j = 0;
            while (true) {
                if (j >= builder.length) {
                    return false;
                }
                if (this.builderMap.containsValue(builder[j].getBuilderName())) {
                    return true;
                }
                ++j;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void startup() {
        this.initializeBuilders();
        IProject[] project = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < project.length) {
            if (this.hasTargetBuilder(project[i])) {
                this.fProjects.add(project[i]);
            }
            ++i;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)new MakeTargetVisitor());
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }
    }

    protected void updateTarget(MakeTarget target) throws CoreException {
        if (target.getContainer() != null) {
            ProjectTargets projectTargets = (ProjectTargets)this.projectMap.get(target.getProject());
            if (projectTargets == null || !projectTargets.contains(target)) {
                return;
            }
            this.writeTargets(projectTargets);
            this.notifyListeners(new MakeTargetEvent((Object)this, 2, target));
        }
    }

    protected void writeTargets(ProjectTargets projectTargets) throws CoreException {
        projectTargets.saveTargets();
    }

    protected ProjectTargets readTargets(IProject project) {
        ProjectTargets projectTargets = new ProjectTargets(this, project);
        this.projectMap.put(project, projectTargets);
        return projectTargets;
    }

    protected void deleteTargets(IProject project) {
        IPath targetFilePath = MakeCorePlugin.getDefault().getStateLocation().append(project.getName()).addFileExtension(TARGETS_EXT);
        File targetFile = targetFilePath.toFile();
        if (targetFile.exists()) {
            targetFile.delete();
        }
        this.projectMap.remove(project);
    }

    protected void initializeBuilders() {
        this.builderMap = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", TARGET_BUILD_EXT);
        IExtension[] ext = point.getExtensions();
        int i = 0;
        while (i < ext.length) {
            IConfigurationElement[] element = ext[i].getConfigurationElements();
            int j = 0;
            while (j < element.length) {
                if (element[j].getName().equals("builder")) {
                    String builderID = element[j].getAttribute("builderID");
                    String targetID = element[j].getAttribute("id");
                    this.builderMap.put(targetID, builderID);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void notifyListeners(MakeTargetEvent event) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IMakeTargetListener)list[i]).targetChanged(event);
            ++i;
        }
    }

    public void addListener(IMakeTargetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IMakeTargetListener listener) {
        this.listeners.remove(this.listeners);
    }

    public String getBuilderID(String targetBuilderID) {
        return (String)this.builderMap.get(targetBuilderID);
    }

    class MakeTargetVisitor
    implements IResourceDeltaVisitor {
        MakeTargetVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                int flags = delta.getFlags();
                int deltaKind = delta.getKind();
                if (deltaKind == 1) {
                    if (MakeTargetManager.this.hasTargetBuilder(project) && !MakeTargetManager.this.fProjects.contains(project)) {
                        MakeTargetManager.this.fProjects.add(project);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                    }
                } else if (deltaKind == 2) {
                    if (MakeTargetManager.this.fProjects.contains(project)) {
                        MakeTargetManager.this.deleteTargets(project);
                        MakeTargetManager.this.fProjects.remove(project);
                        MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                    }
                } else if (deltaKind == 4) {
                    if ((flags & 0x80000) != 0) {
                        if (MakeTargetManager.this.fProjects.contains(project) && !MakeTargetManager.this.hasTargetBuilder(project)) {
                            MakeTargetManager.this.fProjects.remove(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                        } else if (!MakeTargetManager.this.fProjects.contains(project) && MakeTargetManager.this.hasTargetBuilder(project)) {
                            MakeTargetManager.this.fProjects.add(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                        }
                    }
                    if ((flags & 0x4000) != 0) {
                        if (!project.isOpen() && MakeTargetManager.this.fProjects.contains(project)) {
                            MakeTargetManager.this.fProjects.remove(project);
                            MakeTargetManager.this.projectMap.remove(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 5, project));
                        } else if (project.isOpen() && MakeTargetManager.this.hasTargetBuilder(project) && !MakeTargetManager.this.fProjects.contains(project)) {
                            MakeTargetManager.this.fProjects.add(project);
                            MakeTargetManager.this.notifyListeners(new MakeTargetEvent((Object)MakeTargetManager.this, 4, project));
                        }
                    }
                }
                return false;
            }
            return resource instanceof IWorkspaceRoot;
        }
    }
}

