/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPASTName
extends CPPASTNode
implements IASTName {
    private char[] name;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final String EMPTY_STRING = "";
    private IBinding binding = null;

    public CPPASTName(char[] name) {
        this.name = name;
    }

    public CPPASTName() {
        this.name = EMPTY_CHAR_ARRAY;
    }

    public IBinding resolveBinding() {
        if (this.binding == null) {
            this.binding = CPPVisitor.createBinding(this);
        }
        return this.binding;
    }

    public IBinding[] resolvePrefix() {
        return CPPSemantics.prefixLookup(this);
    }

    public void setBinding(IBinding binding) {
        this.binding = binding;
    }

    public IBinding getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.name == EMPTY_CHAR_ARRAY) {
            return EMPTY_STRING;
        }
        return new String(this.name);
    }

    public char[] toCharArray() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitNames) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: 
                case 3: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            switch (role) {
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

