/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PerFileDiscoveredPathContainer
extends DiscoveredPathContainer
implements IPathEntryContainerExtension {
    public PerFileDiscoveredPathContainer(IProject project) {
        super(project);
    }

    public IPathEntry[] getPathEntries(IPath path, int mask) {
        ArrayList<Object> entries = new ArrayList<Object>();
        try {
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            if (info instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo) {
                IPath fullResPath;
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo filePathInfo = (IDiscoveredPathManager.IPerFileDiscoveredPathInfo)info;
                if ((mask & 0x10) != 0) {
                    IPath[] includes = filePathInfo.getIncludePaths(path);
                    int i = 0;
                    while (i < includes.length) {
                        entries.add(CoreModel.newIncludeEntry((IPath)path, (IPath)Path.EMPTY, (IPath)includes[i], (boolean)true));
                        ++i;
                    }
                    includes = filePathInfo.getQuoteIncludePaths(path);
                    i = 0;
                    while (i < includes.length) {
                        entries.add(CoreModel.newIncludeEntry((IPath)path, (IPath)Path.EMPTY, (IPath)includes[i], (boolean)false));
                        ++i;
                    }
                }
                if ((mask & 0x40) != 0) {
                    Map syms = filePathInfo.getSymbols(path);
                    Iterator iter = syms.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        entries.add(CoreModel.newMacroEntry((IPath)path, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
                    }
                }
                if ((fullResPath = this.fProject.getWorkspace().getRoot().getFile(path).getLocation()) == null) {
                    fullResPath = path;
                }
                if ((mask & 0x100) != 0) {
                    IPath[] includeFiles = filePathInfo.getIncludeFiles(path);
                    int i = 0;
                    while (i < includeFiles.length) {
                        if (!includeFiles[i].equals((Object)fullResPath)) {
                            entries.add(CoreModel.newIncludeFileEntry((IPath)path, (IPath)includeFiles[i]));
                        }
                        ++i;
                    }
                }
                if ((mask & 0x200) != 0) {
                    IPath[] imacrosFiles = filePathInfo.getMacroFiles(path);
                    int i = 0;
                    while (i < imacrosFiles.length) {
                        if (!imacrosFiles[i].equals((Object)fullResPath)) {
                            entries.add(CoreModel.newMacroFileEntry((IPath)path, (IPath)imacrosFiles[i]));
                        }
                        ++i;
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public boolean isEmpty(IPath path) {
        try {
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
            if (info instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo) {
                IDiscoveredPathManager.IPerFileDiscoveredPathInfo filePathInfo = (IDiscoveredPathManager.IPerFileDiscoveredPathInfo)info;
                return filePathInfo.isEmpty(path);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

