/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.workingsets.CElementWorkingSetPageContentProvider;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final String PAGE_TITLE = WorkingSetMessages.getString("CElementWorkingSetPage.title");
    private static final String PAGE_ID = "CElementWorkingSetPage";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    CheckboxTreeViewer tree;
    IWorkingSet workingSet;
    private boolean firstCheck = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CElementWorkingSetPage() {
        super(PAGE_ID, PAGE_TITLE, CPluginImages.DESC_WIZABAN_C_APP);
        this.setDescription(WorkingSetMessages.getString("CElementWorkingSetPage.description"));
    }

    private void addWorkingSetElements(List collectedResources, IContainer container) {
        IAdaptable[] elements = this.workingSet.getElements();
        IPath containerPath = container.getFullPath();
        int i = 0;
        while (i < elements.length) {
            IPath resourcePath;
            IResource resource = null;
            if (elements[i] instanceof IResource) {
                resource = (IResource)elements[i];
            } else {
                IAdaptable iAdaptable = elements[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (resource != null && containerPath.isPrefixOf(resourcePath = resource.getFullPath())) {
                collectedResources.add(elements[i]);
            }
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.name"));
        GridData data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setFont(font);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CElementWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText(WorkingSetMessages.getString("CElementWorkingSetPage.content"));
        data = new GridData(772);
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.tree = new CheckboxTreeViewer(composite);
        this.tree.setUseHashlookup(true);
        this.tree.setContentProvider((IContentProvider)new CElementWorkingSetPageContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), CUIPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tree.setInput((Object)CUIPlugin.getWorkspace().getRoot());
        this.tree.setSorter((ViewerSorter)new CElementSorter());
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.tree.getControl().setLayoutData((Object)data);
        this.tree.getControl().setFont(font);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CElementWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        this.tree.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (!CElementWorkingSetPage.this.tree.getGrayed(element)) {
                    BusyIndicator.showWhile((Display)CElementWorkingSetPage.this.getShell().getDisplay(), (Runnable)new Runnable(this, element){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ Object val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = object;
                        }

                        public void run() {
                            3.access$0(this.this$1).setSubtreeChecked((IContainer)this.val$element, 3.access$0(this.this$1).tree.getChecked(this.val$element), false);
                        }
                    });
                }
            }

            static /* synthetic */ CElementWorkingSetPage access$0(3 var0) {
                return var0.CElementWorkingSetPage.this;
            }
        });
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
    }

    private void findCheckedResources(List checkedResources, IContainer container) {
        IResource[] resources = null;
        try {
            resources = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int i = 0;
        while (i < resources.length) {
            if (this.tree.getGrayed((Object)resources[i])) {
                if (resources[i].isAccessible()) {
                    this.findCheckedResources(checkedResources, (IContainer)resources[i]);
                } else {
                    this.addWorkingSetElements(checkedResources, (IContainer)resources[i]);
                }
            } else if (this.tree.getChecked((Object)resources[i])) {
                checkedResources.add(resources[i]);
            }
            ++i;
        }
    }

    public void finish() {
        ArrayList resources = new ArrayList(10);
        this.findCheckedResources(resources, (IContainer)this.tree.getInput());
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), resources.toArray(new IAdaptable[resources.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(resources.toArray(new IAdaptable[resources.size()]));
        }
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IResource resource = (IResource)event.getElement();
                boolean state = event.getChecked();
                CElementWorkingSetPage.this.tree.setGrayed((Object)resource, false);
                if (resource instanceof IContainer) {
                    CElementWorkingSetPage.this.setSubtreeChecked((IContainer)resource, state, true);
                }
                CElementWorkingSetPage.this.updateParentState(resource);
                CElementWorkingSetPage.this.validateInput();
            }
        });
    }

    private void handleCoreException(CoreException exception, Shell shell, String title, String message) {
        IStatus status = exception.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), (String)exception.getLocalizedMessage());
        }
    }

    private void initializeCheckedState() {
        if (this.workingSet == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] items = CElementWorkingSetPage.this.workingSet.getElements();
                CElementWorkingSetPage.this.tree.setCheckedElements(items);
                int i = 0;
                while (i < items.length) {
                    Object item = items[i];
                    IContainer container = null;
                    IResource resource = null;
                    if (item instanceof IContainer) {
                        container = (IContainer)item;
                    } else {
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IContainer");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        container = (IContainer)item.getAdapter((Class)clazz);
                    }
                    if (container != null) {
                        CElementWorkingSetPage.this.setSubtreeChecked(container, true, true);
                    }
                    if (item instanceof IResource) {
                        resource = (IResource)item;
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = (IResource)item.getAdapter((Class)clazz);
                    }
                    if (resource != null && !resource.isAccessible()) {
                        IProject project = resource.getProject();
                        if (!CElementWorkingSetPage.this.tree.getChecked((Object)project)) {
                            CElementWorkingSetPage.this.tree.setGrayChecked((Object)project, true);
                        }
                    } else {
                        CElementWorkingSetPage.this.updateParentState(resource);
                    }
                    ++i;
                }
            }
        });
    }

    public void setSelection(IWorkingSet workingSet) {
        if (workingSet == null) {
            throw new IllegalArgumentException("Working set must not be null");
        }
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    void setSubtreeChecked(IContainer container, boolean state, boolean checkExpandedState) {
        if (!container.isAccessible() || !this.tree.getExpandedState((Object)container) && state && checkExpandedState) {
            return;
        }
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            IResource element = members[i];
            boolean bl = elementGrayChecked = this.tree.getGrayed((Object)element) || this.tree.getChecked((Object)element);
            if (state) {
                this.tree.setChecked((Object)element, true);
                this.tree.setGrayed((Object)element, false);
            } else {
                this.tree.setGrayChecked((Object)element, false);
            }
            if (element instanceof IContainer && (state || elementGrayChecked)) {
                this.setSubtreeChecked((IContainer)element, state, true);
            }
            --i;
        }
    }

    void updateParentState(IResource child) {
        if (child == null || child.getParent() == null) {
            return;
        }
        IContainer parent = child.getParent();
        boolean childChecked = false;
        IResource[] members = null;
        try {
            members = parent.members();
        }
        catch (CoreException ex) {
            this.handleCoreException(ex, this.getShell(), WorkingSetMessages.getString("EditWorkingSetAction.nowizard.message"), "updateCheckedState");
        }
        int i = members.length - 1;
        while (i >= 0) {
            if (this.tree.getChecked((Object)members[i]) || this.tree.getGrayed((Object)members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.tree.setGrayChecked((Object)parent, childChecked);
        this.updateParentState((IResource)parent);
    }

    void validateInput() {
        String errorMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if (newText.equals("")) {
            errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.nameMustNotBeEmpty");
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int i = 0;
            while (i < workingSets.length) {
                if (newText.equals(workingSets[i].getName())) {
                    errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.workingSetExists");
                }
                ++i;
            }
        }
        if (errorMessage == null && this.tree.getCheckedElements().length == 0) {
            errorMessage = WorkingSetMessages.getString("CElementWorkingSetPage.warning.resourceMustBeChecked");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

