/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScannerConfigInfoFactory2 {
    private static final String SCANNER_CONFIG = "scannerConfiguration";
    private static final String SC_AUTODISCOVERY = "autodiscovery";
    private static final String ENABLED = "enabled";
    private static final String SELECTED_PROFILE_ID = "selectedProfileId";
    private static final String PROBLEM_REPORTING_ENABLED = "problemReportingEnabled";
    private static final String PROFILE = "profile";
    private static final String ID = "id";
    private static final String BUILD_OUTPUT_PROVIDER = "buildOutputProvider";
    private static final String OPEN_ACTION = "openAction";
    private static final String FILE_PATH = "filePath";
    private static final String PARSER = "parser";
    private static final String SCANNER_INFO_PROVIDER = "scannerInfoProvider";
    private static final String RUN_ACTION = "runAction";
    private static final String USE_DEFAULT = "useDefault";
    private static final String COMMAND = "command";
    private static final String ARGUMENTS = "arguments";
    private static final String DOT = ".";
    private static final String SCD = "SCD.";
    private static final String SCANNER_CONFIG_AUTODISCOVERY_ENABLED = "SCD.enabled";
    private static final String SCANNER_CONFIG_SELECTED_PROFILE_ID = "SCD.selectedProfileId";
    private static final String SCANNER_CONFIG_PROBLEM_REPORTING_ENABLED = "SCD.problemReportingEnabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_ENABLED = ".BOP.open.enabled";
    private static final String BUILD_OUTPUT_OPEN_ACTION_FILE_PATH = ".BOP.open.path";
    private static final String BUILD_OUTPUT_PARSER_ENABLED = ".BOP.parser.enabled";
    private static final String SI_PROVIDER_RUN_ACTION_USE_DEFAULT = ".run.useDefault";
    private static final String SI_PROVIDER_RUN_ACTION_COMMAND = ".run.command";
    private static final String SI_PROVIDER_RUN_ACTION_ARGUMENTS = ".run.arguments";
    private static final String SI_PROVIDER_OPEN_ACTION_FILE_PATH = ".open.path";
    private static final String SI_PROVIDER_PARSER_ENABLED = ".parser.enabled";

    public static IScannerConfigBuilderInfo2 create(IProject project, String profileId) throws CoreException {
        return new BuildProperty(project, profileId);
    }

    public static IScannerConfigBuilderInfo2 create(Preferences prefs, String profileId, boolean useDefaults) {
        return new Preference(prefs, profileId, useDefaults);
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private String profileId;

        BuildProperty(IProject project, String profileId) {
            this.project = project;
            this.profileId = profileId;
            this.load();
        }

        protected void load() {
            List profileIds = ScannerConfigProfileManager.getInstance().getProfileIds();
            ArrayList<String> loadedProfiles = new ArrayList<String>();
            try {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.project, false);
                Node sc = descriptor.getProjectData(ScannerConfigInfoFactory2.SCANNER_CONFIG).getFirstChild();
                while (sc != null) {
                    if (sc.getNodeName().equals(ScannerConfigInfoFactory2.SC_AUTODISCOVERY)) {
                        this.autoDiscoveryEnabled = Boolean.valueOf(((Element)sc).getAttribute(ScannerConfigInfoFactory2.ENABLED));
                        this.selectedProfile = this.profileId == "" ? ((Element)sc).getAttribute(ScannerConfigInfoFactory2.SELECTED_PROFILE_ID) : this.profileId;
                        this.problemReportingEnabled = Boolean.valueOf(((Element)sc).getAttribute(ScannerConfigInfoFactory2.PROBLEM_REPORTING_ENABLED));
                    } else if (sc.getNodeName().equals(ScannerConfigInfoFactory2.PROFILE) && profileIds.contains(((Element)sc).getAttribute(ScannerConfigInfoFactory2.ID))) {
                        this.load(sc);
                        loadedProfiles.add(((Element)sc).getAttribute(ScannerConfigInfoFactory2.ID));
                    }
                    sc = sc.getNextSibling();
                }
                if (loadedProfiles.size() < 1) {
                    if (this.migrateScannerConfigBuildInfo(ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID)) {
                        loadedProfiles.add(ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID);
                    } else {
                        this.autoDiscoveryEnabled = false;
                    }
                }
                if (loadedProfiles.size() < profileIds.size()) {
                    Iterator i = profileIds.iterator();
                    while (i.hasNext()) {
                        String profileId = (String)i.next();
                        if (loadedProfiles.contains(profileId)) continue;
                        this.loadDefaults(profileId);
                        loadedProfiles.add(profileId);
                    }
                }
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
            }
        }

        private void loadDefaults(String profileId) {
            Store.ProfileOptions po = new Store.ProfileOptions();
            po.buildOutputFileActionEnabled = false;
            po.buildOutputParserEnabled = true;
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            po.providerOptionsMap = new LinkedHashMap();
            Iterator i = configuredProfile.getSIProviderIds().iterator();
            while (i.hasNext()) {
                String providerId = (String)i.next();
                Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                ScannerConfigProfile.ScannerInfoProvider configuredProvider = configuredProfile.getScannerInfoProviderElement(providerId);
                ppo.providerKind = configuredProvider.getProviderKind();
                ppo.providerOutputParserEnabled = false;
                if (ppo.providerKind.equals("run")) {
                    ppo.providerRunUseDefault = true;
                    ppo.providerRunCommand = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.COMMAND);
                    ppo.providerRunArguments = configuredProvider.getAction().getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                } else if (ppo.providerKind.equals("open")) {
                    ppo.providerOpenFilePath = configuredProvider.getAction().getAttribute("file");
                }
                po.providerOptionsMap.put(providerId, ppo);
            }
            if (this.profileOptionsMap == null) {
                this.profileOptionsMap = new LinkedHashMap();
            }
            this.profileOptionsMap.put(profileId, po);
        }

        private boolean migrateScannerConfigBuildInfo(String profileId) {
            boolean rc = true;
            try {
                IScannerConfigBuilderInfo oldInfo = MakeCorePlugin.createScannerConfigBuildInfo(this.project, ScannerConfigBuilder.BUILDER_ID);
                this.autoDiscoveryEnabled = oldInfo.isAutoDiscoveryEnabled();
                this.problemReportingEnabled = oldInfo.isSIProblemGenerationEnabled();
                this.selectedProfile = profileId;
                Store.ProfileOptions po = new Store.ProfileOptions();
                po.buildOutputFileActionEnabled = false;
                po.buildOutputParserEnabled = oldInfo.isMakeBuilderConsoleParserEnabled();
                Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                ppo.providerKind = "run";
                ppo.providerOutputParserEnabled = oldInfo.isESIProviderCommandEnabled();
                ppo.providerRunUseDefault = oldInfo.isDefaultESIProviderCmd();
                ppo.providerRunCommand = oldInfo.getESIProviderCommand().toString();
                ppo.providerRunArguments = oldInfo.getESIProviderArguments();
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(this.selectedProfile);
                String providerId = (String)configuredProfile.getSIProviderIds().get(0);
                po.providerOptionsMap = new LinkedHashMap(1);
                po.providerOptionsMap.put(providerId, ppo);
                this.profileOptionsMap = new LinkedHashMap(1);
                this.profileOptionsMap.put(profileId, po);
                this.isDirty = true;
                this.save();
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                rc = false;
            }
            return rc;
        }

        private void load(Node profile) {
            if (this.profileOptionsMap == null) {
                this.profileOptionsMap = new LinkedHashMap(1);
            }
            Store.ProfileOptions po = new Store.ProfileOptions();
            String profileId = ((Element)profile).getAttribute(ScannerConfigInfoFactory2.ID);
            this.profileOptionsMap.put(profileId, po);
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            List providerIds = configuredProfile.getSIProviderIds();
            int providerCounter = 0;
            po.providerOptionsMap = new LinkedHashMap(providerIds.size());
            Node child = profile.getFirstChild();
            while (child != null) {
                if (ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER.equals(child.getNodeName())) {
                    Node grandchild = child.getFirstChild();
                    while (grandchild != null) {
                        if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getNodeName())) {
                            po.buildOutputFileActionEnabled = Boolean.valueOf(((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.ENABLED));
                            po.buildOutputFilePath = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                        } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getNodeName())) {
                            po.buildOutputParserEnabled = Boolean.valueOf(((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.ENABLED));
                        }
                        grandchild = grandchild.getNextSibling();
                    }
                } else if (ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER.equals(child.getNodeName())) {
                    String providerId = ((Element)child).getAttribute(ScannerConfigInfoFactory2.ID);
                    if (providerIds.get(providerCounter).equals(providerId)) {
                        Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                        po.providerOptionsMap.put(providerId, ppo);
                        ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                        Node grandchild = child.getFirstChild();
                        while (grandchild != null) {
                            if (ScannerConfigInfoFactory2.RUN_ACTION.equals(grandchild.getNodeName())) {
                                ppo.providerRunUseDefault = Boolean.valueOf(((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.USE_DEFAULT));
                                ppo.providerRunCommand = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.COMMAND);
                                ppo.providerRunArguments = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                            } else if (ScannerConfigInfoFactory2.OPEN_ACTION.equals(grandchild.getNodeName())) {
                                ppo.providerOpenFilePath = ((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.FILE_PATH);
                            } else if (ScannerConfigInfoFactory2.PARSER.equals(grandchild.getNodeName())) {
                                ppo.providerOutputParserEnabled = Boolean.valueOf(((Element)grandchild).getAttribute(ScannerConfigInfoFactory2.ENABLED));
                            }
                            grandchild = grandchild.getNextSibling();
                        }
                        ++providerCounter;
                    }
                }
                child = child.getNextSibling();
            }
        }

        private boolean store() throws CoreException {
            if (this.isDirty) {
                ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.project, true);
                Element sc = descriptor.getProjectData(ScannerConfigInfoFactory2.SCANNER_CONFIG);
                Document doc = sc.getOwnerDocument();
                Node child = sc.getFirstChild();
                while (child != null) {
                    sc.removeChild(child);
                    child = sc.getFirstChild();
                }
                Element autod = doc.createElement(ScannerConfigInfoFactory2.SC_AUTODISCOVERY);
                sc.appendChild(autod);
                autod.setAttribute(ScannerConfigInfoFactory2.ENABLED, Boolean.toString(this.autoDiscoveryEnabled));
                autod.setAttribute(ScannerConfigInfoFactory2.SELECTED_PROFILE_ID, this.selectedProfile);
                autod.setAttribute(ScannerConfigInfoFactory2.PROBLEM_REPORTING_ENABLED, Boolean.toString(this.problemReportingEnabled));
                Iterator i = this.profileOptionsMap.keySet().iterator();
                while (i.hasNext()) {
                    String profileId = (String)i.next();
                    Element profile = doc.createElement(ScannerConfigInfoFactory2.PROFILE);
                    profile.setAttribute(ScannerConfigInfoFactory2.ID, profileId);
                    this.store(profile, (Store.ProfileOptions)this.profileOptionsMap.get(profileId));
                    sc.appendChild(profile);
                }
                this.isDirty = false;
                return true;
            }
            return false;
        }

        private void store(Element profile, Store.ProfileOptions po) {
            Document doc = profile.getOwnerDocument();
            Element child = doc.createElement(ScannerConfigInfoFactory2.BUILD_OUTPUT_PROVIDER);
            Element grandchild = doc.createElement(ScannerConfigInfoFactory2.OPEN_ACTION);
            grandchild.setAttribute(ScannerConfigInfoFactory2.ENABLED, Boolean.toString(po.buildOutputFileActionEnabled));
            grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, po.buildOutputFilePath);
            child.appendChild(grandchild);
            grandchild = doc.createElement(ScannerConfigInfoFactory2.PARSER);
            grandchild.setAttribute(ScannerConfigInfoFactory2.ENABLED, Boolean.toString(po.buildOutputParserEnabled));
            child.appendChild(grandchild);
            profile.appendChild(child);
            ArrayList providerIds = new ArrayList(po.providerOptionsMap.keySet());
            int i = 0;
            while (i < providerIds.size()) {
                String providerId = (String)providerIds.get(i);
                Store.ProfileOptions.ProviderOptions ppo = (Store.ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                if (ppo != null) {
                    child = doc.createElement(ScannerConfigInfoFactory2.SCANNER_INFO_PROVIDER);
                    child.setAttribute(ScannerConfigInfoFactory2.ID, providerId);
                    String providerKind = ppo.providerKind;
                    if (providerKind.equals("run")) {
                        grandchild = doc.createElement(ScannerConfigInfoFactory2.RUN_ACTION);
                        grandchild.setAttribute(ScannerConfigInfoFactory2.USE_DEFAULT, Boolean.toString(ppo.providerRunUseDefault));
                        grandchild.setAttribute(ScannerConfigInfoFactory2.COMMAND, ppo.providerRunCommand);
                        grandchild.setAttribute(ScannerConfigInfoFactory2.ARGUMENTS, ppo.providerRunArguments);
                    } else if (providerKind.equals("open")) {
                        grandchild = doc.createElement(ScannerConfigInfoFactory2.OPEN_ACTION);
                        grandchild.setAttribute(ScannerConfigInfoFactory2.FILE_PATH, ppo.providerOpenFilePath);
                    }
                    child.appendChild(grandchild);
                    grandchild = doc.createElement(ScannerConfigInfoFactory2.PARSER);
                    grandchild.setAttribute(ScannerConfigInfoFactory2.ENABLED, Boolean.toString(ppo.providerOutputParserEnabled));
                    child.appendChild(grandchild);
                    profile.appendChild(child);
                }
                ++i;
            }
        }

        public synchronized void save() throws CoreException {
            if (this.store()) {
                ICDescriptorOperation op = new ICDescriptorOperation(this){
                    final /* synthetic */ BuildProperty this$1;
                    {
                        this.this$1 = buildProperty;
                    }

                    public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                        descriptor.saveProjectData();
                    }
                };
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.project, op, null);
            }
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String profileId;
        private boolean useDefaults;

        public Preference(Preferences prefs, String profileId, boolean useDefaults) {
            this.prefs = prefs;
            this.profileId = profileId;
            this.useDefaults = useDefaults;
            this.load();
        }

        protected void load() {
            this.autoDiscoveryEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCANNER_CONFIG_AUTODISCOVERY_ENABLED);
            this.selectedProfile = "".equals(this.profileId) ? this.getString(ScannerConfigInfoFactory2.SCANNER_CONFIG_SELECTED_PROFILE_ID) : this.profileId;
            this.problemReportingEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCANNER_CONFIG_PROBLEM_REPORTING_ENABLED);
            if ("".equals(this.selectedProfile) && !this.useDefaults) {
                this.selectedProfile = this.prefs.getDefaultString(ScannerConfigInfoFactory2.SCANNER_CONFIG_SELECTED_PROFILE_ID);
            }
            List profileIds = ScannerConfigProfileManager.getInstance().getProfileIds();
            this.profileOptionsMap = new LinkedHashMap(profileIds.size());
            Iterator I = profileIds.iterator();
            while (I.hasNext()) {
                String profileId = (String)I.next();
                Store.ProfileOptions po = new Store.ProfileOptions();
                this.profileOptionsMap.put(profileId, po);
                boolean profileStored = this.getBoolean(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + ScannerConfigInfoFactory2.ENABLED);
                if (!profileStored && !this.useDefaults) {
                    this.loadFromProfileConfiguration(po, profileId);
                    continue;
                }
                po.buildOutputFileActionEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED);
                po.buildOutputFilePath = this.getString(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH);
                po.buildOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED);
                ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                List providerIds = configuredProfile.getSIProviderIds();
                po.providerOptionsMap = new LinkedHashMap(providerIds.size());
                int i = 0;
                while (i < providerIds.size()) {
                    String providerId = (String)providerIds.get(i);
                    Store.ProfileOptions.ProviderOptions ppo = new Store.ProfileOptions.ProviderOptions();
                    po.providerOptionsMap.put(providerId, ppo);
                    ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                    ppo.providerOutputParserEnabled = this.getBoolean(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED);
                    if (ppo.providerKind.equals("run")) {
                        ppo.providerRunUseDefault = this.getBoolean(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT);
                        ppo.providerRunCommand = this.getString(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND);
                        ppo.providerRunArguments = this.getString(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS);
                    } else if (ppo.providerKind.equals("open")) {
                        ppo.providerOpenFilePath = this.getString(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH);
                    }
                    ++i;
                }
            }
        }

        private void store() {
            if (this.isDirty) {
                this.set(ScannerConfigInfoFactory2.SCANNER_CONFIG_AUTODISCOVERY_ENABLED, this.autoDiscoveryEnabled);
                this.set(ScannerConfigInfoFactory2.SCANNER_CONFIG_SELECTED_PROFILE_ID, this.selectedProfile);
                this.set(ScannerConfigInfoFactory2.SCANNER_CONFIG_PROBLEM_REPORTING_ENABLED, this.problemReportingEnabled);
                ArrayList profileIds = new ArrayList(this.profileOptionsMap.keySet());
                Iterator I = profileIds.iterator();
                while (I.hasNext()) {
                    String profileId = (String)I.next();
                    Store.ProfileOptions po = (Store.ProfileOptions)this.profileOptionsMap.get(profileId);
                    this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + ScannerConfigInfoFactory2.ENABLED, !this.useDefaults);
                    this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_ENABLED, po.buildOutputFileActionEnabled);
                    this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_OPEN_ACTION_FILE_PATH, po.buildOutputFilePath);
                    this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.BUILD_OUTPUT_PARSER_ENABLED, po.buildOutputParserEnabled);
                    ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
                    List providerIds = configuredProfile.getSIProviderIds();
                    int i = 0;
                    while (i < providerIds.size()) {
                        String providerId = (String)providerIds.get(i);
                        Store.ProfileOptions.ProviderOptions ppo = (Store.ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                        this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_PARSER_ENABLED, ppo.providerOutputParserEnabled);
                        String providerKind = ppo.providerKind;
                        if (providerKind.equals("run")) {
                            this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_USE_DEFAULT, ppo.providerRunUseDefault);
                            this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_COMMAND, ppo.providerRunCommand);
                            this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_RUN_ACTION_ARGUMENTS, ppo.providerRunArguments);
                        } else if (providerKind.equals("open")) {
                            this.set(ScannerConfigInfoFactory2.SCD + profileId + ScannerConfigInfoFactory2.DOT + providerId + ScannerConfigInfoFactory2.SI_PROVIDER_OPEN_ACTION_FILE_PATH, ppo.providerOpenFilePath);
                        }
                        ++i;
                    }
                }
                this.isDirty = false;
            }
        }

        private boolean getBoolean(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultBoolean(name);
            }
            return this.prefs.getBoolean(name);
        }

        private void set(String name, boolean value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        private String getString(String name) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(name);
            }
            return this.prefs.getString(name);
        }

        private void set(String name, String value) {
            if (this.useDefaults) {
                this.prefs.setDefault(name, value);
            } else {
                this.prefs.setValue(name, value);
            }
        }

        public void save() throws CoreException {
            this.store();
        }
    }

    private static abstract class Store
    implements IScannerConfigBuilderInfo2 {
        protected static final String EMPTY_STRING = "";
        protected boolean isDirty = false;
        protected boolean autoDiscoveryEnabled;
        protected boolean problemReportingEnabled;
        protected String selectedProfile = "";
        protected Map profileOptionsMap;

        protected Store() {
        }

        public boolean isAutoDiscoveryEnabled() {
            return this.autoDiscoveryEnabled;
        }

        public void setAutoDiscoveryEnabled(boolean enable) {
            this.autoDiscoveryEnabled = this.setDirty(this.autoDiscoveryEnabled, enable);
        }

        public boolean isProblemReportingEnabled() {
            return this.problemReportingEnabled;
        }

        public void setProblemReportingEnabled(boolean enable) {
            this.problemReportingEnabled = this.setDirty(this.problemReportingEnabled, enable);
        }

        public String getSelectedProfileId() {
            return this.selectedProfile;
        }

        public void setSelectedProfileId(String profileId) {
            this.selectedProfile = this.setDirty(this.selectedProfile, profileId);
        }

        public List getProfileIdList() {
            return new ArrayList(this.profileOptionsMap.keySet());
        }

        public boolean isBuildOutputFileActionEnabled() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFileActionEnabled : false;
        }

        public void setBuildOutputFileActionEnabled(boolean enable) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFileActionEnabled = this.setDirty(po.buildOutputFileActionEnabled, enable);
            }
        }

        public String getBuildOutputFilePath() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputFilePath : EMPTY_STRING;
        }

        public void setBuildOutputFilePath(String path) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputFilePath = this.setDirty(po.buildOutputFilePath, path);
            }
        }

        public boolean isBuildOutputParserEnabled() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? po.buildOutputParserEnabled : true;
        }

        public void setBuildOutputParserEnabled(boolean enable) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                po.buildOutputParserEnabled = this.setDirty(po.buildOutputParserEnabled, enable);
            }
        }

        public List getProviderIdList() {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            return po != null ? new ArrayList(po.providerOptionsMap.keySet()) : new ArrayList(0);
        }

        public boolean isProviderOutputParserEnabled(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerOutputParserEnabled;
            }
            return false;
        }

        public void setProviderOutputParserEnabled(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOutputParserEnabled = this.setDirty(ppo.providerOutputParserEnabled, enable);
            }
        }

        public boolean isUseDefaultProviderCommand(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? false : ppo.providerRunUseDefault;
            }
            return false;
        }

        public void setUseDefaultProviderCommand(String providerId, boolean enable) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunUseDefault = this.setDirty(ppo.providerRunUseDefault, enable);
            }
        }

        public String getProviderRunCommand(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunCommand;
            }
            return null;
        }

        public void setProviderRunCommand(String providerId, String command) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunCommand = this.setDirty(ppo.providerRunCommand, command);
            }
        }

        public String getProviderRunArguments(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerRunArguments;
            }
            return null;
        }

        public void setProviderRunArguments(String providerId, String arguments) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerRunArguments = this.setDirty(ppo.providerRunArguments, arguments);
            }
        }

        public String getProviderOpenFilePath(String providerId) {
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null) {
                ProfileOptions.ProviderOptions ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId);
                return ppo == null ? null : ppo.providerOpenFilePath;
            }
            return null;
        }

        public void setProviderOpenFilePath(String providerId, String filePath) {
            ProfileOptions.ProviderOptions ppo;
            ProfileOptions po = (ProfileOptions)this.profileOptionsMap.get(this.selectedProfile);
            if (po != null && (ppo = (ProfileOptions.ProviderOptions)po.providerOptionsMap.get(providerId)) != null) {
                ppo.providerOpenFilePath = this.setDirty(ppo.providerOpenFilePath, filePath);
            }
        }

        private boolean setDirty(boolean l, boolean r) {
            this.isDirty = this.isDirty || l != r;
            return r;
        }

        private String setDirty(String l, String r) {
            this.isDirty = this.isDirty || !l.equals(r);
            return r;
        }

        protected abstract void load();

        protected void loadFromProfileConfiguration(ProfileOptions po, String profileId) {
            ScannerConfigProfile configuredProfile = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId);
            List providerIds = configuredProfile.getSIProviderIds();
            po.buildOutputParserEnabled = false;
            po.buildOutputFileActionEnabled = false;
            po.buildOutputFilePath = EMPTY_STRING;
            if (configuredProfile.getBuildOutputProviderElement() != null) {
                po.buildOutputParserEnabled = true;
                if (configuredProfile.getBuildOutputProviderElement().getAction() != null) {
                    po.buildOutputFileActionEnabled = true;
                    String buildOutputFilePath = configuredProfile.getBuildOutputProviderElement().getAction().getAttribute("file");
                    po.buildOutputFilePath = buildOutputFilePath != null ? buildOutputFilePath : EMPTY_STRING;
                }
            }
            po.providerOptionsMap = new LinkedHashMap(providerIds.size());
            int i = 0;
            while (i < providerIds.size()) {
                String attrValue;
                ProfileOptions.ProviderOptions ppo = new ProfileOptions.ProviderOptions();
                String providerId = (String)providerIds.get(i);
                po.providerOptionsMap.put(providerId, ppo);
                ppo.providerOutputParserEnabled = configuredProfile.getScannerInfoProviderElement(providerId) != null;
                ppo.providerKind = configuredProfile.getScannerInfoProviderElement(providerId).getProviderKind();
                if (ppo.providerKind.equals("run")) {
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute(ScannerConfigInfoFactory2.COMMAND);
                    ppo.providerRunCommand = attrValue != null ? attrValue : EMPTY_STRING;
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute(ScannerConfigInfoFactory2.ARGUMENTS);
                    ppo.providerRunArguments = attrValue != null ? attrValue : EMPTY_STRING;
                    ppo.providerRunUseDefault = true;
                } else if (ppo.providerKind.equals("open")) {
                    attrValue = configuredProfile.getScannerInfoProviderElement(providerId).getAction().getAttribute("file");
                    ppo.providerOpenFilePath = attrValue != null ? attrValue : EMPTY_STRING;
                }
                ++i;
            }
        }

        static class ProfileOptions {
            protected boolean buildOutputFileActionEnabled;
            protected String buildOutputFilePath = "";
            protected boolean buildOutputParserEnabled;
            protected Map providerOptionsMap;

            ProfileOptions() {
            }

            static class ProviderOptions {
                protected String providerKind;
                protected boolean providerOutputParserEnabled;
                protected boolean providerRunUseDefault;
                protected String providerRunCommand = "";
                protected String providerRunArguments = "";
                protected String providerOpenFilePath = "";

                ProviderOptions() {
                }
            }
        }
    }
}

