/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;

public final class FindBindingsInBTree
extends PDOMNamedNode.NodeFinder {
    private List bindings = new ArrayList();
    private final int[] desiredType;

    public FindBindingsInBTree(PDOM pdom, char[] name) {
        this(pdom, name, null);
    }

    public FindBindingsInBTree(PDOM pdom, char[] name, int desiredType) {
        this(pdom, name, new int[]{desiredType});
    }

    public FindBindingsInBTree(PDOM pdom, char[] name, int[] desiredType) {
        super(pdom, name);
        this.desiredType = desiredType;
    }

    public boolean visit(int record) throws CoreException {
        if (record == 0) {
            return true;
        }
        PDOMBinding tBinding = this.pdom.getBinding(record);
        if (!tBinding.hasName(this.name)) {
            return false;
        }
        if (this.desiredType == null) {
            this.bindings.add(tBinding);
            return true;
        }
        int nodeType = tBinding.getNodeType();
        int i = 0;
        while (i < this.desiredType.length) {
            if (nodeType == this.desiredType[i]) {
                this.bindings.add(tBinding);
                return true;
            }
            ++i;
        }
        return true;
    }

    public IBinding[] getBinding() {
        return this.bindings.toArray(new IBinding[this.bindings.size()]);
    }
}

