/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IProject project;
        ISourceContainer[] common = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().getSourceContainers();
        ArrayList<Object> containers = new ArrayList<Object>(common.length + 1);
        int i = 0;
        while (i < common.length) {
            Object sc = common[i];
            if (sc.getType().getId().equals(MappingSourceContainer.TYPE_ID)) {
                sc = ((MappingSourceContainer)((Object)sc)).copy();
            }
            containers.add(sc);
            ++i;
        }
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (projectName != null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            containers.add(0, new ProjectSourceContainer(project, true));
        }
        containers.add((Object)new AbsolutePathSourceContainer());
        return containers.toArray(new ISourceContainer[containers.size()]);
    }
}

