/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.actions.AddBlockCommentAction;
import org.eclipse.cdt.internal.ui.actions.FoldingActionGroup;
import org.eclipse.cdt.internal.ui.actions.GoToNextPreviousMemberAction;
import org.eclipse.cdt.internal.ui.actions.JoinLinesAction;
import org.eclipse.cdt.internal.ui.actions.RemoveBlockCommentAction;
import org.eclipse.cdt.internal.ui.editor.AddIncludeOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.CAnnotationIterator;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.GotoMatchingBracketAction;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.internal.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.cdt.internal.ui.search.actions.OpenDefinitionAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.text.CPairMatcher;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.util.CUIHelp;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.ShowInCViewAction;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.actions.TextSearchGroup;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class CEditor
extends TextEditor
implements ISelectionChangedListener,
IShowInSource,
IReconcilingParticipant {
    private InformationPresenter fInformationPresenter;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    protected CContentOutlinePage fOutlinePage;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fTextSearchGroup;
    private ShowInCViewAction fShowInCViewAction;
    protected ISelectionChangedListener fStatusLineClearer;
    protected ISelectionChangedListener fSelectionUpdateListener;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected CPairMatcher fBracketMatcher = new CPairMatcher(BRACKETS);
    private TabConverter fTabConverter;
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    public static final String LINKED_POSITION_COLOR = "linkedPositionColor";
    private static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    private ProjectionSupport fProjectionSupport;
    private ICFoldingStructureProvider fProjectionModelUpdater;
    private FoldingActionGroup fFoldingGroup;
    private boolean fIsUpdatingAnnotationViews = false;
    private IMarker fLastMarkerTarget = null;
    public static final String LANGUAGE_CPP = "CEditor.language.cpp";
    public static final String LANGUAGE_C = "CEditor.language.c";
    protected String fOutlinerContextMenuId;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    protected void initializeEditor() {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new CSourceViewerConfiguration(textTools, this));
        this.setDocumentProvider((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.setOutlinerContextMenuId("#CEditorOutlinerContext");
        this.setPreferenceStore(CUIPlugin.getDefault().getCombinedPreferenceStore());
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        CEditor.setOutlinePageInput(this.fOutlinePage, input);
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.updateEditorImage(this.getInputCElement());
        }
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public ICElement getInputCElement() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
    }

    public IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        CEditor.setOutlinePageInput(this.fOutlinePage, this.getEditorInput());
        return this.fOutlinePage;
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getOutlinePage();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (required == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.cdt.ui.CView", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required) && this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        asv = (CSourceViewer)this.getSourceViewer();
        try {
            block12: {
                block10: {
                    block11: {
                        if (asv == null) ** GOTO lbl-1000
                        property = event.getProperty();
                        if ("tabWidth".equals(property)) {
                            configuration = this.getSourceViewerConfiguration();
                            types = configuration.getConfiguredContentTypes((ISourceViewer)asv);
                            i = 0;
                            while (true) {
                                if (i >= types.length) {
                                    if (this.fTabConverter == null) break;
                                    this.fTabConverter.setNumberOfSpacesPerTab(configuration.getTabWidth((ISourceViewer)asv));
                                    break;
                                }
                                asv.setIndentPrefixes(configuration.getIndentPrefixes((ISourceViewer)asv, types[i]), types[i]);
                                ++i;
                            }
lbl18:
                            // 6 sources

                            while (true) {
                                var7_8 = null;
                                super.handlePreferenceStoreChanged(event);
                                return;
                            }
                        }
                        if (!"spacesForTabs".equals(property)) break block10;
                        if (!this.isTabConversionEnabled()) break block11;
                        this.startTabConversion();
                        ** GOTO lbl18
                    }
                    this.stopTabConversion();
                    ** GOTO lbl18
                }
                if ("org.eclipse.cdt.core.translation.taskTags".equals(event.getProperty()) && (sourceViewer = this.getSourceViewer()) != null && this.affectsTextPresentation(event)) {
                    sourceViewer.invalidateTextPresentation();
                }
                if (!"editor_folding_provider".equals(property)) break block12;
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
                this.fProjectionModelUpdater = CUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                if (this.fProjectionModelUpdater == null) ** GOTO lbl18
                this.fProjectionModelUpdater.install((ITextEditor)this, asv);
                ** continue;
            }
            c = asv.getContentAssistant();
            if (c instanceof ContentAssistant) {
                ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
            }
        }
        catch (Throwable var8_11) {
            var7_9 = null;
            super.handlePreferenceStoreChanged(event);
            throw var8_11;
        }
lbl-1000:
        // 2 sources

        {
            var7_10 = null;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        this.updateStatusLine();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ICElement element) {
        if (element == null || element instanceof ITranslationUnit) {
            return;
        }
        if (element instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)element;
            this.setSelection(reference, true);
        }
    }

    public void setSelection(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            StyledText textWidget = null;
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer != null) {
                textWidget = sourceViewer.getTextWidget();
            }
            if (textWidget == null) {
                return;
            }
            try {
                this.setSelection(element.getSourceRange(), moveCursor);
            }
            catch (CModelException cModelException) {}
        }
    }

    public void setSelection(ISourceRange element, boolean moveCursor) {
        if (element == null) {
            return;
        }
        try {
            IRegion alternateRegion = null;
            int start = element.getStartPos();
            int length = element.getLength();
            if (start < 0 || length < 0) {
                start = 0;
                length = 0;
            }
            if (length == 0 && start == 0 && element.getStartLine() > 0) {
                start = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getStartLine() - 1);
                length = element.getEndLine() > 0 ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineOffset(element.getEndLine()) - start : start;
                alternateRegion = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).getLineInformation(element.getStartLine() - 1);
                if ((start == length || length < 0) && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
            }
            this.setHighlightRange(start, length, moveCursor);
            if (moveCursor) {
                start = element.getIdStartPos();
                length = element.getIdLength();
                if (start == 0 && length == 0 && alternateRegion != null) {
                    start = alternateRegion.getOffset();
                    length = alternateRegion.getLength();
                }
                if (start > -1 && this.getSourceViewer() != null) {
                    this.getSourceViewer().revealRange(start, length);
                    this.getSourceViewer().setSelectedRange(start, length);
                }
                this.updateStatusField("CursorPosition");
            }
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (BadLocationException badLocationException) {}
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void dispose() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.dispose();
            this.fCEditorErrorTickUpdater = null;
        }
        if (this.fSelectionUpdateListener != null) {
            this.getSelectionProvider().addSelectionChangedListener(this.fSelectionUpdateListener);
            this.fSelectionUpdateListener = null;
        }
        if (this.fStatusLineClearer != null) {
            ISelectionProvider provider = this.getSelectionProvider();
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.dispose();
            this.fOutlinePage = null;
        }
        if (this.fShowInCViewAction != null) {
            this.fShowInCViewAction.dispose();
            this.fShowInCViewAction = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fTextSearchGroup != null) {
            this.fTextSearchGroup.dispose();
            this.fTextSearchGroup = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        this.stopTabConversion();
        super.dispose();
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        IFile file;
        IFile file2;
        String oldLanguage = "";
        if (originalElement instanceof IFileEditorInput && (file2 = ((IFileEditorInput)originalElement).getFile()) != null) {
            IContentType type = CCorePlugin.getContentType((IProject)file2.getProject(), (String)file2.getName());
            if (type != null) {
                oldLanguage = type.getId();
            }
            if (oldLanguage == null) {
                return false;
            }
        }
        String newLanguage = "";
        if (movedElement instanceof IFileEditorInput && (file = ((IFileEditorInput)movedElement).getFile()) != null) {
            IContentType type = CCorePlugin.getContentType((IProject)file.getProject(), (String)file.getName());
            if (type != null) {
                newLanguage = type.getId();
            }
            if (newLanguage == null) {
                return false;
            }
        }
        return oldLanguage.equals(newLanguage);
    }

    protected void createActions() {
        super.createActions();
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getSourceViewer());
        TextOperationAction resAction = new TextOperationAction(CEditorMessages.getResourceBundle(), "ShowToolTip.", (ITextEditor)this, 16, true);
        InformationDispatchAction resAction2 = new InformationDispatchAction(CEditorMessages.getResourceBundle(), "ShowToolTip.", resAction);
        resAction2.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.show.tooltip");
        this.setAction("ShowToolTip", (IAction)resAction2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)resAction2, "org.eclipse.cdt.ui.show_tooltip_action");
        Object action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new JoinLinesAction(CEditorMessages.getResourceBundle(), "JoinLines.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.join.lines");
        this.setAction("Join Lines", (IAction)action);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new AddBlockCommentAction(CEditorMessages.getResourceBundle(), "AddBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.block.comment");
        this.setAction("AddBlockComment", (IAction)action);
        this.markAsStateDependentAction("AddBlockComment", true);
        this.markAsSelectionDependentAction("AddBlockComment", true);
        action = new RemoveBlockCommentAction(CEditorMessages.getResourceBundle(), "RemoveBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.remove.block.comment");
        this.setAction("RemoveBlockComment", (IAction)action);
        this.markAsStateDependentAction("RemoveBlockComment", true);
        this.markAsSelectionDependentAction("RemoveBlockComment", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        action = new ContentAssistAction(CEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "ContentAssistTip.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)action);
        action = new AddIncludeOnSelectionAction((ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.add.include");
        this.setAction("AddIncludeOnSelection", (IAction)action);
        action = new OpenDeclarationsAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        this.setAction("OpenDeclarations", (IAction)action);
        action = new OpenDefinitionAction(this);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendef");
        this.setAction("OpenDefinition", (IAction)action);
        this.fShowInCViewAction = new ShowInCViewAction((ITextEditor)this);
        action = this.fShowInCViewAction;
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.opencview");
        this.setAction("ShowInCView", (IAction)action);
        action = new TextOperationAction(CEditorMessages.getResourceBundle(), "OpenOutline.", (ITextEditor)this, 101, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.outline");
        this.setAction("OpenOutline", (IAction)action);
        action = new GoToNextPreviousMemberAction(CEditorMessages.getResourceBundle(), "GotoNextMember.", (ITextEditor)this, true);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.next.member");
        this.setAction("GotoNextMember", (IAction)action);
        action = new GoToNextPreviousMemberAction(CEditorMessages.getResourceBundle(), "GotoPrevMember.", (ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.goto.prev.member");
        this.setAction("GotoPrevMember", (IAction)action);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fTextSearchGroup = new TextSearchGroup((IEditorPart)this);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.reorganize");
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.edit", "group.new");
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
        this.addAction(menu, "group.edit", "AddBlockComment");
        this.addAction(menu, "group.edit", "RemoveBlockComment");
        this.addAction(menu, "group.find", "OpenDeclarations");
        this.addAction(menu, "group.find", "OpenDefinition");
        this.addAction(menu, "group.find", "OpenTypeHierarchy");
        this.addAction(menu, "group.find", "GotoNextMember");
        this.addAction(menu, "group.find", "GotoPrevMember");
        this.addAction(menu, "group.generate", "ContentAssistProposal");
        this.addAction(menu, "group.generate", "AddIncludeOnSelection");
        this.addAction(menu, "group.generate", "Format");
        this.addAction(menu, "group.generate", "ShowInCView");
        this.fSelectionSearchGroup.fillContextMenu(menu);
        this.fTextSearchGroup.fillContextMenu(menu);
    }

    public static void setOutlinePageInput(CContentOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
            page.setInput((ITranslationUnit)manager.getWorkingCopy(input));
        }
    }

    boolean isFoldingEnabled() {
        return CUIPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.fInformationPresenter.setDocumentPartitioning("___c_partitioning");
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = CUIPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.cdt.ui.editor_view");
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
    }

    public void gotoMarker(IMarker marker) {
        this.fLastMarkerTarget = marker;
        if (!this.fIsUpdatingAnnotationViews) {
            super.gotoMarker(marker);
        }
    }

    public Annotation gotoAnnotation(boolean forward) {
        Annotation annotation = null;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        annotation = this.getNextAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(CEditorMessages.getString("GotoMatchingBracket.error.invalidSelection"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (CEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(CEditorMessages.getString("GotoMatchingBracket.error.noMatchingBracket"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(CEditorMessages.getString("GotoMatchingBracket.error.bracketOutsideSelectedElement"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        Preferences preferences = EditorsUI.getPluginPreferences();
        AnnotationPreference preference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && preferences.getBoolean(key);
    }

    private Annotation getNextAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        CAnnotationIterator e = new CAnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a instanceof ICAnnotation && ((ICAnnotation)a).hasOverlay() || !this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length || p.length - 1 == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            try {
                this.fIsUpdatingAnnotationViews = true;
                this.updateAnnotationViews(annotation);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fIsUpdatingAnnotationViews = false;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.fIsUpdatingAnnotationViews = false;
            }
            if (annotation instanceof ICAnnotation && ((ICAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    private void updateAnnotationViews(Annotation annotation) {
        block13: {
            Iterator e;
            IMarker marker = null;
            if (annotation instanceof MarkerAnnotation) {
                marker = ((MarkerAnnotation)annotation).getMarker();
            } else if (annotation instanceof ICAnnotation && (e = ((ICAnnotation)annotation).getOverlaidIterator()) != null) {
                while (e.hasNext()) {
                    Object o = e.next();
                    if (!(o instanceof MarkerAnnotation)) continue;
                    marker = ((MarkerAnnotation)o).getMarker();
                    break;
                }
            }
            if (marker != null && !marker.equals((Object)this.fLastMarkerTarget)) {
                try {
                    boolean isProblem = marker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
                    IWorkbenchPage page = this.getSite().getPage();
                    IViewPart view = page.findView(isProblem ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList");
                    if (view == null) break block13;
                    Class<?> clazz = view.getClass();
                    Class[] classArray = new Class[2];
                    Class<?> clazz2 = class$3;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$3 = Class.forName("org.eclipse.jface.viewers.IStructuredSelection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    classArray[1] = Boolean.TYPE;
                    Method method = clazz.getMethod("setSelection", classArray);
                    method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                }
                catch (CoreException coreException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        CAnnotationIterator e = new CAnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), null);
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void configureTabConverter() {
        if (this.fTabConverter != null) {
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof CDocumentProvider) {
                CDocumentProvider prov = (CDocumentProvider)provider;
                this.fTabConverter.setLineTracker(prov.createLineTracker(this.getEditorInput()));
            } else {
                this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            }
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            CSourceViewer asv = (CSourceViewer)this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(configuration.getTabWidth((ISourceViewer)asv));
            asv.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            CSourceViewer asv = (CSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(SPACES_FOR_TABS);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        IProject p;
        IWorkingCopyManager mgr = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy unit = mgr.getWorkingCopy(this.getEditorInput());
        String fileType = LANGUAGE_CPP;
        if (unit != null && !CoreModel.hasCCNature((IProject)(p = unit.getCProject().getProject()))) {
            fileType = unit.isCXXLanguage() ? LANGUAGE_CPP : LANGUAGE_C;
        }
        this.fAnnotationAccess = this.createAnnotationAccess();
        ISharedTextColors sharedColors = CUIPlugin.getDefault().getSharedTextColors();
        this.fOverviewRuler = this.createOverviewRuler(sharedColors);
        CSourceViewer sourceViewer = new CSourceViewer(this, parent, ruler, styles, this.fOverviewRuler, this.isOverviewRulerVisible(), fileType);
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)sourceViewer, this.fOverviewRuler, this.fAnnotationAccess, sharedColors);
        this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        this.fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        this.fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        CUIHelp.setHelp(this, sourceViewer.getTextWidget(), "org.eclipse.cdt.ui.editor_view");
        return sourceViewer;
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.cdt.ui.cEditorScope"});
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (configuration instanceof CSourceViewerConfiguration) {
            return ((CSourceViewerConfiguration)configuration).affectsBehavior(event);
        }
        return false;
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            projectionViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        projectionViewer.setRedraw(true);
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = CEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return CEditor.isBracket(document.getChar(offset - 1)) && CEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void reconciled(boolean somethingHasChanged) {
    }

    public CSourceViewer getCSourceViewer() {
        ISourceViewer viewer = this.getSourceViewer();
        CSourceViewer cViewer = null;
        if (viewer instanceof CSourceViewer) {
            cViewer = (CSourceViewer)viewer;
        }
        return cViewer;
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parentPrefPageIds = super.collectContextMenuPreferencePages();
        String[] prefPageIds = new String[parentPrefPageIds.length + 4];
        int nIds = 0;
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CEditorPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeAssistPreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.TemplatePreferencePage";
        prefPageIds[nIds++] = "org.eclipse.cdt.ui.preferences.CodeFormatterPreferencePage";
        System.arraycopy(parentPrefPageIds, 0, prefPageIds, nIds, parentPrefPageIds.length);
        return prefPageIds;
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)CEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            CEditor.this.selectionChanged();
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)CEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = CEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            CEditor.this.fInformationPresenter.setOffset(offset);
            CEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            CEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"___c_partitioning", (int)offset, (boolean)true);
            CEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            CEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = CEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(annotationHover.getClass().getName())) {
                    controlCreator = new IInformationControlCreator(this){
                        final /* synthetic */ InformationDispatchAction this$1;
                        {
                            this.this$1 = informationDispatchAction;
                        }

                        public IInformationControl createInformationControl(Shell shell) {
                            int shellStyle = 0x14 | InformationDispatchAction.access$0(this.this$1).getOrientation();
                            int style = 768;
                            return new SourceViewerInformationControl(shell, shellStyle, style);
                        }
                    };
                } else if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                CEditor.this.fInformationPresenter.setOffset(offset);
                CEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                CEditor.this.fInformationPresenter.setMargins(4, 0);
                CEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                CEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        static /* synthetic */ CEditor access$0(InformationDispatchAction informationDispatchAction) {
            return informationDispatchAction.CEditor.this;
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }

    static class TabConverter
    implements ITextConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }
}

