/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.jobs;

import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.jobs.SCJobsUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class BuildOutputReaderJob
extends Job {
    private static final String JOB_NAME = "Build Output Reader";
    private IResource resource;
    private IScannerConfigBuilderInfo2 buildInfo;

    public BuildOutputReaderJob(IProject project, IScannerConfigBuilderInfo2 buildInfo) {
        super(JOB_NAME);
        this.resource = project;
        this.buildInfo = buildInfo;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IProject project = this.resource.getProject();
        monitor.beginTask(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder"), 100);
        monitor.subTask(String.valueOf(MakeMessages.getString("ScannerConfigBuilder.Invoking_Builder")) + project.getName());
        boolean rc = SCJobsUtil.readBuildOutputFile(project, this.buildInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
        if (rc |= SCJobsUtil.getProviderScannerInfo(project, this.buildInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 20))) {
            rc = SCJobsUtil.updateScannerConfiguration(project, this.buildInfo, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        monitor.done();
        return rc ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }
}

