/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;

public class OpenDefinitionAction
extends SelectionParseAction {
    public static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    ITextSelection selNode;

    public OpenDefinitionAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.getString("OpenDefinition.label"));
        this.setToolTipText(CEditorMessages.getString("OpenDefinition.tooltip"));
        this.setDescription(CEditorMessages.getString("OpenDefinition.description"));
    }

    public void run() {
        this.selNode = this.getSelectedStringFromEditor();
        if (this.selNode != null) {
            new Runner().schedule();
        }
    }

    private class Runner
    extends Job {
        Runner() {
            super(CEditorMessages.getString("OpenDeclarations.label"));
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                int selectionStart = OpenDefinitionAction.this.selNode.getOffset();
                int selectionLength = OpenDefinitionAction.this.selNode.getLength();
                IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(OpenDefinitionAction.this.fEditor.getEditorInput());
                if (workingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                IPDOM pdom = CCorePlugin.getPDOMManager().getPDOM(workingCopy.getCProject());
                try {
                    try {
                        IASTFileLocation fileloc;
                        IASTName[] declNames;
                        IASTName searchName;
                        IBinding binding;
                        pdom.acquireReadLock();
                        IASTTranslationUnit ast = workingCopy.getLanguage().getASTTranslationUnit((ITranslationUnit)workingCopy, 3);
                        IASTName[] selectedNames = workingCopy.getLanguage().getSelectedNames(ast, selectionStart, selectionLength);
                        if (selectedNames.length > 0 && selectedNames[0] != null && (binding = (searchName = selectedNames[0]).resolveBinding()) != null && (declNames = ast.getDefinitions(binding)).length > 0 && (fileloc = declNames[0].getFileLocation()) != null) {
                            Path path = new Path(fileloc.getFileName());
                            int offset = fileloc.getNodeOffset();
                            int length = fileloc.getNodeLength();
                            Display.getDefault().asyncExec(new Runnable(this, (IPath)path, offset, length){
                                final /* synthetic */ Runner this$1;
                                private final /* synthetic */ IPath val$path;
                                private final /* synthetic */ int val$offset;
                                private final /* synthetic */ int val$length;
                                {
                                    this.this$1 = runner;
                                    this.val$path = iPath;
                                    this.val$offset = n;
                                    this.val$length = n2;
                                }

                                public void run() {
                                    try {
                                        Runner.access$0(this.this$1).open(this.val$path, this.val$offset, this.val$length);
                                    }
                                    catch (CoreException e) {
                                        CUIPlugin.getDefault().log(e);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    pdom.releaseReadLock();
                    throw throwable;
                }
                {
                    Object var15_18 = null;
                }
                pdom.releaseReadLock();
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ OpenDefinitionAction access$0(Runner runner) {
            return runner.OpenDefinitionAction.this;
        }
    }
}

