/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionParseAction
extends Action {
    private static final String OPERATOR = "operator";
    protected static final String CSEARCH_OPERATION_NO_NAMES_SELECTED_MESSAGE = "CSearchOperation.noNamesSelected.message";
    protected static final String CSEARCH_OPERATION_OPERATION_UNAVAILABLE_MESSAGE = "CSearchOperation.operationUnavailable.message";
    protected static final String CSEARCH_OPERATION_NO_DEFINITION_MESSAGE = "CSearchOperation.noDefinitionFound.message";
    protected static final String CSEARCH_OPERATION_NO_DECLARATION_MESSAGE = "CSearchOperation.noDeclarationFound.message";
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public SelectionParseAction() {
    }

    public SelectionParseAction(CEditor editor) {
        this.fEditor = editor;
        this.fSite = editor.getSite();
    }

    public SelectionParseAction(IWorkbenchSite site) {
        this.fSite = site;
    }

    protected IParser setupParser(IFile resourceFile) {
        IWorkingCopy[] workingCopies;
        IScannerInfo buildScanInfo;
        IProject currentProject = resourceFile.getProject();
        ScannerInfo scanInfo = new ScannerInfo();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(currentProject);
        if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)resourceFile)) != null) {
            scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
        }
        ParserLanguage language = CoreModel.hasCCNature((IProject)currentProject) ? ParserLanguage.CPP : ParserLanguage.C;
        IWorkingCopy workingCopy = null;
        if (this.fEditor.isDirty() && (workingCopies = CUIPlugin.getSharedWorkingCopies()) != null) {
            int i = 0;
            while (i < workingCopies.length) {
                if (workingCopies[i].getUnderlyingResource().equals((Object)resourceFile)) {
                    workingCopy = workingCopies[i];
                    break;
                }
                ++i;
            }
        }
        IParser parser = null;
        CodeReader reader = null;
        try {
            reader = workingCopy == null ? new CodeReader(resourceFile.getLocation().toOSString(), resourceFile.getCharset()) : new CodeReader(resourceFile.getLocation().toOSString(), workingCopy.getContents());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (ISourceElementRequestor)new NullSourceElementRequestor(), (IParserLogService)ParserUtil.getScannerLogService(), null), (ISourceElementRequestor)new NullSourceElementRequestor(), (ParserMode)ParserMode.SELECTION_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
        }
        catch (ParserFactoryError parserFactoryError) {}
        return parser;
    }

    protected void operationNotAvailable(final String message) {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IStatusLineManager statusManager = null;
                if (SelectionParseAction.this.fSite instanceof IViewSite) {
                    statusManager = ((IViewSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                } else if (SelectionParseAction.this.fSite instanceof IEditorSite) {
                    statusManager = ((IEditorSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                }
                if (statusManager != null) {
                    statusManager.setErrorMessage(CSearchMessages.getString(message));
                }
            }
        });
    }

    protected void clearStatusLine() {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IStatusLineManager statusManager = null;
                if (SelectionParseAction.this.fSite instanceof IViewSite) {
                    statusManager = ((IViewSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                } else if (SelectionParseAction.this.fSite instanceof IEditorSite) {
                    statusManager = ((IEditorSite)SelectionParseAction.this.fSite).getActionBars().getStatusLineManager();
                }
                if (statusManager != null) {
                    statusManager.setErrorMessage("");
                }
            }
        });
    }

    public ITextSelection getSelection(int fPos) {
        IDocument doc;
        IDocumentProvider prov = this.fEditor != null ? this.fEditor.getDocumentProvider() : null;
        IDocument iDocument = doc = prov != null ? prov.getDocument((Object)this.fEditor.getEditorInput()) : null;
        if (doc == null) {
            return null;
        }
        int pos = fPos;
        int fStartPos = 0;
        int fEndPos = 0;
        int nonJavaStart = -1;
        int nonJavaEnd = -1;
        String selectedWord = null;
        try {
            char c;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (nonJavaStart == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaStart = pos + 1;
                }
                if (Character.isWhitespace(c)) break;
                --pos;
            }
            fStartPos = pos + 1;
            pos = fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (nonJavaEnd == -1 && !Character.isJavaIdentifierPart(c)) {
                    nonJavaEnd = pos;
                }
                if (Character.isWhitespace(c)) break;
                ++pos;
            }
            fEndPos = pos;
            selectedWord = doc.get(fStartPos, fEndPos - fStartPos);
        }
        catch (BadLocationException badLocationException) {}
        boolean selectedOperator = false;
        if (selectedWord != null && selectedWord.indexOf(OPERATOR) >= 0 && fPos >= fStartPos + selectedWord.indexOf(OPERATOR) && fPos < fStartPos + selectedWord.indexOf(OPERATOR) + OPERATOR.length()) {
            selectedOperator = true;
        }
        if (selectedOperator && this.fEditor.getEditorInput() instanceof IFileEditorInput && CoreModel.hasCCNature((IProject)((IFileEditorInput)this.fEditor.getEditorInput()).getFile().getProject())) {
            int actualStart = fStartPos + selectedWord.indexOf(OPERATOR);
            int actualEnd = this.getOperatorActualEnd(doc, fStartPos + selectedWord.indexOf(OPERATOR) + OPERATOR.length());
            actualEnd = actualEnd > 0 ? actualEnd : fEndPos;
            return new TextSelection(doc, actualStart, actualEnd - actualStart);
        }
        if (selectedWord != null && selectedWord.indexOf(126) >= 0 && fPos - 2 >= fStartPos + selectedWord.lastIndexOf(new String(Keywords.cpCOLONCOLON))) {
            int tildePos = selectedWord.indexOf(126);
            int actualStart = fStartPos + tildePos;
            int length = 0;
            char[] lastSegment = selectedWord.substring(tildePos).toCharArray();
            int i = 1;
            while (i < lastSegment.length) {
                char temp = lastSegment[i];
                if (!Character.isJavaIdentifierPart(temp)) {
                    length = i;
                    break;
                }
                ++i;
            }
            if (fPos >= actualStart + length) {
                return new TextSelection(doc, nonJavaStart, length);
            }
            return new TextSelection(doc, actualStart, length);
        }
        return new TextSelection(doc, nonJavaStart, nonJavaEnd - nonJavaStart);
    }

    private int getOperatorActualEnd(IDocument doc, int index) {
        int actualEnd = -1;
        boolean multiComment = false;
        boolean singleComment = false;
        int possibleEnd = -1;
        while (actualEnd == -1) {
            try {
                char c1 = doc.getChar(index);
                char c2 = doc.getChar(index + 1);
                if (singleComment) {
                    char c3 = doc.getChar(index - 1);
                    if (c3 != '\\' && (c1 == '\n' || c1 == '\r' && c2 == '\n')) {
                        singleComment = false;
                    }
                    ++index;
                    continue;
                }
                if (multiComment) {
                    if (c1 == '*' && c2 == '/') {
                        multiComment = false;
                        index += 2;
                        continue;
                    }
                    ++index;
                    continue;
                }
                block1 : switch (c1) {
                    case '+': {
                        switch (c2) {
                            case '+': 
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '-': {
                        switch (c2) {
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                            case '-': {
                                switch (doc.getChar(index + 2)) {
                                    case '>': {
                                        switch (doc.getChar(index + 3)) {
                                            case '*': {
                                                actualEnd = index + 4;
                                                break block1;
                                            }
                                        }
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        break;
                    }
                    case '|': {
                        switch (c2) {
                            case '=': 
                            case '|': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '&': {
                        switch (c2) {
                            case '&': 
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '/': {
                        switch (c2) {
                            case '/': {
                                singleComment = true;
                                index += 2;
                                break block1;
                            }
                            case '*': {
                                multiComment = true;
                                index += 2;
                                break block1;
                            }
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '!': 
                    case '%': 
                    case '*': 
                    case '=': 
                    case '^': {
                        switch (c2) {
                            case '=': {
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index + 1;
                        break;
                    }
                    case '(': {
                        if (possibleEnd > 0) {
                            actualEnd = possibleEnd;
                        }
                        ++index;
                        break;
                    }
                    case ')': 
                    case ',': 
                    case ']': 
                    case '~': {
                        actualEnd = index + 1;
                        break;
                    }
                    case '<': {
                        switch (c2) {
                            case '<': 
                            case '=': {
                                switch (doc.getChar(index + 2)) {
                                    case '=': {
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index;
                        break;
                    }
                    case '>': {
                        switch (c2) {
                            case '=': 
                            case '>': {
                                switch (doc.getChar(index + 2)) {
                                    case '=': {
                                        actualEnd = index + 3;
                                        break block1;
                                    }
                                }
                                actualEnd = index + 2;
                                break block1;
                            }
                        }
                        actualEnd = index;
                        break;
                    }
                    case 'n': {
                        while (doc.getChar(++index) != 'w') {
                        }
                        possibleEnd = ++index;
                        break;
                    }
                    case 'd': {
                        while (doc.getChar(++index) != 't' && doc.getChar(index + 1) != 'e') {
                        }
                        possibleEnd = index += 2;
                        break;
                    }
                    default: {
                        ++index;
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return actualEnd;
    }

    protected ITextSelection getSelection(ITextSelection textSelection) {
        if (textSelection == null) {
            return null;
        }
        if (textSelection.getLength() == 0) {
            return this.getSelection(textSelection.getOffset());
        }
        return textSelection;
    }

    protected ISelection getSelection() {
        ISelection sel = null;
        if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            sel = this.fSite.getSelectionProvider().getSelection();
        }
        return sel;
    }

    protected ITextSelection getSelectedStringFromEditor() {
        ISelection selection = this.getSelection();
        if (selection == null || !(selection instanceof ITextSelection)) {
            return null;
        }
        return this.getSelection((ITextSelection)selection);
    }

    protected void open(IPath path, int offset, int length) throws CoreException {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
        if (files.length > 0) {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)files[0]);
            try {
                IMarker marker = files[0].createMarker("org.eclipse.search.searchmarker");
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                marker.delete();
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
        } else {
            ExternalEditorInput input = new ExternalEditorInput((IStorage)new FileStorage(path));
            IEditorPart editor = CUIPlugin.getActivePage().openEditor((IEditorInput)input, "org.eclipse.cdt.ui.editor.ExternalSearchEditor");
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(offset, length);
            }
        }
    }

    public void update() {
        this.setEnabled(this.getSelectedStringFromEditor() != null);
    }
}

