/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CBreakpointPreferenceStore
implements IPreferenceStore {
    protected static final String ENABLED = "ENABLED";
    protected static final String CONDITION = "CONDITION";
    protected static final String IGNORE_COUNT = "IGNORE_COUNT";
    protected HashMap fProperties = new HashMap(3);
    private boolean fIsDirty = false;
    private ListenerList fListeners = new ListenerList();

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public boolean contains(String name) {
        return this.fProperties.containsKey(name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.fListeners.getListeners();
        if (!(listeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                l.propertyChange(pe);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        Object b = this.fProperties.get(name);
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return null;
    }

    public double getDouble(String name) {
        return 0.0;
    }

    public float getFloat(String name) {
        return 0.0f;
    }

    public int getInt(String name) {
        Object i = this.fProperties.get(name);
        if (i instanceof Integer) {
            return (Integer)i;
        }
        return 1;
    }

    public long getLong(String name) {
        return 0L;
    }

    public String getString(String name) {
        Object str = this.fProperties.get(name);
        if (str instanceof String) {
            return (String)str;
        }
        return null;
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        return this.fIsDirty;
    }

    public void putValue(String name, String newValue) {
        Object oldValue = this.fProperties.get(name);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.fProperties.put(name, newValue);
            this.setDirty(true);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
    }

    public void setValue(String name, double value) {
    }

    public void setValue(String name, float value) {
    }

    public void setValue(String name, int newValue) {
        int oldValue = this.getInt(name);
        if (oldValue != newValue) {
            this.fProperties.put(name, new Integer(newValue));
            this.setDirty(true);
            this.firePropertyChangeEvent(name, new Integer(oldValue), new Integer(newValue));
        }
    }

    public void setValue(String name, long value) {
    }

    public void setValue(String name, String newValue) {
        Object oldValue = this.fProperties.get(name);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.fProperties.put(name, newValue);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, newValue);
        }
    }

    public void setValue(String name, boolean newValue) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != newValue) {
            this.fProperties.put(name, newValue);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, newValue);
        }
    }

    protected void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }
}

