/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.command.MICommand;
import org.eclipse.cdt.debug.mi.core.output.MIBreakInsertInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;

public class MIBreakInsert
extends MICommand {
    public MIBreakInsert(String miVersion, String func) {
        this(miVersion, false, false, null, 0, func, 0);
    }

    public MIBreakInsert(String miVersion, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String line, int tid) {
        super(miVersion, "-break-insert");
        int i = 0;
        if (isTemporary) {
            ++i;
        }
        if (isHardware) {
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            i += 2;
        }
        if (ignoreCount > 0) {
            i += 2;
        }
        if (tid > 0) {
            i += 2;
        }
        String[] opts = new String[i];
        i = 0;
        if (isTemporary) {
            opts[i] = "-t";
            ++i;
        }
        if (isHardware) {
            opts[i] = "-h";
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            opts[i] = "-c";
            opts[++i] = condition;
            ++i;
        }
        if (ignoreCount > 0) {
            opts[i] = "-i";
            opts[++i] = Integer.toString(ignoreCount);
            ++i;
        }
        if (tid > 0) {
            opts[i] = "-p";
            opts[++i] = Integer.toString(tid);
        }
        if (opts.length > 0) {
            this.setOptions(opts);
        }
        this.setParameters(new String[]{line});
    }

    public MIBreakInsertInfo getMIBreakInsertInfo() throws MIException {
        return (MIBreakInsertInfo)this.getMIInfo();
    }

    public MIInfo getMIInfo() throws MIException {
        MIBreakInsertInfo info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MIBreakInsertInfo(out)).isError()) {
            this.throwMIException(info, out);
        }
        return info;
    }
}

