/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.EclipseVariablesMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.EnvironmentMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.UserDefinedMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.ui.EnvironmentSetBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.NewBuildMacroDialog;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroStatus;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPreferencePage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MacrosBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "MacrosBlock";
    private static final String LABEL = "MacrosBlock.label";
    private static final String USER_MACROS = "MacrosBlock.label.user.macros";
    private static final String SYSTEM_MACROS = "MacrosBlock.label.system.macros";
    private static final String HEADER = "MacrosBlock.label.header";
    private static final String HEADER_NAME = "MacrosBlock.label.header.name";
    private static final String HEADER_TYPE = "MacrosBlock.label.header.type";
    private static final String HEADER_VALUE = "MacrosBlock.label.header.value";
    private static final String TYPE = "MacrosBlock.label.type";
    private static final String TYPE_TEXT = "MacrosBlock.label.type.text";
    private static final String TYPE_TEXT_LIST = "MacrosBlock.label.type.text.list";
    private static final String TYPE_PATH_FILE = "MacrosBlock.label.type.path.file";
    private static final String TYPE_PATH_FILE_LIST = "MacrosBlock.label.type.path.file.list";
    private static final String TYPE_PATH_DIR = "MacrosBlock.label.type.path.dir";
    private static final String TYPE_PATH_DIR_LIST = "MacrosBlock.label.type.path.dir.list";
    private static final String TYPE_PATH_ANY = "MacrosBlock.label.type.path.any";
    private static final String TYPE_PATH_ANY_LIST = "MacrosBlock.label.type.path.any.list";
    private static final String BUTTON = "MacrosBlock.label.button";
    private static final String BUTTON_NEW = "MacrosBlock.label.button.new";
    private static final String BUTTON_EDIT = "MacrosBlock.label.button.edit";
    private static final String BUTTON_DELETE = "MacrosBlock.label.button.delete";
    private static final String BUTTON_CHECK_SHOW_PARENT = "MacrosBlock.label.button.check.chow.parent";
    private static final String DELETE_CONFIRM_TITLE = "MacrosBlock.label.delete.confirm.title";
    private static final String DELETE_CONFIRM_MESSAGE = "MacrosBlock.label.delete.confirm.message";
    private static final String DELETE_ALL_CONFIRM_TITLE = "MacrosBlock.label.delete.all.confirm.title";
    private static final String DELETE_ALL_CONFIRM_MESSAGE = "MacrosBlock.label.delete.all.confirm.message";
    private static final String VALUE = "MacrosBlock.label.value";
    private static final String VALUE_ECLIPSE_DYNAMIC = "MacrosBlock.label.value.eclipse.dynamic";
    private static final String VALUE_DELIMITER = " || ";
    private static final String[] fHiddenMacros = new String[]{"CWD", "PWD"};
    private static final int IDX_BUTTON_NEW = 0;
    private static final int IDX_BUTTON_EDIT = 1;
    private static final int IDX_BUTTON_DELETE = 2;
    private HashSet fDeletedUserMacroNames;
    private Map fAddedUserMacros;
    private boolean fDeleteAll = false;
    private boolean fModified = false;
    private boolean fShowParentViewCheckBox = true;
    private boolean fIsEditable = true;
    private static final Object fInexistentContext = new Object();
    private int fContextType = 0;
    private Object fContextData = fInexistentContext;
    private boolean fShowParentMacros = false;
    private IMacroContextInfo fSystemContextInfo;
    private IMacroContextInfo fCurrentContextInfo;
    private IMacroContextInfo fParentContextInfo;
    private boolean fUseDefaultParentContextInfo = true;
    private Set fIncorrectlyDefinedMacrosNames = new HashSet();
    private UserDefinedMacroSupplier fUserSupplier;
    private TableViewer fEditableTable;
    private TableViewer fNonEditableTable;
    private Button fShowParentButton;
    private Composite fParent;
    private Label fStatusLabel;
    private Button fNewButton;
    private Button fEditButton;
    private Button fDeleteButton;
    private static final String[] fEditableTableColumnProps = new String[]{"editable name", "editable type", "editable value"};
    private static final String[] fNonEditableTableColumnProps = new String[]{"noneditable name", "noneditable type", "noneditable value"};
    private static final String[] fTableColumnNames = new String[]{ManagedBuilderUIMessages.getResourceString("MacrosBlock.label.header.name"), ManagedBuilderUIMessages.getResourceString("MacrosBlock.label.header.type"), ManagedBuilderUIMessages.getResourceString("MacrosBlock.label.header.value")};
    private static final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(100), new ColumnPixelData(100), new ColumnPixelData(250)};

    public MacrosBlock(ICOptionContainer parent, String title, boolean editable, boolean showParentViewCheckBox) {
        super(title);
        super.setContainer(parent);
        this.fShowParentViewCheckBox = showParentViewCheckBox;
        this.fIsEditable = editable;
    }

    private Map getUserMacrosMap() {
        HashMap<String, IBuildMacro> map = new HashMap<String, IBuildMacro>();
        if (this.fUserSupplier != null && !this.fDeleteAll) {
            IBuildMacro[] macros = this.fUserSupplier.getMacros(this.fContextType, this.fContextData);
            if (macros != null) {
                int i = 0;
                while (i < macros.length) {
                    String name = macros[i].getName();
                    map.put(name, macros[i]);
                    ++i;
                }
            }
            Iterator<Object> iter = this.getDeletedUserMacroNames().iterator();
            while (iter.hasNext()) {
                map.remove((String)iter.next());
            }
            iter = this.getAddedUserMacros().values().iterator();
            while (iter.hasNext()) {
                IBuildMacro macro = (IBuildMacro)iter.next();
                String name = macro.getName();
                map.put(name, macro);
            }
        }
        return map;
    }

    private IBuildMacro[] getUserMacros() {
        if (this.storeDirectly() && this.fUserSupplier != null) {
            return this.fUserSupplier.getMacros(this.fContextType, this.fContextData);
        }
        Collection macros = this.getUserMacrosMap().values();
        return macros.toArray(new IBuildMacro[macros.size()]);
    }

    private HashSet getDeletedUserMacroNames() {
        if (this.fDeletedUserMacroNames == null) {
            this.fDeletedUserMacroNames = new HashSet();
        }
        return this.fDeletedUserMacroNames;
    }

    private Map getAddedUserMacros() {
        if (this.fAddedUserMacros == null) {
            this.fAddedUserMacros = new HashMap();
        }
        return this.fAddedUserMacros;
    }

    private void addUserMacro(IBuildMacro newMacro) {
        String name = newMacro.getName();
        if (!this.canCreate(name)) {
            return;
        }
        if (this.storeDirectly() && this.fUserSupplier != null) {
            this.fUserSupplier.createMacro(newMacro, this.fContextType, this.fContextData);
        } else {
            this.fDeleteAll = false;
            this.getDeletedUserMacroNames().remove(name);
            this.getAddedUserMacros().put(name, newMacro);
        }
        this.fModified = true;
    }

    private void deleteUserMacro(String name) {
        if (this.storeDirectly() && this.fUserSupplier != null) {
            this.fUserSupplier.deleteMacro(name, this.fContextType, this.fContextData);
        } else {
            this.fDeleteAll = false;
            this.getAddedUserMacros().remove(name);
            this.getDeletedUserMacroNames().add(name);
        }
        this.fModified = true;
    }

    private void deleteAllUserMacros() {
        if (this.storeDirectly() && this.fUserSupplier != null) {
            this.fUserSupplier.deleteAll(this.fContextType, this.fContextData);
        } else {
            this.fDeleteAll = true;
            this.getDeletedUserMacroNames().clear();
            this.getAddedUserMacros().clear();
        }
        this.fModified = true;
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified(boolean modified) {
        this.fModified = modified;
    }

    private IBuildMacro getUserMacro(String name) {
        if (this.storeDirectly() && this.fUserSupplier != null) {
            return this.fUserSupplier.getMacro(name, this.fContextType, this.fContextData);
        }
        Map macros = this.getUserMacrosMap();
        if (macros == null) {
            return null;
        }
        return (IBuildMacro)macros.get(name);
    }

    private void applyUserMacros() {
        if (this.fUserSupplier != null) {
            if (this.storeDirectly()) {
                if (this.getContainer() instanceof AbstractBuildPropertyPage && this.fContextType == 3 && this.fContextData instanceof IConfiguration) {
                    AbstractBuildPropertyPage page = (AbstractBuildPropertyPage)this.getContainer();
                    IConfiguration realCfg = page.getRealConfig((IConfiguration)this.fContextData);
                    IBuildMacro[] macros = this.getUserMacros();
                    UserDefinedMacroSupplier supplier = BuildMacroProvider.fUserDefinedMacroSupplier;
                    supplier.setMacros(macros, 3, (Object)realCfg);
                }
            } else if (this.fDeleteAll) {
                this.fUserSupplier.deleteAll(this.fContextType, this.fContextData);
            } else {
                Iterator<Object> iter = this.getDeletedUserMacroNames().iterator();
                while (iter.hasNext()) {
                    this.fUserSupplier.deleteMacro((String)iter.next(), this.fContextType, this.fContextData);
                }
                iter = this.getAddedUserMacros().values().iterator();
                while (iter.hasNext()) {
                    IBuildMacro macro = (IBuildMacro)iter.next();
                    this.fUserSupplier.createMacro(macro, this.fContextType, this.fContextData);
                }
                this.getDeletedUserMacroNames().clear();
                this.getAddedUserMacros().clear();
            }
        }
    }

    private void storeUserMacros() {
        this.applyUserMacros();
        if (this.fUserSupplier != null) {
            this.fUserSupplier.serialize(false);
        }
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.fEditButton.setEnabled(size == 1);
        this.fDeleteButton.setEnabled(size > 0);
    }

    private void handleCustomButtonPressed(int index) {
        switch (index) {
            case 0: {
                IBuildMacro macro;
                NewBuildMacroDialog dlg = new NewBuildMacroDialog(this.fParent.getShell(), this, null);
                if (dlg.open() != 0 || (macro = dlg.getDefinedMacro()) == null) break;
                this.addUserMacro(macro);
                this.updateValues();
                break;
            }
            case 1: {
                IBuildMacro macro;
                NewBuildMacroDialog dlg;
                IBuildMacro[] macros = this.getSelectedUserMacros();
                if (macros == null || macros.length != 1 || (dlg = new NewBuildMacroDialog(this.fParent.getShell(), this, this.getUserMacro(macros[0].getName()))).open() != 0 || (macro = dlg.getDefinedMacro()) == null) break;
                this.addUserMacro(macro);
                this.updateValues();
                break;
            }
            case 2: {
                IBuildMacro[] macros = this.getSelectedUserMacros();
                if (macros == null || macros.length <= 0 || !MessageDialog.openQuestion((Shell)this.fParent.getShell(), (String)ManagedBuilderUIMessages.getResourceString(DELETE_CONFIRM_TITLE), (String)ManagedBuilderUIMessages.getResourceString(DELETE_CONFIRM_MESSAGE))) break;
                int i = 0;
                while (i < macros.length) {
                    this.deleteUserMacro(macros[i].getName());
                    ++i;
                }
                this.updateValues();
            }
        }
    }

    private IBuildMacro[] getSelectedUserMacros() {
        if (this.fEditableTable == null) {
            return null;
        }
        List list = ((IStructuredSelection)this.fEditableTable.getSelection()).toList();
        return list.toArray(new IBuildMacro[list.size()]);
    }

    public void setContext(int contextType, Object contextData) {
        if (contextType == this.fContextType && contextData == this.fContextData) {
            return;
        }
        this.fContextType = contextType;
        this.fContextData = contextData;
        BuildMacroProvider provider = BuildMacroProvider.getDefault();
        IBuildMacroSupplier[] suppliers = provider.getSuppliers(this.fContextType, this.fContextData);
        if (suppliers != null && suppliers.length != 0 && suppliers[0] instanceof UserDefinedMacroSupplier) {
            this.fUserSupplier = (UserDefinedMacroSupplier)suppliers[0];
        }
        this.fSystemContextInfo = new SystemContextInfo(this.fContextType, this.fContextData);
        this.fCurrentContextInfo = new CurrentContextInfo(this.fContextType, this.fContextData);
    }

    public void setParentContextInfo(IMacroContextInfo info) {
        this.fParentContextInfo = info;
        this.fUseDefaultParentContextInfo = false;
    }

    public void resetDefaultParentContextInfo() {
        this.fUseDefaultParentContextInfo = true;
        this.fParentContextInfo = null;
    }

    public IMacroContextInfo getContextInfo() {
        return this.fCurrentContextInfo;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.fUserSupplier == null) {
            return;
        }
        this.storeUserMacros();
        this.setModified(false);
    }

    public void performDefaults() {
        if (MessageDialog.openQuestion((Shell)this.fParent.getShell(), (String)ManagedBuilderUIMessages.getResourceString(DELETE_ALL_CONFIRM_TITLE), (String)ManagedBuilderUIMessages.getResourceString(DELETE_ALL_CONFIRM_MESSAGE))) {
            this.deleteAllUserMacros();
            this.updateValues();
        }
    }

    public void updateValues() {
        if (this.fCurrentContextInfo == null) {
            return;
        }
        try {
            MacroResolver.checkIntegrity((IMacroContextInfo)this.fCurrentContextInfo, (IMacroSubstitutor)new MacroUIMacroSubstitutor(this.fCurrentContextInfo, null, " "));
            this.updateState(null);
        }
        catch (BuildMacroException e) {
            this.updateState(e);
        }
        this.updateUserMacros();
        this.updateSystemMacros();
    }

    private void updateState(BuildMacroException e) {
        this.fIncorrectlyDefinedMacrosNames.clear();
        if (e != null) {
            this.fStatusLabel.setText(e.getMessage());
            this.fStatusLabel.setVisible(true);
            IBuildMacroStatus[] statuses = e.getMacroStatuses();
            int i = 0;
            while (i < statuses.length) {
                String name = statuses[i].getMacroName();
                if (name != null) {
                    this.fIncorrectlyDefinedMacrosNames.add(name);
                }
                ++i;
            }
        } else {
            this.fStatusLabel.setVisible(false);
        }
    }

    private void updateUserMacros() {
        if (this.fEditableTable == null || this.fContextType == 0) {
            return;
        }
        IBuildMacro[] macros = this.getUserMacros();
        ArrayList<IBuildMacro> list = new ArrayList<IBuildMacro>(macros.length);
        int i = 0;
        while (i < macros.length) {
            if (macros[i] != null) {
                list.add(macros[i]);
            }
            ++i;
        }
        this.fEditableTable.setInput((Object)list.toArray(new IBuildMacro[list.size()]));
    }

    private void updateSystemMacros() {
        if (this.fNonEditableTable == null || this.fContextType == 0) {
            return;
        }
        ArrayList<IBuildMacro> list = new ArrayList<IBuildMacro>();
        IBuildMacro[] macros = this.getSystemMacros(this.fShowParentMacros);
        if (macros != null && macros.length != 0) {
            int i = 0;
            while (i < macros.length) {
                if (macros[i] != null) {
                    list.add(macros[i]);
                }
                ++i;
            }
        }
        this.fNonEditableTable.setInput((Object)list.toArray(new IBuildMacro[list.size()]));
    }

    public IBuildMacro getSystemMacro(String name, boolean includeParentLevels) {
        if (name == null) {
            return null;
        }
        if (this.fSystemContextInfo == null) {
            return null;
        }
        if (!this.canDisplay(name)) {
            return null;
        }
        return BuildMacroProvider.getMacro((String)name, (IMacroContextInfo)this.fSystemContextInfo, (boolean)includeParentLevels);
    }

    public IBuildMacro[] getSystemMacros(boolean includeParentLevels) {
        IBuildMacro[] macros = BuildMacroProvider.getMacros((IMacroContextInfo)this.fSystemContextInfo, (boolean)includeParentLevels);
        if (macros == null) {
            return null;
        }
        return this.filterMacros(macros);
    }

    public void createControl(Composite parent) {
        FormData fd;
        Label nameLabel;
        this.fParent = parent;
        FormLayout layout = new FormLayout();
        Control buttonsControl = null;
        Control listControl = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        if (this.fIsEditable) {
            nameLabel = new Label(composite, 16384);
            nameLabel.setFont(composite.getFont());
            nameLabel.setText(ManagedBuilderUIMessages.getResourceString(USER_MACROS));
            fd = new FormData();
            fd.top = new FormAttachment(0, 2);
            fd.left = new FormAttachment(0, 0);
            nameLabel.setLayoutData((Object)fd);
            listControl = this.createTableControl(composite, true);
            buttonsControl = this.createButtonsControl(composite);
            fd = new FormData();
            fd.top = new FormAttachment((Control)nameLabel, 0);
            fd.right = new FormAttachment(100, 0);
            buttonsControl.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)nameLabel, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(buttonsControl, -5);
            fd.bottom = new FormAttachment(50, -15);
            listControl.setLayoutData((Object)fd);
        }
        nameLabel = new Label(composite, 16384);
        nameLabel.setFont(composite.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(SYSTEM_MACROS));
        fd = new FormData();
        fd.top = this.fIsEditable ? new FormAttachment(listControl, 2) : new FormAttachment(0, 2);
        fd.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)fd);
        this.fStatusLabel = new Label(composite, 16384);
        this.fStatusLabel.setFont(composite.getFont());
        this.fStatusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -10);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.fStatusLabel.setLayoutData((Object)fd);
        if (this.fShowParentViewCheckBox) {
            this.fShowParentButton = new Button(composite, 32);
            this.fShowParentButton.setFont(composite.getFont());
            this.fShowParentButton.setText(ManagedBuilderUIMessages.getResourceString(BUTTON_CHECK_SHOW_PARENT));
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.bottom = new FormAttachment((Control)this.fStatusLabel, -10);
            this.fShowParentButton.setLayoutData((Object)fd);
            this.fShowParentButton.setSelection(this.fShowParentMacros);
            this.fShowParentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MacrosBlock.this.fShowParentMacros = MacrosBlock.this.fShowParentButton.getSelection();
                    MacrosBlock.this.updateSystemMacros();
                }
            });
        }
        listControl = this.createTableControl(composite, false);
        fd = new FormData();
        fd.top = new FormAttachment((Control)nameLabel, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = buttonsControl != null ? new FormAttachment(buttonsControl, -5) : new FormAttachment(100, 0);
        fd.bottom = this.fShowParentButton != null ? new FormAttachment((Control)this.fShowParentButton, -2) : new FormAttachment((Control)this.fStatusLabel, -10);
        listControl.setLayoutData((Object)fd);
        this.setControl((Control)composite);
    }

    private Control createTableControl(Composite parent, boolean editable) {
        Composite listControl = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        listControl.setLayout((Layout)gl);
        TableViewer tableViewer = new TableViewer(listControl, 68354);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < fTableColumnNames.length) {
            tableLayout.addColumnData(fTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(MacrosBlock.fTableColumnLayouts[i].resizable);
            tc.setText(fTableColumnNames[i]);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        tableViewer.getControl().setLayoutData((Object)gd);
        tableViewer.setContentProvider((IContentProvider)new MacroContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new MacroLabelProvider(editable));
        tableViewer.setSorter(new ViewerSorter());
        if (editable) {
            tableViewer.setColumnProperties(fEditableTableColumnProps);
            this.fEditableTable = tableViewer;
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MacrosBlock.this.handleSelectionChanged(event);
                }
            });
            tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (!MacrosBlock.this.fEditableTable.getSelection().isEmpty()) {
                        MacrosBlock.this.handleCustomButtonPressed(1);
                    }
                }
            });
            table.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 127) {
                        MacrosBlock.this.handleCustomButtonPressed(2);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        } else {
            tableViewer.setColumnProperties(fNonEditableTableColumnProps);
            this.fNonEditableTable = tableViewer;
        }
        return listControl;
    }

    private Control createButtonsControl(Composite parent) {
        Composite buttonsControl = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 1;
        buttonsControl.setLayout((Layout)gl);
        this.fNewButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_NEW), null);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MacrosBlock.this.handleCustomButtonPressed(0);
            }
        });
        GridData gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fNewButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fNewButton);
        this.fNewButton.setLayoutData((Object)gd);
        this.fEditButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_EDIT), null);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MacrosBlock.this.handleCustomButtonPressed(1);
            }
        });
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fEditButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fEditButton);
        this.fEditButton.setLayoutData((Object)gd);
        this.fDeleteButton = this.createPushButton(buttonsControl, ManagedBuilderUIMessages.getResourceString(BUTTON_DELETE), null);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MacrosBlock.this.handleCustomButtonPressed(2);
            }
        });
        gd = new GridData(768);
        gd.heightHint = SWTUtil.getButtonHeigthHint((Button)this.fDeleteButton);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)this.fDeleteButton);
        this.fDeleteButton.setLayoutData((Object)gd);
        return buttonsControl;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public Object getContextData() {
        return this.fContextData;
    }

    public int getContextType() {
        return this.fContextType;
    }

    public void displayParentMacros(boolean display) {
        this.fShowParentMacros = display;
        if (this.fShowParentButton != null) {
            this.fShowParentButton.setSelection(this.fShowParentMacros);
        }
        this.updateSystemMacros();
    }

    protected boolean canDisplay(String name) {
        return this.canCreate(name);
    }

    public boolean canCreate(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return false;
        }
        if (fHiddenMacros != null) {
            int i = 0;
            while (i < fHiddenMacros.length) {
                if (fHiddenMacros[i].equals(EnvVarOperationProcessor.normalizeName((String)name))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected IBuildMacro[] filterMacros(IBuildMacro[] macros) {
        return MacroResolver.filterMacros((IBuildMacro[])macros, (String[])fHiddenMacros);
    }

    protected EnvironmentVariableProvider obtainEnvironmentVariableProvider() {
        EnvironmentSetBlock block;
        ICOptionContainer page;
        ICOptionContainer container = this.getContainer();
        ManagedBuildOptionBlock optionBlock = null;
        if (container instanceof BuildPropertyPage) {
            page = (BuildPropertyPage)container;
            optionBlock = page.getOptionBlock();
        } else if (container instanceof BuildPreferencePage) {
            page = (BuildPreferencePage)container;
            optionBlock = page.getOptionBlock();
        }
        if (optionBlock != null && (block = optionBlock.getEnvironmentBlock()) != null) {
            return block.getEnvironmentVariableProvider();
        }
        return null;
    }

    protected boolean storeDirectly() {
        if (this.fContextType == 3 && this.fContextData instanceof IConfiguration) {
            return ((IConfiguration)this.fContextData).isTemporary();
        }
        return false;
    }

    private class CurrentContextInfo
    extends MacroUIMacroSontextInfo {
        protected CurrentContextInfo(int contextType, Object contextData) {
            super(contextType, contextData);
        }

        public IBuildMacroSupplier[] getSuppliers(int contextType, Object contextData) {
            IBuildMacroSupplier[] suppliers = super.getSuppliers(contextType, contextData);
            if (contextType == MacrosBlock.this.fContextType && contextData == MacrosBlock.this.fContextData && MacrosBlock.this.storeDirectly()) {
                return suppliers;
            }
            if (suppliers == null || suppliers.length == 0) {
                return suppliers;
            }
            if (!(suppliers[0] instanceof UserDefinedMacroSupplier)) {
                return suppliers;
            }
            ArrayList<IBuildMacroSupplier> list = new ArrayList<IBuildMacroSupplier>(suppliers.length);
            list.add(new UIMacroSupplier());
            int i = 1;
            while (i < suppliers.length) {
                list.add(suppliers[i]);
                ++i;
            }
            return list.toArray(new IBuildMacroSupplier[list.size()]);
        }

        public IMacroContextInfo getNext() {
            if (MacrosBlock.this.fUseDefaultParentContextInfo) {
                return super.getNext();
            }
            return MacrosBlock.this.fParentContextInfo;
        }
    }

    private class MacroContentProvider
    implements IStructuredContentProvider {
        private MacroContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MacroLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        private boolean fUser;

        public MacroLabelProvider(boolean user) {
            this.fUser = user;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IBuildMacro macro = (IBuildMacro)element;
            switch (columnIndex) {
                case 0: {
                    return macro.getName();
                }
                case 1: {
                    switch (macro.getMacroValueType()) {
                        case 3: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_FILE);
                        }
                        case 4: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_FILE_LIST);
                        }
                        case 5: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_DIR);
                        }
                        case 6: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_DIR_LIST);
                        }
                        case 7: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_ANY);
                        }
                        case 8: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_PATH_ANY_LIST);
                        }
                        case 1: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_TEXT);
                        }
                        case 2: {
                            return ManagedBuilderUIMessages.getResourceString(MacrosBlock.TYPE_TEXT_LIST);
                        }
                    }
                }
                case 2: {
                    return this.getDisplayedMacroValue(macro);
                }
            }
            return "";
        }

        private String getDisplayedMacroValue(IBuildMacro macro) {
            String value = "";
            try {
                EclipseVariablesMacroSupplier.EclipseVarMacro eclipseVarMacro;
                IStringVariable var;
                value = macro instanceof EclipseVariablesMacroSupplier.EclipseVarMacro ? ((var = (eclipseVarMacro = (EclipseVariablesMacroSupplier.EclipseVarMacro)macro).getVariable()) instanceof IDynamicVariable ? ManagedBuilderUIMessages.getResourceString(MacrosBlock.VALUE_ECLIPSE_DYNAMIC) : macro.getStringValue()) : (MacroResolver.isStringListMacro((int)macro.getMacroValueType()) ? BuildMacroProvider.getDefault().convertStringListToString(macro.getStringListValue(), MacrosBlock.VALUE_DELIMITER) : macro.getStringValue());
            }
            catch (BuildMacroException buildMacroException) {}
            return value;
        }

        private Font getValueFont(IBuildMacro macro) {
            EclipseVariablesMacroSupplier.EclipseVarMacro eclipseVarMacro;
            IStringVariable var;
            Font font = null;
            if (macro instanceof EclipseVariablesMacroSupplier.EclipseVarMacro && (var = (eclipseVarMacro = (EclipseVariablesMacroSupplier.EclipseVarMacro)macro).getVariable()) instanceof IDynamicVariable) {
                font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
            }
            return font;
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Font getFont(Object element, int columnIndex) {
            IBuildMacro macro = (IBuildMacro)element;
            switch (columnIndex) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    return this.getValueFont(macro);
                }
            }
            if (!this.fUser && MacrosBlock.this.getUserMacro(macro.getName()) != null) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Color getForeground(Object element) {
            IBuildMacro macro = (IBuildMacro)element;
            boolean incorrect = false;
            String name = macro.getName();
            if (this.fUser || MacrosBlock.this.getUserMacro(name) == null) {
                incorrect = MacrosBlock.this.fIncorrectlyDefinedMacrosNames.contains(name);
            }
            if (incorrect) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class MacroUIMacroSontextInfo
    extends DefaultMacroContextInfo {
        protected MacroUIMacroSontextInfo(int contextType, Object contextData) {
            super(contextType, contextData);
        }

        protected IBuildMacroSupplier[] getSuppliers(int contextType, Object contextData) {
            IBuildMacroSupplier[] suppliers = super.getSuppliers(contextType, contextData);
            if (suppliers == null || suppliers.length == 0) {
                return null;
            }
            EnvironmentVariableProvider envProvider = MacrosBlock.this.obtainEnvironmentVariableProvider();
            if (envProvider != null) {
                int i = 0;
                while (i < suppliers.length) {
                    if (suppliers[i] instanceof EnvironmentMacroSupplier) {
                        suppliers[i] = new EnvironmentMacroSupplier(envProvider);
                        break;
                    }
                    ++i;
                }
            }
            return suppliers;
        }
    }

    private class MacroUIMacroSubstitutor
    extends DefaultMacroSubstitutor {
        public MacroUIMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
            super(contextInfo, inexistentMacroValue, listDelimiter);
        }

        public MacroUIMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter) {
            super(contextType, contextData, inexistentMacroValue, listDelimiter);
        }

        protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(String macroName) throws BuildMacroException {
            String[] names = BuildMacroProvider.fMbsMacroSupplier.getMacroNames(1);
            int i = 0;
            while (i < names.length) {
                if (macroName.equals(names[i])) {
                    return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macroName, MacroResolver.createMacroReference((String)macroName));
                }
                ++i;
            }
            names = BuildMacroProvider.fMbsMacroSupplier.getMacroNames(2);
            i = 0;
            while (i < names.length) {
                if (macroName.equals(names[i])) {
                    return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macroName, MacroResolver.createMacroReference((String)macroName));
                }
                ++i;
            }
            return super.resolveMacro(macroName);
        }

        protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
            if (macro instanceof EclipseVariablesMacroSupplier.EclipseVarMacro) {
                EclipseVariablesMacroSupplier.EclipseVarMacro eclipseVarMacro = (EclipseVariablesMacroSupplier.EclipseVarMacro)macro;
                IStringVariable var = eclipseVarMacro.getVariable();
                String value = null;
                value = var instanceof IDynamicVariable ? "dynamic<" + var.getName() + ">" : macro.getStringValue();
                return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macro.getName(), value);
            }
            return super.resolveMacro(macro);
        }
    }

    private class SystemContextInfo
    extends MacroUIMacroSontextInfo {
        protected SystemContextInfo(int contextType, Object contextData) {
            super(contextType, contextData);
        }

        protected IBuildMacroSupplier[] getSuppliers(int contextType, Object contextData) {
            IBuildMacroSupplier[] suppliers = super.getSuppliers(contextType, contextData);
            if (suppliers == null || suppliers.length == 0) {
                return null;
            }
            ArrayList<IBuildMacroSupplier> list = new ArrayList<IBuildMacroSupplier>();
            int i = 0;
            while (i < suppliers.length) {
                if (!(suppliers[i] instanceof UserDefinedMacroSupplier)) {
                    list.add(suppliers[i]);
                }
                ++i;
            }
            return list.toArray(new IBuildMacroSupplier[list.size()]);
        }

        public IMacroContextInfo getNext() {
            if (MacrosBlock.this.fUseDefaultParentContextInfo) {
                return super.getNext();
            }
            return MacrosBlock.this.fParentContextInfo;
        }
    }

    private class UIMacroSupplier
    implements IBuildMacroSupplier {
        private UIMacroSupplier() {
        }

        public IBuildMacro getMacro(String name, int contextType, Object contextData) {
            if (contextType != MacrosBlock.this.fContextType || contextData != MacrosBlock.this.fContextData) {
                return null;
            }
            return MacrosBlock.this.getUserMacro(name);
        }

        public IBuildMacro[] getMacros(int contextType, Object contextData) {
            if (contextType != MacrosBlock.this.fContextType || contextData != MacrosBlock.this.fContextData) {
                return null;
            }
            return MacrosBlock.this.getUserMacros();
        }
    }
}

