/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class LongString
implements IString {
    private final Database db;
    private final int record1;
    private static final int LENGTH = 0;
    private static final int NEXT1 = 4;
    private static final int CHARS1 = 8;
    private static final int NUM_CHARS1 = 8186;
    private static final int NEXTN = 0;
    private static final int CHARSN = 4;
    private static final int NUM_CHARSN = 8188;

    public LongString(Database db, int record1) {
        this.db = db;
        this.record1 = record1;
    }

    private int createString(int length, IWriter writer) throws CoreException {
        int firstRecord = this.db.malloc(16380);
        int start = 0;
        this.db.putInt(firstRecord, length);
        writer.writeChars(start, 8186, firstRecord + 8);
        int lastNext = firstRecord + 4;
        start += 8186;
        while (length - start > 8188) {
            int nextRecord = this.db.malloc(16380);
            this.db.putInt(lastNext, nextRecord);
            writer.writeChars(start, 8188, nextRecord + 4);
            start += 8188;
            lastNext = nextRecord + 0;
        }
        int finalRecord = this.db.malloc(4 + (length -= start) * 2);
        this.db.putInt(lastNext, finalRecord);
        writer.writeChars(start, length, finalRecord + 4);
        return firstRecord;
    }

    public LongString(Database db, final String string) throws CoreException {
        this.db = db;
        this.record1 = this.createString(string.length(), new IWriter(){

            public void writeChars(int start, int length, int p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, string.charAt(i));
                    p += 2;
                    ++i;
                }
            }
        });
    }

    public LongString(Database db, final char[] chars) throws CoreException {
        this.db = db;
        this.record1 = this.createString(chars.length, new IWriter(){

            public void writeChars(int start, int length, int p) throws CoreException {
                int i = start;
                while (i < start + length) {
                    LongString.this.db.putChar(p, chars[i]);
                    p += 2;
                    ++i;
                }
            }
        });
    }

    public int getRecord() {
        return this.record1;
    }

    public void delete() throws CoreException {
        int length = this.db.getInt(this.record1 + 0) - 8186;
        int nextRecord = this.db.getInt(this.record1 + 4);
        this.db.free(this.record1);
        while (length > 8188) {
            length -= 8188;
            int nextnext = this.db.getInt(nextRecord + 0);
            this.db.free(nextRecord);
            nextRecord = nextnext;
        }
        this.db.free(nextRecord);
    }

    public boolean equals(Object obj) {
        throw new PDOMNotImplementedError();
    }

    public int hashCode() {
        return this.record1;
    }

    public int compare(IString string) throws CoreException {
        if (string instanceof LongString) {
            return this.compare((LongString)string);
        }
        if (string instanceof ShortString) {
            return this.compare((ShortString)string);
        }
        throw new IllegalArgumentException();
    }

    public int compare(LongString string) throws CoreException {
        throw new PDOMNotImplementedError();
    }

    public int compare(ShortString string) throws CoreException {
        throw new PDOMNotImplementedError();
    }

    public int compare(String string) throws CoreException {
        throw new PDOMNotImplementedError();
    }

    public int compare(char[] chars) throws CoreException {
        throw new PDOMNotImplementedError();
    }

    private void readChars(int length, IReader reader) throws CoreException {
        int i;
        int p = this.record1 + 8;
        int i2 = 0;
        while (i2 < 8186) {
            reader.appendChar(this.db.getChar(p));
            p += 2;
            ++i2;
        }
        length -= 8186;
        int nextRecord = this.db.getInt(this.record1 + 4);
        while (length > 8188) {
            p = nextRecord + 4;
            i = 0;
            while (i < 8188) {
                reader.appendChar(this.db.getChar(p));
                p += 2;
                ++i;
            }
            length -= 8188;
            nextRecord = this.db.getInt(nextRecord + 0);
        }
        p = nextRecord + 4;
        i = 0;
        while (i < length) {
            reader.appendChar(this.db.getChar(p));
            p += 2;
            ++i;
        }
    }

    public char[] getChars() throws CoreException {
        int length = this.db.getInt(this.record1 + 0);
        final char[] chars = new char[length];
        this.readChars(length, new IReader(){
            int cp = 0;

            public void appendChar(char c) {
                chars[this.cp++] = c;
            }
        });
        return chars;
    }

    public String getString() throws CoreException {
        int length = this.db.getInt(this.record1 + 0);
        final StringBuffer buffer = new StringBuffer(length);
        this.readChars(length, new IReader(){

            public void appendChar(char c) {
                buffer.append(c);
            }
        });
        return buffer.toString();
    }

    private static interface IReader {
        public void appendChar(char var1);
    }

    private static interface IWriter {
        public void writeChars(int var1, int var2, int var3) throws CoreException;
    }
}

