/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer.full;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.full.PDOMFullIndexerJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PDOMFullHandleDelta
extends PDOMFullIndexerJob {
    private final ICElementDelta delta;
    private Map changed = new HashMap();
    private List added = new ArrayList();
    private List removed = new ArrayList();

    public PDOMFullHandleDelta(PDOMFullIndexer indexer, ICElementDelta delta) throws CoreException {
        super(indexer);
        this.delta = delta;
    }

    public void run(IProgressMonitor monitor) {
        try {
            long start = System.currentTimeMillis();
            this.processDelta(this.delta);
            int count = this.changed.size() + this.added.size() + this.removed.size();
            if (count > 0) {
                ITranslationUnit tu;
                Iterator<Object> i = this.changed.values().iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    tu = (ITranslationUnit)i.next();
                    try {
                        this.changeTU(tu);
                    }
                    catch (Throwable e) {
                        CCorePlugin.log(e);
                        if (++this.errorCount <= 10) continue;
                        return;
                    }
                }
                i = this.added.iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    tu = (ITranslationUnit)i.next();
                    try {
                        this.addTU(tu);
                    }
                    catch (Throwable e) {
                        CCorePlugin.log(e);
                        if (++this.errorCount <= 10) continue;
                        return;
                    }
                }
                i = this.removed.iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    tu = (ITranslationUnit)i.next();
                    this.removeTU(tu);
                }
                String showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings");
                if (showTimings != null && showTimings.equalsIgnoreCase("true")) {
                    System.out.println("PDOM Full Delta Time: " + (System.currentTimeMillis() - start));
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processDelta(ICElementDelta delta) throws CoreException {
        int flags = delta.getFlags();
        if ((flags & 8) != 0) {
            ICElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.processDelta(children[i]);
                ++i;
            }
        }
        ICElement element = delta.getElement();
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                switch (delta.getKind()) {
                    case 4: {
                        if ((flags & 1) == 0) return;
                        this.processTranslationUnit(tu);
                        break;
                    }
                    case 1: {
                        if (tu.isWorkingCopy()) return;
                        this.added.add(tu);
                        break;
                    }
                    case 2: {
                        if (tu.isWorkingCopy()) return;
                        this.removed.add(tu);
                    }
                }
                return;
            }
        }
    }

    protected void processTranslationUnit(ITranslationUnit tu) throws CoreException {
        PDOMFile[] includedBy;
        IPath path = tu.getUnderlyingResource().getLocation();
        PDOMFile pdomFile = this.pdom.getFile(path);
        boolean found = false;
        if (pdomFile != null && (includedBy = pdomFile.getAllIncludedBy()).length > 0) {
            IProject project = tu.getCProject().getProject();
            int i = 0;
            while (i < includedBy.length) {
                String incfilename = includedBy[i].getFileName().getString();
                if (CoreModel.isValidSourceUnitName(project, incfilename) && this.changed.get(incfilename) == null) {
                    IFile[] rfiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(incfilename));
                    int j = 0;
                    while (j < rfiles.length) {
                        if (rfiles[j].getProject().equals((Object)project)) {
                            ITranslationUnit inctu = (ITranslationUnit)CoreModel.getDefault().create(rfiles[j]);
                            this.changed.put(incfilename, inctu);
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (!found) {
            this.changed.put(path.toOSString(), tu);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        IASTTranslationUnit ast = this.parse(tu);
        if (ast == null) {
            return;
        }
        this.pdom.acquireWriteLock();
        try {
            IPath path = ((IFile)tu.getResource()).getLocation();
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
            IASTPreprocessorIncludeStatement[] includes = ast.getIncludeDirectives();
            int i = 0;
            while (true) {
                block7: {
                    if (i < includes.length) break block7;
                    this.addSymbols(tu.getLanguage(), ast);
                    break;
                }
                String incname = includes[i].getPath();
                PDOMFile incfile = this.pdom.getFile(incname);
                if (incfile != null) {
                    incfile.clear();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeTU(ITranslationUnit tu) throws CoreException, InterruptedException {
        this.pdom.acquireWriteLock();
        try {
            IPath path = ((IFile)tu.getResource()).getLocation();
            PDOMFile file = this.pdom.getFile(path);
            if (file != null) {
                file.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.pdom.releaseWriteLock();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.pdom.releaseWriteLock();
            return;
        }
    }
}

