/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.enablement.AndExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.CheckHolderExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.CheckOptionExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.CheckStringExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.FalseExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.IBooleanExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.NotExpression;
import org.eclipse.cdt.managedbuilder.internal.enablement.OrExpression;

public abstract class CompositeExpression
implements IBooleanExpression {
    private IBooleanExpression[] fChildren;

    protected CompositeExpression(IManagedConfigElement element) {
        IManagedConfigElement[] childElement = element.getChildren();
        IBooleanExpression[] children = new IBooleanExpression[childElement.length];
        int num = 0;
        int i = 0;
        while (i < childElement.length) {
            IBooleanExpression child = this.createExpression(childElement[i]);
            if (child != null) {
                children[num++] = child;
            }
            ++i;
        }
        if (num < children.length) {
            IBooleanExpression[] tmp = new IBooleanExpression[num];
            System.arraycopy(children, 0, tmp, 0, num);
            children = tmp;
        }
        this.fChildren = children;
    }

    protected IBooleanExpression createExpression(IManagedConfigElement element) {
        String name = element.getName();
        if ("and".equals(name)) {
            return new AndExpression(element);
        }
        if ("or".equals(name)) {
            return new OrExpression(element);
        }
        if ("not".equals(name)) {
            return new NotExpression(element);
        }
        if ("checkOption".equals(name)) {
            return new CheckOptionExpression(element);
        }
        if ("checkString".equals(name)) {
            return new CheckStringExpression(element);
        }
        if ("false".equals(name)) {
            return new FalseExpression(element);
        }
        if ("checkHolder".equals(name)) {
            return new CheckHolderExpression(element);
        }
        return null;
    }

    public IBooleanExpression[] getChildren() {
        return this.fChildren;
    }
}

