/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.ExplicitFileMacroCollector;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;

public class MacroResolver {
    private static final String EMPTY_STRING = "";
    public static final String MACRO_PREFIX = "${";
    public static final char MACRO_SUFFIX = '}';
    public static final char MACRO_ESCAPE_CHAR = '\\';
    private static final int MACRO_PREFIX_LENGTH = "${".length();
    private static final String PATTERN_MACRO_NAME = "=";

    public static String convertStringListToString(String[] value, String listDelimiter) {
        if (value == null || value.length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buffer.append(value[i]);
            if (listDelimiter != null && !EMPTY_STRING.equals(listDelimiter) && i < value.length - 1) {
                buffer.append(listDelimiter);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String resolveToString(String string, IMacroSubstitutor substitutor) throws BuildMacroException {
        return (String)MacroResolver.resolve(string, substitutor, false, false);
    }

    public static void checkMacros(String string, IMacroSubstitutor substitutor) throws BuildMacroException {
        MacroResolver.resolve(string, substitutor, false, true);
    }

    private static Object resolve(String string, IMacroSubstitutor substitutor, boolean asList, boolean checkOnly) throws BuildMacroException {
        if (string == null) {
            return EMPTY_STRING;
        }
        int macroStart = -1;
        int macroEnd = -1;
        int processed = 0;
        StringBuffer buffer = checkOnly ? null : new StringBuffer();
        boolean listMode = false;
        String[] listValue = null;
        int length = string.length();
        while (true) {
            String name;
            if ((macroStart = string.indexOf(MACRO_PREFIX, macroEnd + 1)) == -1) {
                if (buffer == null) break;
                buffer.append(string.substring(processed, length));
                break;
            }
            macroEnd = string.indexOf(125, macroStart);
            if (macroEnd == -1) {
                if (buffer == null) break;
                buffer.append(string.substring(processed, length));
                break;
            }
            if (asList && macroStart == 0 && macroEnd == length - 1) {
                listMode = true;
            }
            if (macroStart > 0 && '\\' == string.charAt(macroStart - 1)) {
                int num = macroStart - 2;
                while (num >= 0 && '\\' == string.charAt(num)) {
                    --num;
                }
                num = macroStart - num - 1;
                if (buffer != null) {
                    buffer.append(string.substring(processed, macroStart - (num + 1 >> 1)));
                }
                if ((num & 1) == 0) {
                    processed = macroStart;
                } else {
                    if (buffer != null) {
                        buffer.append(string.substring(macroStart, macroEnd + 1));
                    }
                    processed = macroEnd + 1;
                    continue;
                }
            }
            if (macroStart > processed && buffer != null) {
                buffer.append(string.substring(processed, macroStart));
            }
            if (!EMPTY_STRING.equals(name = string.substring(macroStart + MACRO_PREFIX_LENGTH, macroEnd))) {
                if (listMode) {
                    listValue = substitutor.resolveToStringList(name);
                    if (listValue == null) {
                        throw new BuildMacroException(1, null, string, name, 0, null);
                    }
                } else {
                    String resolved = substitutor.resolveToString(name);
                    if (resolved == null) {
                        throw new BuildMacroException(1, null, string, name, 0, null);
                    }
                    if (buffer != null) {
                        buffer.append(resolved);
                    }
                }
            }
            processed = macroEnd + 1;
        }
        if (asList) {
            String[] result = null;
            if (listMode) {
                result = listValue != null ? listValue : new String[]{};
            } else if (buffer != null) {
                result = new String[]{buffer.toString()};
            }
            return result;
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] resolveStringListValues(String[] values, IMacroSubstitutor substitutor, boolean ignoreErrors) throws BuildMacroException {
        String[] result = null;
        if (values == null) return values;
        if (values.length == 0) {
            return values;
        }
        if (values.length == 1) {
            try {
                return MacroResolver.resolveToStringList(values[0], substitutor);
            }
            catch (BuildMacroException e) {
                if (ignoreErrors) return result;
                throw e;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            block8: {
                try {
                    String[] resolved = MacroResolver.resolveToStringList(values[i], substitutor);
                    if (resolved != null && resolved.length > 0) {
                        list.addAll(Arrays.asList(resolved));
                    }
                }
                catch (BuildMacroException e) {
                    if (ignoreErrors) break block8;
                    throw e;
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] resolveToStringList(String string, IMacroSubstitutor substitutor) throws BuildMacroException {
        return (String[])MacroResolver.resolve(string, substitutor, true, false);
    }

    public static boolean isStringListMacro(int macroType) {
        switch (macroType) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static void checkIntegrity(IMacroContextInfo info, IMacroSubstitutor substitutor) throws BuildMacroException {
        IBuildMacro[] macros;
        if (info != null && (macros = BuildMacroProvider.getMacros(info, true)) != null) {
            int i = 0;
            while (i < macros.length) {
                IBuildMacro macro = macros[i];
                if (MacroResolver.isStringListMacro(macro.getMacroValueType())) {
                    substitutor.resolveToStringList(macro.getName());
                } else {
                    substitutor.resolveToString(macro.getName());
                }
                ++i;
            }
        }
    }

    public static String createMacroReference(String name) {
        return MACRO_PREFIX + name + '}';
    }

    public static boolean canKeepMacrosInBuildfile(IConfiguration cfg) {
        IToolChain toolChain;
        if (cfg != null && (toolChain = cfg.getToolChain()) != null) {
            return MacroResolver.canKeepMacrosInBuildfile(toolChain.getBuilder());
        }
        return false;
    }

    public static boolean canKeepMacrosInBuildfile(IBuilder builder) {
        String pattern;
        return builder != null && (pattern = builder.getBuilderVariablePattern()) != null && pattern.indexOf(PATTERN_MACRO_NAME) != -1;
    }

    public static String createBuildfileMacroReference(String name, IBuilder builder) {
        String pattern;
        String ref = null;
        if (builder != null && (pattern = builder.getBuilderVariablePattern()) != null && pattern.indexOf(PATTERN_MACRO_NAME) != -1) {
            ref = pattern.replaceAll(PATTERN_MACRO_NAME, name);
        }
        return ref;
    }

    public static String createBuildfileMacroReference(String name, IConfiguration cfg) {
        IToolChain toolChain;
        String ref = null;
        if (cfg != null && (toolChain = cfg.getToolChain()) != null) {
            ref = MacroResolver.createBuildfileMacroReference(name, toolChain.getBuilder());
        }
        return ref;
    }

    public static IBuildMacro[] getReferencedExplitFileMacros(ITool tool) {
        if (tool instanceof Tool) {
            Tool t = (Tool)tool;
            ExplicitFileMacroCollector collector = new ExplicitFileMacroCollector(tool);
            try {
                t.getToolCommandFlags(null, null, collector);
            }
            catch (BuildException buildException) {}
            return collector.getExplicisFileMacros();
        }
        return new IBuildMacro[0];
    }

    public static IBuildMacro[] getReferencedExplitFileMacros(String expression, int contextType, Object contextData) {
        ExplicitFileMacroCollector collector = new ExplicitFileMacroCollector(contextType, contextData);
        try {
            MacroResolver.resolveToString(expression, collector);
        }
        catch (BuildMacroException buildMacroException) {}
        return collector.getExplicisFileMacros();
    }

    public static IBuildMacro[] filterMacros(IBuildMacro[] macros, String[] remove) {
        if (macros == null || macros.length == 0) {
            return macros;
        }
        IBuildMacro[] filtered = new IBuildMacro[macros.length];
        int filteredNum = 0;
        int i = 0;
        while (i < macros.length) {
            IBuildMacro var = macros[i];
            String name = null;
            if (var != null && (name = EnvVarOperationProcessor.normalizeName(var.getName())) != null) {
                boolean skip = false;
                if (remove != null && remove.length > 0) {
                    int j = 0;
                    while (j < remove.length) {
                        if (remove[j] != null && remove[j].equals(name)) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!skip) {
                    filtered[filteredNum++] = var;
                }
            }
            ++i;
        }
        if (filteredNum != filtered.length) {
            IBuildMacro[] m = new IBuildMacro[filteredNum];
            int i2 = 0;
            while (i2 < filteredNum) {
                m[i2] = filtered[i2];
                ++i2;
            }
            filtered = m;
        }
        return filtered;
    }
}

