/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.PluginDropAdapter;

public class DelegatingDropAdapter
extends PluginDropAdapter {
    private TransferDropTargetListener[] fListeners;
    TransferDropTargetListener fCurrentListener;
    private int fOriginalDropType;

    public DelegatingDropAdapter(StructuredViewer viewer, TransferDropTargetListener[] listeners) {
        super(viewer);
        Assert.isNotNull((Object)listeners);
        this.fListeners = listeners;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fOriginalDropType = event.detail;
        this.updateCurrentListener(event);
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentListener(null, event);
    }

    public void dragOperationChanged(final DropTargetEvent event) {
        this.fOriginalDropType = event.detail;
        TransferDropTargetListener oldListener = this.getCurrentListener();
        this.updateCurrentListener(event);
        final TransferDropTargetListener newListener = this.getCurrentListener();
        if (newListener != null && newListener == oldListener) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    newListener.dragOperationChanged(event);
                }
            });
        }
        super.dragOperationChanged(event);
    }

    public void dragOver(final DropTargetEvent event) {
        TransferDropTargetListener oldListener = this.getCurrentListener();
        this.updateCurrentListener(event);
        final TransferDropTargetListener newListener = this.getCurrentListener();
        if (newListener != null) {
            if (newListener == oldListener) {
                Platform.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        newListener.dragOver(event);
                    }
                });
            }
        } else {
            super.dragOver(event);
        }
    }

    public void drop(final DropTargetEvent event) {
        this.updateCurrentListener(event);
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().drop(event);
                }
            });
        } else {
            super.drop(event);
        }
        this.setCurrentListener(null, event);
    }

    public void dropAccept(final DropTargetEvent event) {
        this.updateCurrentListener(event);
        if (this.getCurrentListener() != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.getCurrentListener().dropAccept(event);
                }
            });
        } else {
            super.dropAccept(event);
        }
        if (16 == event.detail) {
            event.detail = 1;
        }
    }

    TransferDropTargetListener getCurrentListener() {
        return this.fCurrentListener;
    }

    private TransferData getSupportedTransferType(TransferData[] dataTypes, TransferDropTargetListener listener) {
        int i = 0;
        while (i < dataTypes.length) {
            if (listener.getTransfer().isSupportedType(dataTypes[i])) {
                return dataTypes[i];
            }
            ++i;
        }
        return null;
    }

    public Transfer[] getTransfers() {
        Transfer[] types = new Transfer[this.fListeners.length];
        int i = 0;
        while (i < this.fListeners.length) {
            types[i] = this.fListeners[i].getTransfer();
            ++i;
        }
        return types;
    }

    private boolean setCurrentListener(TransferDropTargetListener listener, final DropTargetEvent event) {
        if (this.fCurrentListener == listener) {
            return false;
        }
        if (this.fCurrentListener != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragLeave(event);
                }
            });
        }
        this.fCurrentListener = listener;
        if (this.fCurrentListener != null) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    DelegatingDropAdapter.this.fCurrentListener.dragEnter(event);
                }
            });
        }
        return true;
    }

    private boolean updateCurrentListener(DropTargetEvent event) {
        int originalDetail = event.detail;
        event.detail = this.fOriginalDropType;
        int i = 0;
        while (i < this.fListeners.length) {
            TransferDropTargetListener listener = this.fListeners[i];
            TransferData dataType = this.getSupportedTransferType(event.dataTypes, listener);
            if (dataType != null) {
                TransferData originalDataType = event.currentDataType;
                event.currentDataType = dataType;
                if (listener.isEnabled(event)) {
                    if (!this.setCurrentListener(listener, event)) {
                        event.detail = originalDetail;
                    }
                    return true;
                }
                event.currentDataType = originalDataType;
            }
            ++i;
        }
        this.setCurrentListener(null, event);
        return false;
    }

    protected Object determineTarget(DropTargetEvent event) {
        Object dropTarget = super.determineTarget(event);
        if (dropTarget instanceof ICElement) {
            dropTarget = ((ICElement)dropTarget).getResource();
        }
        return dropTarget;
    }

    protected Object getCurrentTarget() {
        Object dropTarget = super.getCurrentTarget();
        if (dropTarget instanceof IContainer) {
            return dropTarget;
        }
        return null;
    }
}

