/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTVariable
extends ASTSymbol
implements IASTVariable {
    private final IASTExpression constructorExpression;
    private final ASTQualifiedNamedElement qualifiedName;
    private final IASTExpression bitfieldExpression;
    private final IASTInitializerClause initializerClause;
    private final IASTAbstractDeclaration abstractDeclaration;
    protected List references;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTVariable(ISymbol newSymbol, IASTAbstractDeclaration abstractDeclaration, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references, IASTExpression constructorExpression, boolean previouslyDeclared, char[] filename) {
        super(newSymbol);
        this.abstractDeclaration = abstractDeclaration;
        this.initializerClause = initializerClause;
        this.bitfieldExpression = bitfieldExpression;
        this.constructorExpression = constructorExpression;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.references = references;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), newSymbol.getName());
        this.fn = filename;
    }

    public boolean isAuto() {
        return this.symbol.getTypeInfo().checkBit(1);
    }

    public boolean isRegister() {
        return this.symbol.getTypeInfo().checkBit(2);
    }

    public boolean isStatic() {
        return this.symbol.getTypeInfo().checkBit(4);
    }

    public boolean isExtern() {
        return this.symbol.getTypeInfo().checkBit(8);
    }

    public boolean isMutable() {
        return this.symbol.getTypeInfo().checkBit(16);
    }

    public IASTAbstractDeclaration getAbstractDeclaration() {
        return this.abstractDeclaration;
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public IASTInitializerClause getInitializerClause() {
        return this.initializerClause;
    }

    public boolean isBitfield() {
        return this.bitfieldExpression != null;
    }

    public IASTExpression getBitfieldExpression() {
        return this.bitfieldExpression;
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.getSymbol().getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptVariable(this);
        }
        catch (Exception exception) {}
        Parser.processReferences(this.references, requestor);
        this.references = null;
        if (this.initializerClause != null) {
            this.initializerClause.acceptElement(requestor);
        }
        if (this.constructorExpression != null) {
            this.constructorExpression.acceptElement(requestor);
        }
        if (this.getAbstractDeclaration() != null) {
            this.getAbstractDeclaration().acceptElement(requestor);
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public IASTExpression getConstructorExpression() {
        return this.constructorExpression;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }
}

