/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

public class ReadMemoryAccess {
    byte[] bytes;
    int memOffset;
    byte[] val = new byte[8];
    boolean isle;

    public ReadMemoryAccess(byte[] octets) {
        this(octets, true);
    }

    public ReadMemoryAccess(byte[] octets, boolean le) {
        this.bytes = octets;
        this.memOffset = 0;
        this.isle = le;
    }

    public int getSize() {
        return this.bytes.length - this.memOffset;
    }

    public void getBytes(byte[] octets) {
        this.getBytes(octets, this.memOffset);
        this.memOffset += octets.length;
    }

    public void getBytes(byte[] octets, int offset) {
        this.getBytes(octets, offset, octets.length);
    }

    public void getBytes(byte[] octets, int offset, int length) {
        System.arraycopy(this.bytes, offset, octets, 0, length);
    }

    public byte getByte() {
        return this.getByte(this.memOffset++);
    }

    public short getUnsignedByte() {
        return this.getUnsignedByte(this.memOffset++);
    }

    public byte getByte(int offset) {
        return this.bytes[offset];
    }

    public short getUnsignedByte(int offset) {
        return this.bytes[offset];
    }

    public short getShort() {
        if (this.isle) {
            return this.getShortLE();
        }
        return this.getShortBE();
    }

    public int getUnsignedShort() {
        if (this.isle) {
            return this.getUnsignedShortLE();
        }
        return this.getUnsignedShortBE();
    }

    public short getShortLE() {
        short s = this.getShortLE(this.memOffset);
        this.memOffset += 2;
        return s;
    }

    public int getUnsignedShortLE() {
        int i = this.getUnsignedShortLE(this.memOffset);
        this.memOffset += 2;
        return i;
    }

    public short getShortLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getShortLE(this.val);
    }

    public static short getShortLE(byte[] b) {
        return (short)((b[1] & 0xFF) << 8 | b[0] & 0xFF);
    }

    public int getUnsignedShortLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getUnsignedShortLE(this.val);
    }

    public static int getUnsignedShortLE(byte[] b) {
        return (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public short getShortBE() {
        short s = this.getShortBE(this.memOffset);
        this.memOffset += 2;
        return s;
    }

    public int getUnsignedShortBE() {
        int i = this.getUnsignedShortBE(this.memOffset);
        this.memOffset += 2;
        return i;
    }

    public short getShortBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getShortBE(this.val);
    }

    public static short getShortBE(byte[] b) {
        return (short)((b[0] & 0xFF) << 8 | b[1] & 0xFF);
    }

    public int getUnsignedShortBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        return ReadMemoryAccess.getUnsignedShortBE(this.val);
    }

    public static int getUnsignedShortBE(byte[] b) {
        return ((b[0] & 0xFF) << 8) + (b[1] & 0xFF);
    }

    public int getInt() {
        if (this.isle) {
            return this.getIntLE();
        }
        return this.getIntBE();
    }

    public int getIntLE() {
        int i = this.getIntLE(this.memOffset);
        this.memOffset += 4;
        return i;
    }

    public long getUnsignedIntLE() {
        long l = this.getUnsignedIntLE(this.memOffset);
        this.memOffset += 4;
        return l;
    }

    public long getUnsignedIntLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getUnsignedIntLE(this.val);
    }

    public static long getUnsignedIntLE(byte[] b) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public int getIntLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getIntLE(this.val);
    }

    public static int getIntLE(byte[] b) {
        return (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
    }

    public int getIntBE() {
        int i = this.getIntBE(this.memOffset);
        this.memOffset += 4;
        return i;
    }

    public long getUnsignedIntBE() {
        long l = this.getUnsignedIntBE(this.memOffset);
        this.memOffset += 4;
        return l;
    }

    public int getIntBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getIntBE(this.val);
    }

    public static int getIntBE(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public long getUnsignedIntBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        return ReadMemoryAccess.getUnsignedIntBE(this.val);
    }

    public static long getUnsignedIntBE(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public long getLong() {
        if (this.isle) {
            return this.getLongLE();
        }
        return this.getLongBE();
    }

    public long getLongLE() {
        long l = this.getLongLE(this.memOffset);
        this.memOffset += 8;
        return l;
    }

    public long getLongLE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        this.val[4] = this.getByte(offset + 4);
        this.val[5] = this.getByte(offset + 5);
        this.val[6] = this.getByte(offset + 6);
        this.val[7] = this.getByte(offset + 7);
        return this.getLongLE(this.val);
    }

    public long getLongLE(byte[] b) {
        return (long)(b[7] & 0xFF) << 56 | (long)(b[6] & 0xFF) << 48 | (long)(b[5] & 0xFF) << 40 | (long)(b[4] & 0xFF) << 32 | (long)(b[3] & 0xFF) << 24 | (long)(b[2] & 0xFF) << 16 | (long)(b[1] & 0xFF) << 8 | (long)(b[0] & 0xFF);
    }

    public long getLongBE() {
        long l = this.getLongBE(this.memOffset);
        this.memOffset += 8;
        return l;
    }

    public long getLongBE(int offset) {
        this.val[0] = this.getByte(offset);
        this.val[1] = this.getByte(offset + 1);
        this.val[2] = this.getByte(offset + 2);
        this.val[3] = this.getByte(offset + 3);
        this.val[4] = this.getByte(offset + 4);
        this.val[5] = this.getByte(offset + 5);
        this.val[6] = this.getByte(offset + 6);
        this.val[7] = this.getByte(offset + 7);
        return this.getLongBE(this.val);
    }

    public long getLongBE(byte[] b) {
        return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)(b[5] & 0xFF) << 16 | (long)(b[6] & 0xFF) << 8 | (long)(b[7] & 0xFF);
    }
}

