/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.core.runtime.CoreException;

public class ShortString
implements IString {
    private final Database db;
    private final int record;
    private static final int LENGTH = 0;
    private static final int CHARS = 4;
    public static final int MAX_LENGTH = 8188;

    public ShortString(Database db, int offset) {
        this.db = db;
        this.record = offset;
    }

    public ShortString(Database db, char[] chars) throws CoreException {
        this.db = db;
        this.record = db.malloc(4 + chars.length * 2);
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0, (char)chars.length);
        int n = chars.length;
        int p = this.record + 4;
        int i = 0;
        while (i < n) {
            chunk.putChar(p, chars[i]);
            p += 2;
            ++i;
        }
    }

    public ShortString(Database db, String string) throws CoreException {
        this.db = db;
        this.record = db.malloc(4 + string.length() * 2);
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0, string.length());
        int n = string.length();
        int p = this.record + 4;
        int i = 0;
        while (i < n) {
            chunk.putChar(p, string.charAt(i));
            p += 2;
            ++i;
        }
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        this.db.free(this.record);
    }

    public char[] getChars() throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int length = chunk.getInt(this.record + 0);
        char[] chars = new char[length];
        int p = this.record + 4;
        int i = 0;
        while (i < length) {
            chars[i] = chunk.getChar(p);
            p += 2;
            ++i;
        }
        return chars;
    }

    public String getString() throws CoreException {
        return new String(this.getChars());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof ShortString) {
                int n2;
                ShortString string = (ShortString)obj;
                if (this.db == string.db && this.record == string.record) {
                    return true;
                }
                Chunk chunk1 = this.db.getChunk(this.record);
                Chunk chunk2 = string.db.getChunk(string.record);
                int n1 = chunk1.getInt(this.record);
                if (n1 != (n2 = chunk2.getInt(string.record))) {
                    return false;
                }
                int p1 = this.record + 4;
                int p2 = string.record + 4;
                int i = 0;
                while (i < n1) {
                    if (chunk1.getChar(p1) != chunk2.getChar(p2)) {
                        return false;
                    }
                    p1 += 2;
                    p2 += 2;
                    ++i;
                }
                return true;
            }
            if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                Chunk chunk = this.db.getChunk(this.record);
                int n = chunk.getInt(this.record);
                if (n != chars.length) {
                    return false;
                }
                int p = this.record + 4;
                int i = 0;
                while (i < n) {
                    if (chunk.getChar(p) != chars[i]) {
                        return false;
                    }
                    p += 2;
                    ++i;
                }
                return true;
            }
            if (obj instanceof String) {
                String string = (String)obj;
                Chunk chunk = this.db.getChunk(this.record);
                int n = chunk.getInt(this.record);
                if (n != string.length()) {
                    return false;
                }
                int p = this.record + 4;
                int i = 0;
                while (i < n) {
                    if (chunk.getChar(p) != string.charAt(i)) {
                        return false;
                    }
                    p += 2;
                    ++i;
                }
                return true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return false;
    }

    public int hashCode() {
        return this.record;
    }

    public int compare(IString string) throws CoreException {
        if (string instanceof ShortString) {
            return this.compare((ShortString)string);
        }
        if (string instanceof LongString) {
            return -((LongString)string).compare(this);
        }
        throw new IllegalArgumentException();
    }

    public int compare(ShortString other) throws CoreException {
        Chunk chunk1 = this.db.getChunk(this.record);
        Chunk chunk2 = other.db.getChunk(other.record);
        int i1 = this.record + 4;
        int i2 = other.record + 4;
        int n1 = i1 + chunk1.getInt(this.record + 0) * 2;
        int n2 = i2 + chunk2.getInt(other.record + 0) * 2;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 < (c2 = chunk2.getChar(i2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            i2 += 2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int compare(char[] other) throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk.getInt(this.record + 0) * 2;
        int n2 = other.length;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk.getChar(i1);
            if (c1 < (c2 = other[i2])) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int compare(String other) throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk.getInt(this.record + 0) * 2;
        int n2 = other.length();
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk.getChar(i1);
            if (c1 < (c2 = other.charAt(i2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }
}

