/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPMethod
extends PDOMBinding
implements ICPPMethod,
ICPPFunctionType {
    public static final int NUM_PARAMS = 24;
    public static final int FIRST_PARAM = 28;
    public static final int RECORD_SIZE = 32;

    public PDOMCPPMethod(PDOM pdom, PDOMMemberOwner parent, IASTName name) throws CoreException {
        super(pdom, (PDOMNode)parent, name);
        IASTNode parentNode = name.getParent();
        if (parentNode instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator funcDecl = (ICPPASTFunctionDeclarator)parentNode;
            IASTParameterDeclaration[] params = funcDecl.getParameters();
            pdom.getDB().putInt(this.record + 24, params.length);
            int i = 0;
            while (i < params.length) {
                ICPPASTParameterDeclaration param = (ICPPASTParameterDeclaration)params[i];
                IASTName paramName = param.getDeclarator().getName();
                IBinding binding = paramName.resolveBinding();
                ICPPParameter paramBinding = (ICPPParameter)binding;
                this.setFirstParameter(new PDOMCPPParameter(pdom, this, paramName, paramBinding));
                ++i;
            }
        }
    }

    public PDOMCPPMethod(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 7;
    }

    public PDOMCPPParameter getFirstParameter() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPParameter(this.pdom, rec) : null;
    }

    public void setFirstParameter(PDOMCPPParameter param) throws CoreException {
        if (param != null) {
            param.setNextParameter(this.getFirstParameter());
        }
        int rec = param != null ? param.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, rec);
    }

    public boolean isVirtual() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isDestructor() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isMutable() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isInline() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            int n = this.pdom.getDB().getInt(this.record + 24);
            IParameter[] params = new IParameter[n];
            PDOMCPPParameter param = this.getFirstParameter();
            while (param != null) {
                params[--n] = param;
                param = param.getNextParameter();
            }
            return params;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IParameter[0];
        }
    }

    public IScope getFunctionScope() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IFunctionType getType() throws DOMException {
        return this;
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public boolean isExtern() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isAuto() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isRegister() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean takesVarArgs() throws DOMException {
        return false;
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public int getVisibility() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPClassType getClassOwner() throws DOMException {
        try {
            return (ICPPClassType)((Object)this.getParentNode());
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public Object clone() {
        throw new PDOMNotImplementedError();
    }

    public IType[] getParameterTypes() throws DOMException {
        return new IType[0];
    }

    public IType getReturnType() throws DOMException {
        return null;
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() {
        return false;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof PDOMCPPMethod) {
            return this.getRecord() == ((PDOMCPPMethod)type).getRecordSize();
        }
        return false;
    }
}

