/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;

public class CModule
extends CDebugElement
implements ICModule {
    private int fType = 0;
    private ICElement fCElement;
    private ICDIObject fCDIObject;
    private IPath fImageName;
    private IPath fSymbolsFileName;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static CModule createExecutable(CDebugTarget target, IPath path) {
        return new CModule(1, target, path);
    }

    public static CModule createSharedLibrary(CDebugTarget target, ICDISharedLibrary lib) {
        return new CModule(2, target, lib);
    }

    private CModule(int type, CDebugTarget target, IPath path) {
        super(target);
        this.fType = type;
        this.fCElement = CoreModel.getDefault().create(path);
        this.fCDIObject = null;
        this.fImageName = path;
        this.fSymbolsFileName = path;
    }

    private CModule(int type, CDebugTarget target, ICDIObject cdiObject) {
        super(target);
        this.fType = type;
        if (cdiObject instanceof ICDISharedLibrary) {
            this.fCElement = CoreModel.getDefault().create((IPath)new Path(((ICDISharedLibrary)cdiObject).getFileName()));
        }
        this.fCDIObject = cdiObject;
        this.fSymbolsFileName = this.fImageName = cdiObject instanceof ICDISharedLibrary ? new Path(((ICDISharedLibrary)cdiObject).getFileName()) : new Path(CoreModelMessages.getString("CModule.0"));
    }

    public int getType() {
        return this.fType;
    }

    public String getName() {
        return this.fImageName.lastSegment().toString();
    }

    public IPath getImageName() {
        return this.fImageName;
    }

    public IPath getSymbolsFileName() {
        return this.fSymbolsFileName;
    }

    public void setSymbolsFileName(IPath symbolsFile) throws DebugException {
        this.loadSymbolsFromFile(symbolsFile);
        this.fSymbolsFileName = symbolsFile;
    }

    public IAddress getBaseAddress() {
        return this.fCDIObject instanceof ICDISharedLibrary ? this.getAddressFactory().createAddress(((ICDISharedLibrary)this.fCDIObject).getStartAddress()) : this.getAddressFactory().getZero();
    }

    public long getSize() {
        long result = 0L;
        if (this.fCDIObject instanceof ICDISharedLibrary) {
            BigInteger start = ((ICDISharedLibrary)this.fCDIObject).getStartAddress();
            BigInteger end = ((ICDISharedLibrary)this.fCDIObject).getEndAddress();
            if (end.compareTo(start) > 0) {
                result = end.subtract(start).longValue();
            }
        }
        return result;
    }

    public boolean areSymbolsLoaded() {
        return this.fCElement instanceof IBinary ? ((IBinary)this.fCElement).hasDebug() : (this.fCDIObject instanceof ICDISharedLibrary ? ((ICDISharedLibrary)this.fCDIObject).areSymbolsLoaded() : false);
    }

    public boolean canLoadSymbols() {
        return this.getDebugTarget().isSuspended() && !this.areSymbolsLoaded();
    }

    public void loadSymbols() throws DebugException {
        this.loadSymbolsFromFile(this.getSymbolsFileName());
    }

    public String getPlatform() {
        return this.fCElement instanceof IBinary ? ((IBinary)this.fCElement).getCPU() : CoreModelMessages.getString("CModule.1");
    }

    public boolean isLittleEndian() {
        return this.fCElement instanceof IBinary ? ((IBinary)this.fCElement).isLittleEndian() : ((CDebugTarget)this.getDebugTarget()).isLittleEndian();
    }

    public IAddressFactory getAddressFactory() {
        return ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
    }

    public String getCPU() {
        return this.fCElement instanceof IBinary ? ((IBinary)this.fCElement).getCPU() : null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getCElement();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.IBinary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(adapter) && this.getCElement() instanceof IBinary) {
            return this.getCElement();
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
    }

    public boolean equals(ICDIObject cdiObject) {
        return this.fCDIObject != null ? this.fCDIObject.equals(cdiObject) : false;
    }

    protected ICElement getCElement() {
        return this.fCElement;
    }

    private void loadSymbolsFromFile(IPath path) throws DebugException {
        if (path == null || path.isEmpty()) {
            CModule.requestFailed(CoreModelMessages.getString("CModule.2"), null);
        }
        String message = CoreModelMessages.getString("CModule.4");
        if (this.fCDIObject instanceof ICDISharedLibrary && path.equals((Object)this.getSymbolsFileName())) {
            try {
                ((ICDISharedLibrary)this.fCDIObject).loadSymbols();
                return;
            }
            catch (CDIException e) {
                message = e.getMessage();
            }
        }
        CModule.targetRequestFailed(message, null);
    }
}

