/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ToolListContentProvider
implements ITreeContentProvider {
    public static final int FILE = 1;
    public static final int PROJECT = 4;
    private IConfiguration configRoot;
    private IResourceConfiguration resConfigRoot;
    private int elementType;
    private ToolListElement[] elements;

    public void dispose() {
    }

    public ToolListContentProvider(int elementType) {
        this.elementType = elementType;
    }

    private ToolListElement[] createElements(IConfiguration config) {
        ArrayList<ToolListElement> elementList = new ArrayList<ToolListElement>();
        if (config != null) {
            ToolListElement e;
            IToolChain toolChain = config.getToolChain();
            IOptionCategory[] toolChainCategories = toolChain.getChildCategories();
            int i = 0;
            while (i < toolChainCategories.length) {
                e = new ToolListElement(null, (IHoldsOptions)toolChain, toolChainCategories[i]);
                elementList.add(e);
                this.createChildElements(e);
                ++i;
            }
            ITool[] filteredTools = config.getFilteredTools();
            i = 0;
            while (i < filteredTools.length) {
                e = new ToolListElement(filteredTools[i]);
                elementList.add(e);
                this.createChildElements(e);
                ++i;
            }
        }
        return elementList.toArray(new ToolListElement[elementList.size()]);
    }

    private ToolListElement[] createElements(IResourceConfiguration resConfig) {
        ArrayList<ToolListElement> elementList = new ArrayList<ToolListElement>();
        if (resConfig != null) {
            ITool[] tools = resConfig.getTools();
            int i = 0;
            while (i < tools.length) {
                ToolListElement e = new ToolListElement(tools[i]);
                elementList.add(e);
                this.createChildElements(e);
                ++i;
            }
        }
        return elementList.toArray(new ToolListElement[elementList.size()]);
    }

    private void createChildElements(ToolListElement parentElement) {
        IOptionCategory parent = parentElement.getOptionCategory();
        IHoldsOptions optHolder = parentElement.getHoldOptions();
        if (parent == null) {
            parent = parentElement.getTool().getTopOptionCategory();
            optHolder = parentElement.getTool();
        }
        IOptionCategory[] cats = parent.getChildCategories();
        int i = 0;
        while (i < cats.length) {
            ToolListElement e = new ToolListElement(parentElement, optHolder, cats[i]);
            parentElement.addChildElement(e);
            this.createChildElements(e);
            ++i;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConfiguration || parentElement instanceof IResourceConfiguration) {
            return this.elements;
        }
        return ((ToolListElement)parentElement).getChildElements();
    }

    public Object[] getElements(Object inputElement) {
        return this.elements;
    }

    public Object getParent(Object element) {
        return ((ToolListElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput == newInput) {
            return;
        }
        if (this.elementType == 1) {
            this.resConfigRoot = (IResourceConfiguration)newInput;
            this.configRoot = null;
            this.elements = this.createElements(this.resConfigRoot);
        } else if (this.elementType == 4) {
            this.configRoot = (IConfiguration)newInput;
            this.resConfigRoot = null;
            this.elements = this.createElements(this.configRoot);
        }
    }
}

