/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironment;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironmentLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class UserDefinedEnvironmentSupplier
extends StorableEnvironmentLoader
implements IEnvironmentVariableSupplier {
    public static final String NODENAME = "environment";
    public static final String PREFNAME_WORKSPACE = "workspace";
    public static final String PREFNAME_PROJECT = "project";
    public static final String NODENAME_CFG = "project";
    private static final String[] fNonOverloadableVariables = new String[]{EnvVarOperationProcessor.normalizeName("CWD"), EnvVarOperationProcessor.normalizeName("PWD")};
    private StorableEnvironment fWorkspaceVariables;

    protected StorableEnvironment getEnvironment(Object context) {
        return this.getEnvironment(context, true);
    }

    protected StorableEnvironment getEnvironment(Object context, boolean forceLoad) {
        if (context == null) {
            return null;
        }
        StorableEnvironment env = null;
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            env = ((ToolChain)cfg.getToolChain()).getUserDefinedEnvironment();
            if (env == null && forceLoad) {
                env = this.loadEnvironment(cfg);
                ((ToolChain)cfg.getToolChain()).setUserDefinedEnvironment(env);
            }
        } else if (context instanceof ManagedProject) {
            ManagedProject proj = (ManagedProject)context;
            env = proj.getUserDefinedEnvironmet();
            if (env == null && forceLoad) {
                env = this.loadEnvironment(proj);
                proj.setUserDefinedEnvironmet(env);
            }
        } else if (context instanceof IWorkspace) {
            if (this.fWorkspaceVariables == null && forceLoad) {
                this.fWorkspaceVariables = this.loadEnvironment(context);
            }
            env = this.fWorkspaceVariables;
        }
        return env;
    }

    protected StorableEnvironmentLoader.ISerializeInfo getSerializeInfo(Object context) {
        Preferences prefs;
        StorableEnvironmentLoader.ISerializeInfo serializeInfo = null;
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            IManagedProject project = cfg.getManagedProject();
            final Preferences prefs2 = project != null ? this.getConfigurationNode(project) : null;
            final String name = cfg.getId();
            if (prefs2 != null && name != null) {
                serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                    public Preferences getNode() {
                        return prefs2;
                    }

                    public String getPrefName() {
                        return name;
                    }
                };
            }
        } else if (context instanceof IManagedProject) {
            IManagedProject proj = (IManagedProject)context;
            final Preferences prefs3 = this.getProjectNode(proj);
            if (prefs3 != null && "project" != null) {
                serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                    public Preferences getNode() {
                        return prefs3;
                    }

                    public String getPrefName() {
                        return "project";
                    }
                };
            }
        } else if (context instanceof IWorkspace && (prefs = this.getWorkspaceNode()) != null && PREFNAME_WORKSPACE != null) {
            serializeInfo = new StorableEnvironmentLoader.ISerializeInfo(){

                public Preferences getNode() {
                    return prefs;
                }

                public String getPrefName() {
                    return UserDefinedEnvironmentSupplier.PREFNAME_WORKSPACE;
                }
            };
        }
        return serializeInfo;
    }

    private Preferences getConfigurationNode(IManagedProject managedProject) {
        Preferences prefNode = this.getProjectNode(managedProject);
        if (prefNode == null) {
            return null;
        }
        return prefNode.node("project");
    }

    private Preferences getProjectNode(IManagedProject managedProject) {
        IProject project = (IProject)managedProject.getOwner();
        if (!project.exists()) {
            return null;
        }
        IEclipsePreferences prefNode = new ProjectScope(project).getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    private Preferences getWorkspaceNode() {
        IEclipsePreferences prefNode = new InstanceScope().getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    public void checkInexistentConfigurations(IManagedProject managedProject) {
        Preferences prefNode = this.getConfigurationNode(managedProject);
        if (prefNode == null) {
            return;
        }
        try {
            String[] ids = prefNode.keys();
            boolean found = false;
            int i = 0;
            while (i < ids.length) {
                if (managedProject.getConfiguration(ids[i]) == null) {
                    prefNode.remove(ids[i]);
                    found = true;
                }
                ++i;
            }
            if (found) {
                prefNode.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void serialize(boolean force) {
        if (this.fWorkspaceVariables != null) {
            try {
                this.storeEnvironment(this.fWorkspaceVariables, ResourcesPlugin.getWorkspace(), force);
            }
            catch (CoreException coreException) {}
        }
    }

    public void storeEnvironment(Object context, boolean force) {
        StorableEnvironment env = this.getEnvironment(context, false);
        if (env != null) {
            try {
                this.storeEnvironment(env, context, force);
            }
            catch (CoreException coreException) {}
        }
    }

    public IBuildEnvironmentVariable getVariable(String name, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        return env.getVariable(name);
    }

    public IBuildEnvironmentVariable[] getVariables(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        return this.filterVariables(env.getVariables());
    }

    public IBuildEnvironmentVariable createVariable(String name, String value, int op, String delimiter, Object context) {
        if (this.getValidName(name) == null) {
            return null;
        }
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IBuildEnvironmentVariable var = env.createVariable(name, value, op, delimiter);
        if (env.isChanged()) {
            this.setRebuildStateForContext(context);
            env.setChanged(false);
        }
        return var;
    }

    public IBuildEnvironmentVariable deleteVariable(String name, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return null;
        }
        IBuildEnvironmentVariable var = env.deleteVariable(name);
        if (var != null) {
            this.setRebuildStateForContext(context);
        }
        return var;
    }

    public void deleteAll(Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        if (env.deleteAll()) {
            this.setRebuildStateForContext(context);
        }
    }

    public void setVariables(IBuildEnvironmentVariable[] vars, Object context) {
        StorableEnvironment env = this.getEnvironment(context);
        if (env == null) {
            return;
        }
        env.setVariales(vars);
        if (env.isChanged()) {
            this.setRebuildStateForContext(context);
            env.setChanged(false);
        }
    }

    protected void setRebuildStateForContext(Object context) {
        block6: {
            block7: {
                block5: {
                    if (context == null) {
                        return;
                    }
                    if (!(context instanceof IConfiguration)) break block5;
                    this.cfgVarsModified((IConfiguration)context);
                    break block6;
                }
                if (!(context instanceof IManagedProject)) break block7;
                IConfiguration[] cfgs = ((IManagedProject)context).getConfigurations();
                int i = 0;
                while (i < cfgs.length) {
                    this.cfgVarsModified(cfgs[i]);
                    ++i;
                }
                break block6;
            }
            if (!(context instanceof IWorkspace)) break block6;
            IProject[] projects = ((IWorkspace)context).getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IManagedBuildInfo info;
                if (ManagedBuildManager.manages((IResource)projects[i]) && (info = ManagedBuildManager.getBuildInfo((IResource)projects[i])) != null) {
                    IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
                    int j = 0;
                    while (j < cfgs.length) {
                        this.cfgVarsModified(cfgs[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void cfgVarsModified(IConfiguration cfg) {
        cfg.setRebuildState(true);
        EnvironmentVariableProvider.getDefault().checkBuildPathVariables(cfg);
    }

    protected String getValidName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        if (fNonOverloadableVariables != null) {
            int i = 0;
            while (i < fNonOverloadableVariables.length) {
                if (fNonOverloadableVariables[i].equals(EnvVarOperationProcessor.normalizeName(name))) {
                    return null;
                }
                ++i;
            }
        }
        return name;
    }

    protected IBuildEnvironmentVariable[] filterVariables(IBuildEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables(variables, fNonOverloadableVariables);
    }
}

