/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class CommandFactoryManager {
    private List fDescriptors = null;

    public CommandFactoryDescriptor[] getDescriptors() {
        List factories = this.getDescriptorList();
        return factories.toArray(new CommandFactoryDescriptor[factories.size()]);
    }

    public CommandFactoryDescriptor getDefaultDescriptor(String debuggerID) {
        CommandFactoryDescriptor[] descriptors = this.getDescriptors(debuggerID);
        return descriptors[0];
    }

    public CommandFactoryDescriptor[] getDescriptors(String debuggerID) {
        String platform = Platform.getOS();
        List all = this.getDescriptorList();
        ArrayList<CommandFactoryDescriptor> list = new ArrayList<CommandFactoryDescriptor>(all.size());
        Iterator it = all.iterator();
        while (it.hasNext()) {
            CommandFactoryDescriptor desc = (CommandFactoryDescriptor)it.next();
            if (!desc.getDebuggerIdentifier().equals(debuggerID) || !desc.supportsPlatform(platform)) continue;
            list.add(desc);
        }
        return list.toArray(new CommandFactoryDescriptor[list.size()]);
    }

    public CommandFactory getCommandFactory(String factoryID) throws CoreException {
        List all = this.getDescriptorList();
        Iterator it = all.iterator();
        while (it.hasNext()) {
            CommandFactoryDescriptor desc = (CommandFactoryDescriptor)it.next();
            if (!desc.getIdentifier().equals(factoryID)) continue;
            return desc.getCommandFactory();
        }
        return null;
    }

    private List getDescriptorList() {
        if (this.fDescriptors == null) {
            this.initializeDescriptorList();
        }
        return this.fDescriptors;
    }

    private synchronized void initializeDescriptorList() {
        if (this.fDescriptors == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MIPlugin.getUniqueIdentifier(), "commandFactories");
            IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
            this.fDescriptors = new ArrayList(infos.length);
            int i = 0;
            while (i < infos.length) {
                IConfigurationElement configurationElement = infos[i];
                CommandFactoryDescriptor factory = new CommandFactoryDescriptor(configurationElement);
                this.fDescriptors.add(factory);
                ++i;
            }
        }
    }
}

