/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTUsingDirective
extends ASTDeclaration
implements IASTUsingDirective {
    private final char[] fn;
    private final String namespaceName;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLine;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTUsingDirective(IASTScope scope, String name, int startingOffset, int startingLine, int endingOffset, int endingLine, char[] filename, int nStart, int nEnd, int nLine) {
        super(scope);
        this.namespaceName = name;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setEndingOffsetAndLineNumber(endingOffset, endingLine);
        this.fn = filename;
        this.setNameOffset(nStart);
        this.setNameEndOffsetAndLineNumber(nEnd, nLine);
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptUsingDirective(this);
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public IASTNamespaceDefinition getNamespaceDefinition() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public String getName() {
        return this.namespaceName;
    }

    public char[] getNameCharArray() {
        return this.namespaceName.toCharArray();
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLine = lineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLine;
    }
}

