/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CMemoryBlockExtension;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMemoryBlockRetrievalExtension
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String MEMORY_BLOCK_EXPRESSION = "expression";
    private static final String ATTR_MEMORY_BLOCK_EXPRESSION_TEXT = "text";
    CDebugTarget fDebugTarget;

    public CMemoryBlockRetrievalExtension(CDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public void initialize() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.cdt.launch.MEMORY_BLOCKS", "");
            if (memento != null && memento.trim().length() != 0) {
                this.initializeFromMemento(memento);
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
    }

    private void initializeFromMemento(String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            ArrayList<String> expressions = new ArrayList<String>();
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    String exp = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPRESSION_TEXT);
                    expressions.add(exp);
                }
                ++i;
            }
            this.createMemoryBlocks(expressions.toArray(new String[expressions.size()]));
            return;
        }
        this.abort(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.3"), null);
    }

    private void createMemoryBlocks(String[] expressions) {
        ArrayList<CMemoryBlockExtension> list = new ArrayList<CMemoryBlockExtension>(expressions.length);
        int i = 0;
        while (i < expressions.length) {
            IAddress address = this.getDebugTarget().getAddressFactory().createAddress(expressions[i]);
            if (address != null) {
                list.add(new CMemoryBlockExtension(this.getDebugTarget(), address.toHexAddressString(), address.getValue()));
            }
            ++i;
        }
        DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(list.toArray(new IMemoryBlock[list.size()]));
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)this.getDebugTarget());
        Document document = DebugPlugin.newDocument();
        Element element = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        int i = 0;
        while (i < blocks.length) {
            if (blocks[i] instanceof IMemoryBlockExtension) {
                Element child = document.createElement(MEMORY_BLOCK_EXPRESSION);
                try {
                    child.setAttribute(ATTR_MEMORY_BLOCK_EXPRESSION_TEXT, ((IMemoryBlockExtension)blocks[i]).getBigBaseAddress().toString());
                    element.appendChild(child);
                }
                catch (DebugException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
        document.appendChild(element);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object selected) throws DebugException {
        String address = null;
        CExpression exp = null;
        String msg = null;
        try {
            IDebugElement debugElement;
            CStackFrame frame;
            if (selected instanceof IDebugElement && (frame = this.getStackFrame(debugElement = (IDebugElement)selected)) != null) {
                ICDIExpression cdiExpression = frame.getCDITarget().createExpression(expression);
                exp = new CExpression(frame, cdiExpression, null);
                IValue value = exp.getValue();
                if (value instanceof ICValue) {
                    ICType type = ((ICValue)value).getType();
                    if (type != null && (type.isPointer() || type.isIntegralType())) {
                        address = value.getValueString();
                        exp.dispose();
                        IDebugTarget target = debugElement.getDebugTarget();
                        if (target instanceof CDebugTarget && address != null) {
                            BigInteger a = address.startsWith("0x") ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                            return new CMemoryBlockExtension((CDebugTarget)target, expression, a);
                        }
                    } else {
                        msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.1"), expression);
                    }
                } else {
                    msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.2"), expression);
                }
            }
        }
        catch (CDIException e) {
            msg = e.getMessage();
        }
        catch (NumberFormatException numberFormatException) {
            msg = MessageFormat.format(InternalDebugCoreMessages.getString("CMemoryBlockRetrievalExtension.0"), expression, address);
        }
        throw new DebugException((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        String expression = Long.toHexString(startAddress);
        BigInteger address = new BigInteger(expression, 16);
        expression = "0x" + expression;
        return new CMemoryBlockExtension(this.getDebugTarget(), expression, address);
    }

    private CStackFrame getStackFrame(IDebugElement selected) throws DebugException {
        IStackFrame frame;
        if (selected instanceof CStackFrame) {
            return (CStackFrame)selected;
        }
        if (selected instanceof CThread && (frame = ((CThread)selected).getTopStackFrame()) instanceof CStackFrame) {
            return (CStackFrame)frame;
        }
        return null;
    }

    public void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.MEMORY_BLOCKS", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e.getStatus());
        }
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    public void dispose() {
    }
}

