/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class SCMarkerGenerator
implements IMarkerGenerator {
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        try {
            IMarker[] cur = file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == lineNumber && sev == this.mapMarkerSeverity(severity) && mesg.equals(errorDesc)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = file.createMarker("org.eclipse.cdt.core.problem");
            marker.setAttribute("location", lineNumber);
            marker.setAttribute("message", (Object)errorDesc);
            marker.setAttribute("severity", this.mapMarkerSeverity(severity));
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (errorVar != null) {
                marker.setAttribute("problem.variable", (Object)errorVar);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    public void removeMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        IWorkspace workspace = file.getWorkspace();
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.cdt.core.problem", false, 1);
            if (markers != null) {
                ArrayList<IMarker> exactMarkers = new ArrayList<IMarker>();
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    int location = (Integer)marker.getAttribute("location");
                    String error = (String)marker.getAttribute("message");
                    int sev = (Integer)marker.getAttribute("severity");
                    if (location == lineNumber && errorDesc.equals(error) && sev == severity) {
                        exactMarkers.add(marker);
                    }
                    ++i;
                }
                if (exactMarkers.size() > 0) {
                    workspace.deleteMarkers(exactMarkers.toArray(new IMarker[exactMarkers.size()]));
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }
}

